/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.util.Set;
import java.util.StringTokenizer;

public final class MethodDescr
extends MemberDescription {
    public static final MethodDescr[] EMPTY_ARRAY = new MethodDescr[0];
    private Object annoDef;

    public MethodDescr() {
        super(MemberType.METHOD, '.');
    }

    public MethodDescr(String string, String string2, int n) {
        super(MemberType.METHOD, '.');
        this.setupMemberName(string, string2);
        this.setModifiers(n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof MethodDescr)) {
            return false;
        }
        MethodDescr methodDescr = (MethodDescr)object;
        return this.name == methodDescr.name && this.args.equals(methodDescr.args) && SwissKnife.equals(this.typeParameters, methodDescr.typeParameters);
    }

    public int hashCode() {
        return this.name.hashCode() + this.args.hashCode() + (this.typeParameters != null ? this.typeParameters.hashCode() : 0);
    }

    public boolean isCompatible(MemberDescription memberDescription) {
        if (!this.equals(memberDescription)) {
            throw new IllegalArgumentException("Only equal members can be checked for compatibility!");
        }
        return this.memberType.isCompatible(this.getModifiers(), memberDescription.getModifiers()) && this.type.equals(memberDescription.type) && this.throwables.equals(memberDescription.throwables);
    }

    public boolean isMethod() {
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("method");
        String string = Modifier.toString(this.memberType, this.getModifiers(), true);
        if (string.length() != 0) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        if (this.typeParameters != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.typeParameters);
        }
        if (this.type.length() != 0) {
            stringBuffer.append(' ');
            stringBuffer.append(this.type);
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.declaringClass);
        stringBuffer.append(this.delimiter);
        stringBuffer.append(this.name);
        stringBuffer.append('(');
        stringBuffer.append(this.args);
        stringBuffer.append(')');
        if (this.throwables.length() > 0) {
            stringBuffer.append(" throws ");
            stringBuffer.append(this.throwables);
        }
        AnnotationItem[] annotationItemArray = this.getAnnoList();
        int n = 0;
        while (n < annotationItemArray.length) {
            stringBuffer.append("\n ");
            stringBuffer.append(annotationItemArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append('(');
        stringBuffer.append(this.args);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public Object getAnnoDef() {
        return this.annoDef;
    }

    public void setAnnoDef(Object object) {
        this.annoDef = object;
    }

    protected void populateDependences(Set set) {
        this.addDependency(set, this.type);
        StringTokenizer stringTokenizer = new StringTokenizer(this.args, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.addDependency(set, stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(this.throwables, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.addDependency(set, stringTokenizer.nextToken());
        }
    }
}

