/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.classpath.ClasspathImpl;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.ClassHierarchyImpl;
import com.sun.tdk.signaturetest.core.ClassSet;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.plugin.Filter;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.Writer;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Setup
extends SigTest {
    public static final String CLOSEDFILE_OPTION = "-ClosedFile";
    public static final String NONCLOSEDFILE_OPTION = "-NonClosedFile";
    public static final String CHECKVALUE_OPTION = "-CheckValue";
    public static final String XGENCONSTS_OPTION = "-XgenConsts";
    public static final String COPYRIGHT_OPTION = "-CopyRight";
    public static final String KEEP_SIGFILE_OPTION = "-KeepFile";
    public static final String XREFLECTION_OPTION = "-Xreflection";
    protected URL signatureFile;
    private static I18NResourceBundle i18n;
    protected boolean isClosedFile = true;
    private Boolean explicitlyGenConsts = null;
    private boolean keepSigFile = false;
    private String copyrightStr = null;
    private int outerClassesNumber = 0;
    private int innerClassesNumber = 0;
    private int includedClassesNumber = 0;
    private int excludedClassesNumber = 0;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$Setup;

    public static void main(String[] args) {
        Setup t = new Setup();
        t.run(args, new PrintWriter(System.err, true), null);
        t.exit();
    }

    public void run(String[] args, PrintWriter pw, PrintWriter ref) {
        this.setLog(pw);
        this.outerClassesNumber = 0;
        this.innerClassesNumber = 0;
        this.includedClassesNumber = 0;
        this.excludedClassesNumber = 0;
        MemberType.setMode(false);
        if (this.parseParameters(args)) {
            this.afterParseParameters();
            this.create(this.signatureFile);
            this.getLog().flush();
        } else if (args.length > 0 && args[0].equalsIgnoreCase("-Version")) {
            pw.println(Version.getVersionInfo());
        } else {
            this.usage();
        }
    }

    protected boolean parseParameters(String[] args) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        if (args == null || args.length == 0 || args.length == 1 && (parser.isOptionSpecified(args[0], "-Help") || parser.isOptionSpecified(args[0], "-?") || parser.isOptionSpecified(args[0], "-Version"))) {
            return false;
        }
        String optionsDecoder = "decodeOptions";
        parser.addOption("-Package", OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-Classpath", OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption("-FileName", OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption("-TestURL", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-PackageWithoutSubpackages", OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-Exclude", OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-ApiVersion", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-Static", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-ClassCacheSize", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-Debug", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-XnoTiger", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Xverbose", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Verbose", OptionInfo.optionVariableParams(0, 1), "decodeOptions");
        parser.addOption(CLOSEDFILE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(NONCLOSEDFILE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(KEEP_SIGFILE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(CHECKVALUE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(XGENCONSTS_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption(XREFLECTION_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-AllPublic", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Help", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-?", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Version", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Plugin", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-ErrorAll", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(COPYRIGHT_OPTION, OptionInfo.option(1), "decodeOptions");
        try {
            parser.processArgs(args);
        }
        catch (CommandLineParserException e) {
            this.getLog().println(e.getMessage());
            return this.failed(e.getMessage());
        }
        this.isStatic = true;
        if (parser.isOptionSpecified(XREFLECTION_OPTION) && !parser.isOptionSpecified("-Static")) {
            this.isStatic = false;
        }
        if (parser.isOptionSpecified(NONCLOSEDFILE_OPTION) && parser.isOptionSpecified(CLOSEDFILE_OPTION)) {
            return this.error(i18n.getString("Setup.error.mode.contradict", new Object[]{NONCLOSEDFILE_OPTION, CLOSEDFILE_OPTION}));
        }
        if (this.packages.isEmpty() && this.purePackages.isEmpty()) {
            this.packages.addPackage("");
        }
        if (this.sigFileName == null) {
            return this.error(i18n.getString("Setup.error.filename.missing"));
        }
        if (parser.isOptionSpecified("-TestURL") && new File(this.sigFileName).isAbsolute()) {
            return this.error(i18n.getString("Setup.error.testurl.absolutepath", new Object[]{"-TestURL", this.sigFileName}));
        }
        try {
            this.signatureFile = FileManager.getURL(this.testURL, this.sigFileName);
        }
        catch (MalformedURLException e) {
            if (SigTest.debug) {
                SwissKnife.reportThrowable(e);
            }
            System.err.println(e);
            return this.error(i18n.getString("Setup.error.url.invalid"));
        }
        if (this.classpathStr == null) {
            return this.error(i18n.getString("Setup.error.arg.unspecified", "-Classpath"));
        }
        return this.passed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase(CLOSEDFILE_OPTION)) {
            this.isClosedFile = true;
            return;
        } else if (optionName.equalsIgnoreCase(NONCLOSEDFILE_OPTION)) {
            this.isClosedFile = false;
            return;
        } else if (optionName.equalsIgnoreCase(KEEP_SIGFILE_OPTION)) {
            this.keepSigFile = true;
            return;
        } else {
            if (optionName.equalsIgnoreCase(CHECKVALUE_OPTION)) return;
            if (optionName.equalsIgnoreCase(XGENCONSTS_OPTION)) {
                String v = args[0];
                if ("on".equalsIgnoreCase(v)) {
                    this.explicitlyGenConsts = Boolean.TRUE;
                    return;
                } else {
                    if (!"off".equalsIgnoreCase(v)) throw new CommandLineParserException(i18n.getString("Setup.error.arg.invalidval", XGENCONSTS_OPTION));
                    this.explicitlyGenConsts = Boolean.FALSE;
                }
                return;
            } else if (optionName.equalsIgnoreCase(XREFLECTION_OPTION)) {
                this.isStatic = false;
                return;
            } else if (optionName.equalsIgnoreCase(COPYRIGHT_OPTION)) {
                this.copyrightStr = args[0];
                return;
            } else {
                super.decodeCommonOptions(optionName, args);
            }
        }
    }

    private void afterParseParameters() {
        if (this.explicitlyGenConsts != null) {
            this.setConstantValuesTracked(this.explicitlyGenConsts);
        } else {
            this.setConstantValuesTracked(this.isStatic);
        }
    }

    protected void usage() {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(this.getComponentName() + " - " + i18n.getString("Setup.usage.version", "3.0"));
        sb.append(nl).append(i18n.getString("Setup.usage.start"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Setup.usage.classpath", "-Classpath"));
        sb.append(nl).append(i18n.getString("Setup.usage.package", "-Package"));
        sb.append(nl).append(i18n.getString("Setup.usage.filename", "-FileName"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Setup.usage.testurl", "-TestURL"));
        sb.append(nl).append(i18n.getString("Setup.usage.packagewithoutsubpackages", "-PackageWithoutSubpackages"));
        sb.append(nl).append(i18n.getString("Setup.usage.exclude", "-Exclude"));
        sb.append(nl).append(i18n.getString("Setup.usage.nonclosedfile", NONCLOSEDFILE_OPTION));
        sb.append(nl).append(i18n.getString("Setup.usage.apiversion", "-ApiVersion"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Setup.usage.verbose", new Object[]{"-Verbose", "nowarn"}));
        sb.append(nl).append(i18n.getString("Setup.usage.debug", "-Debug"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Setup.helpusage.version", "-Version"));
        sb.append(nl).append(i18n.getString("Setup.usage.help", "-Help"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Setup.usage.end"));
        System.err.println(sb.toString());
    }

    protected String getComponentName() {
        return "Setup";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean create(URL sigFile) {
        TreeSet<String> excludedClasses;
        block51: {
            Writer writer;
            FileOutputStream fos;
            block50: {
                List sortedClasses;
                Iterator i;
                String name;
                this.initErrors();
                if (this.pluginClass != null) {
                    this.pluginClass.init(this);
                }
                HashSet<String> allClasses = new HashSet<String>();
                this.getLog().println(i18n.getString("Setup.log.classpath", this.classpathStr));
                try {
                    this.classpath = new ClasspathImpl(this.classpathStr);
                }
                catch (SecurityException e) {
                    if (SigTest.debug) {
                        SwissKnife.reportThrowable(e);
                    }
                    this.getLog().println(i18n.getString("Setup.log.invalid.security.classpath"));
                    this.getLog().println(e);
                    return this.error(i18n.getString("Setup.log.invalid.security.classpath"));
                }
                this.classpath.printErrors(this.getLog());
                while (this.classpath.hasNext()) {
                    name = this.classpath.nextClassName();
                    if (allClasses.add(name)) continue;
                    this.getLog().println(i18n.getString("Setup.log.duplicate.class", name));
                }
                this.classpath.setListToBegin();
                ClassDescriptionLoader testableLoader = this.getClassDescrLoader();
                this.testableHierarchy = new ClassHierarchyImpl(testableLoader, this.trackMode);
                this.testableMCBuilder = new MemberCollectionBuilder(this);
                this.getLog().println(i18n.getString("Setup.log.constantchecking", this.isConstantValuesTracked() ? i18n.getString("Setup.msg.ConstantValuesTracked.on") : i18n.getString("Setup.msg.ConstantValuesTracked.off")));
                this.getLog().println(i18n.getString("Setup.log.message.numclasses", Integer.toString(allClasses.size())));
                Collection packageClasses = this.getPackageClasses(allClasses);
                if (this.isClosedFile) {
                    ClassSet closedSetOfClasses = new ClassSet(this.testableHierarchy, true);
                    Iterator i2 = packageClasses.iterator();
                    while (i2.hasNext()) {
                        name = (String)i2.next();
                        closedSetOfClasses.addClass(name);
                    }
                    HashSet<String> invisibleClasses = new HashSet<String>();
                    Set classes = closedSetOfClasses.getClasses();
                    Iterator i3 = classes.iterator();
                    while (i3.hasNext()) {
                        name = (String)i3.next();
                        ClassDescription c = this.load(name);
                        if (this.testableHierarchy.isAccessible(c)) continue;
                        invisibleClasses.add(name);
                    }
                    i = invisibleClasses.iterator();
                    while (i.hasNext()) {
                        closedSetOfClasses.removeClass((String)i.next());
                    }
                    sortedClasses = this.sortClasses(closedSetOfClasses.getClasses());
                } else {
                    sortedClasses = this.sortClasses(packageClasses);
                }
                excludedClasses = new TreeSet<String>();
                fos = null;
                writer = null;
                writer = this.getFileManager().getDefaultFormat().getWriter();
                fos = new FileOutputStream(sigFile.getFile());
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
                writer.init(new PrintWriter(osw));
                writer.setApiVersion(this.apiVersion);
                if (this.isConstantValuesTracked()) {
                    writer.addFeature(FeaturesHolder.ConstInfo);
                }
                if (SigTest.isTigerFeaturesTracked) {
                    writer.addFeature(FeaturesHolder.TigerInfo);
                }
                if (this.copyrightStr != null) {
                    FeaturesHolder.CopyRight.setText("# " + this.copyrightStr);
                    writer.addFeature(FeaturesHolder.CopyRight);
                }
                writer.writeHeader();
                Erasurator erasurator = new Erasurator();
                i = sortedClasses.iterator();
                while (i.hasNext()) {
                    Filter f;
                    Transformer t;
                    name = (String)i.next();
                    ClassDescription c = this.load(name);
                    if (!this.testableHierarchy.isAccessible(c)) continue;
                    if (this.excludedPackages.checkName(name)) {
                        excludedClasses.add(name);
                        continue;
                    }
                    if (name.indexOf(36) < 0) {
                        ++this.outerClassesNumber;
                    } else {
                        ++this.innerClassesNumber;
                    }
                    try {
                        this.testableMCBuilder.createMembers(c, this.addInherited(), true, false);
                        this.normalizer.normThrows(c, true);
                        this.removeUndocumentedAnnotations(c, this.testableHierarchy);
                    }
                    catch (ClassNotFoundException e) {
                        if (SigTest.debug) {
                            SwissKnife.reportThrowable(e);
                        }
                        this.setupProblem(i18n.getString("Setup.error.message.classnotfound", e.getMessage()));
                    }
                    if (this.useErasurator()) {
                        c = erasurator.erasure(c);
                    }
                    if ((t = PluginAPI.BEFORE_WRITE.getTransformer()) != null) {
                        try {
                            c = t.transform(c);
                        }
                        catch (ClassNotFoundException ex) {
                            // empty catch block
                        }
                    }
                    if ((f = PluginAPI.BEFORE_WRITE.getFilter()) != null && !f.accept(c)) continue;
                    writer.write(c);
                }
                Object var17_24 = null;
                if (writer == null) break block50;
                writer.close();
            }
            try {
                if (fos != null) {
                    fos.close();
                }
                break block51;
            }
            catch (IOException ex) {
                SwissKnife.reportThrowable(ex);
            }
            break block51;
            {
                catch (IOException e) {
                    if (SigTest.debug) {
                        SwissKnife.reportThrowable(e);
                    }
                    this.getLog().println(i18n.getString("Setup.error.message.cantcreatesigfile"));
                    this.getLog().println(e);
                    boolean erasurator = this.error(i18n.getString("Setup.error.message.cantcreatesigfile"));
                    Object var17_25 = null;
                    if (writer != null) {
                        writer.close();
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException ex) {
                        SwissKnife.reportThrowable(ex);
                    }
                    return erasurator;
                }
            }
            catch (Throwable throwable) {
                Object var17_26 = null;
                if (writer != null) {
                    writer.close();
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ex) {
                    SwissKnife.reportThrowable(ex);
                }
                throw throwable;
            }
        }
        this.printErrors();
        this.getLog().println(i18n.getString("Setup.report.message.selectedbypackageclasses", Integer.toString(this.includedClassesNumber + this.excludedClassesNumber)));
        if (!this.excludedPackages.isEmpty()) {
            this.getLog().println(i18n.getString("Setup.report.message.excludedbypackageclasses", Integer.toString(this.excludedClassesNumber)));
        }
        if (this.isClosedFile && excludedClasses.size() != 0) {
            boolean printHeader = true;
            Iterator it = excludedClasses.iterator();
            while (it.hasNext()) {
                String clsName = (String)it.next();
                String[] subClasses = this.testableHierarchy.getDirectSubclasses(clsName);
                if (subClasses.length <= 0) continue;
                int count = 0;
                int idx = 0;
                while (idx < subClasses.length) {
                    if (!excludedClasses.contains(subClasses[idx])) {
                        if (count != 0) {
                            this.getLog().print(", ");
                        } else {
                            if (printHeader) {
                                this.getLog().println(i18n.getString("Setup.log.message.exclude_warning_header"));
                                printHeader = false;
                            }
                            this.getLog().println(i18n.getString("Setup.log.message.exclude_warning", clsName));
                        }
                        this.getLog().print(subClasses[idx]);
                        ++count;
                    }
                    ++idx;
                }
                this.getLog().println();
            }
        }
        this.getLog().print(i18n.getString("Setup.report.message.outerclasses", Integer.toString(this.outerClassesNumber)));
        if (this.innerClassesNumber != 0) {
            this.getLog().println(i18n.getString("Setup.report.message.innerclasses", Integer.toString(this.innerClassesNumber)));
        } else {
            this.getLog().println();
        }
        if (this.errors == 0) {
            return this.passed(this.outerClassesNumber == 0 ? i18n.getString("Setup.report.message.emptysigfile") : "");
        }
        if (!this.keepSigFile) {
            new File(sigFile.getFile()).delete();
        }
        return this.failed(i18n.getString("Setup.report.message.numerrors", Integer.toString(this.errors)));
    }

    private void removeUndocumentedAnnotations(ClassDescription c, ClassHierarchy classHierarchy) {
        c.setAnnoList(this.removeUndocumentedAnnotations(c.getAnnoList(), classHierarchy));
        Iterator e = c.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            mr.setAnnoList(this.removeUndocumentedAnnotations(mr.getAnnoList(), classHierarchy));
        }
    }

    private Collection getPackageClasses(Collection classes) {
        HashSet<String> packageClasses = new HashSet<String>();
        int nonTigerCount = 0;
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (this.isPackageMember(name)) {
                ++this.includedClassesNumber;
                try {
                    ClassDescription c = this.testableHierarchy.load(name);
                    if (this.testableHierarchy.isAccessible(c)) {
                        packageClasses.add(name);
                        if (c.isTiger()) continue;
                        ++nonTigerCount;
                        if (!SigTest.Xverbose || !SigTest.isTigerFeaturesTracked) continue;
                        this.getLog().println(i18n.getString("Setup.report.message.nontigerclass", name));
                        continue;
                    }
                    this.ignore(i18n.getString("Setup.report.ignore.protect", name));
                }
                catch (ClassNotFoundException ex) {
                    if (SigTest.debug) {
                        SwissKnife.reportThrowable(ex);
                    }
                    this.setupProblem(i18n.getString("Setup.error.message.classnotfound", name));
                }
                catch (LinkageError ex1) {
                    if (SigTest.debug) {
                        SwissKnife.reportThrowable(ex1);
                    }
                    this.setupProblem(i18n.getString("Setup.error.message.classnotlinked", ex1.getMessage()));
                }
                continue;
            }
            if (!this.excludedPackages.isEmpty() && this.excludedPackages.checkName(name)) {
                ++this.excludedClassesNumber;
            }
            this.ignore(i18n.getString("Setup.report.ignore.notreqpackage", name));
        }
        return packageClasses;
    }

    private List sortClasses(Collection classes) {
        ArrayList retVal = new ArrayList();
        retVal.addAll(classes);
        Collections.sort(retVal);
        return retVal;
    }

    protected void ignore(String message) {
        if (this.isVerbose) {
            this.getLog().println(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CLOSEDFILE_OPTION = CLOSEDFILE_OPTION;
        NONCLOSEDFILE_OPTION = NONCLOSEDFILE_OPTION;
        CHECKVALUE_OPTION = CHECKVALUE_OPTION;
        XGENCONSTS_OPTION = XGENCONSTS_OPTION;
        COPYRIGHT_OPTION = COPYRIGHT_OPTION;
        KEEP_SIGFILE_OPTION = KEEP_SIGFILE_OPTION;
        XREFLECTION_OPTION = XREFLECTION_OPTION;
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$Setup == null ? (class$com$sun$tdk$signaturetest$Setup = Setup.class$("com.sun.tdk.signaturetest.Setup")) : class$com$sun$tdk$signaturetest$Setup);
    }
}

