/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import java.io.DataInputStream;
import java.io.IOException;

public class AnnotationItemEx
extends AnnotationItem {
    public static final String ANNOTATION_EX_PREFIX = "typeAnno";
    private int targetType;
    private int parameterIndex;
    private int boundIndex;
    private int typeIndex;
    private String path;
    private boolean tracked = true;
    public static final int TARGET_CLASS_TYPE_PARAMETER = 0;
    public static final int TARGET_METHOD_TYPE_PARAMETER = 1;
    public static final int TARGET_CLASS_EXTENDS = 16;
    public static final int TARGET_CLASS_TYPE_PARAMETER_BOUND = 17;
    public static final int TARGET_METHOD_TYPE_PARAMETER_BOUND = 18;
    public static final int TARGET_FIELD = 19;
    public static final int TARGET_METHOD_RETURN = 20;
    public static final int TARGET_METHOD_RECEIVER = 21;
    public static final int TARGET_METHOD_FORMAL_PARAMETER = 22;
    public static final int TARGET_THROWS = 23;
    public static final int TARGET_LOCAL_VARIABLE = 64;
    public static final int TARGET_RESOURCE_VARIABLE = 65;
    public static final int TARGET_EXCEPTION_PARAMETER = 66;
    public static final int TARGET_INSTANCEOF = 67;
    public static final int TARGET_NEW = 68;
    public static final int TARGET_CONSTRUCTOR_REFERENCE = 69;
    public static final int TARGET_METHOD_REFERENCE = 70;
    public static final int TARGET_CAST = 71;
    public static final int TARGET_CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = 72;
    public static final int TARGET_METHOD_INVOCATION_TYPE_ARGUMENT = 73;
    public static final int TARGET_CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = 74;
    public static final int TARGET_METHOD_REFERENCE_TYPE_ARGUMENT = 75;
    public static final String ANN_TARGET_TYPE = "target";
    public static final String ANN_TYPE_IND = "type";
    public static final String ANN_BOUND_IND = "bound";
    public static final String ANN_PARAM_IND = "param";
    public static final String ANN_PATH = "path";

    public AnnotationItemEx(int target) {
        super(target);
    }

    public AnnotationItemEx() {
    }

    public void parseBinaryDescription(DataInputStream is) throws IllegalStateException, IOException {
        int target_type = is.readUnsignedByte();
        this.setTargetType(target_type);
        switch (target_type) {
            case 0: 
            case 1: {
                this.setParameterIndex(is.readUnsignedByte()).setTracked(true);
                break;
            }
            case 16: {
                this.setTypeIndex(is.readUnsignedShort()).setTracked(true);
                break;
            }
            case 17: 
            case 18: {
                this.setParameterIndex(is.readUnsignedByte()).setBoundIndex(is.readUnsignedByte()).setTracked(true);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                this.setTracked(true);
                break;
            }
            case 22: {
                this.setParameterIndex(is.readUnsignedByte()).setTracked(true);
                break;
            }
            case 23: {
                this.setTypeIndex(is.readUnsignedShort()).setTracked(true);
                break;
            }
            case 64: 
            case 65: {
                int table_length = is.readUnsignedShort();
                int i = 0;
                while (i < table_length) {
                    is.readUnsignedShort();
                    is.readUnsignedShort();
                    is.readUnsignedShort();
                    ++i;
                }
                this.setTracked(false);
                break;
            }
            case 66: {
                is.readUnsignedByte();
                this.setTracked(false);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                is.readUnsignedShort();
                this.setTracked(false);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                is.readUnsignedShort();
                is.readUnsignedByte();
                this.setTracked(false);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type " + AnnotationItemEx.intToHex(target_type));
            }
        }
        int path_length = is.readUnsignedByte();
        if (path_length > 0) {
            StringBuffer p = new StringBuffer();
            int i = 0;
            while (i < path_length) {
                if (p.length() > 0) {
                    p.append('-');
                }
                int i1 = is.readUnsignedByte();
                p.append(Integer.toHexString(i1));
                p.append(':');
                int i2 = is.readUnsignedByte();
                p.append(Integer.toHexString(i2));
                ++i;
            }
            this.setPath(p.toString());
        }
    }

    public int getTargetType() {
        return this.targetType;
    }

    public AnnotationItemEx setTargetType(int target_type) {
        this.targetType = target_type;
        return this;
    }

    public boolean getTracked() {
        return this.tracked;
    }

    public AnnotationItemEx setTracked(boolean tracked) {
        this.tracked = tracked;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public AnnotationItemEx setPath(String path) {
        this.path = path;
        return this;
    }

    public AnnotationItemEx addToPath(String part) {
        this.path = this.path == null ? part : this.path + "-" + part;
        return this;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public AnnotationItemEx setParameterIndex(int parameterIndex) {
        this.parameterIndex = parameterIndex;
        return this;
    }

    public int getBoundIndex() {
        return this.boundIndex;
    }

    public AnnotationItemEx setBoundIndex(int boundIndex) {
        this.boundIndex = boundIndex;
        return this;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public AnnotationItemEx setTypeIndex(int typeIndex) {
        this.typeIndex = typeIndex;
        return this;
    }

    protected String getSpecificData() {
        StringBuffer sb = new StringBuffer();
        this.addTargetType(sb);
        switch (this.targetType) {
            case 0: 
            case 1: {
                this.addParameterInd(sb);
                break;
            }
            case 16: {
                this.addTypeInd(sb);
                break;
            }
            case 17: 
            case 18: {
                this.addParameterInd(sb);
                this.addBoundInd(sb);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                this.addParameterInd(sb);
                break;
            }
            case 23: {
                this.addTypeInd(sb);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type " + AnnotationItemEx.intToHex(this.targetType));
            }
        }
        this.addPath(sb);
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    private void addTargetType(StringBuffer sb) {
        sb.append("[target=" + AnnotationItemEx.intToHex(this.targetType) + ";");
    }

    private void addTypeInd(StringBuffer sb) {
        sb.append("type=" + this.typeIndex + ";");
    }

    private void addBoundInd(StringBuffer sb) {
        sb.append("bound=" + this.boundIndex + ";");
    }

    private void addParameterInd(StringBuffer sb) {
        sb.append("param=" + this.parameterIndex + ";");
    }

    private void addPath(StringBuffer sb) {
        if (this.path != null) {
            sb.append("path=" + this.path + ";");
        }
    }

    public static String intToHex(int i) {
        String s = Integer.toHexString(i).toUpperCase();
        if (s.length() == 1) {
            s = "0" + s;
        }
        return "0x" + s;
    }

    private String arrayToString(int[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuffer b = new StringBuffer();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(",");
            ++i;
        }
    }

    protected String getPrefix() {
        return ANNOTATION_EX_PREFIX;
    }

    static {
        ANNOTATION_EX_PREFIX = ANNOTATION_EX_PREFIX;
        TARGET_CLASS_TYPE_PARAMETER = 0;
        TARGET_METHOD_TYPE_PARAMETER = 1;
        TARGET_CLASS_EXTENDS = 16;
        TARGET_CLASS_TYPE_PARAMETER_BOUND = 17;
        TARGET_METHOD_TYPE_PARAMETER_BOUND = 18;
        TARGET_FIELD = 19;
        TARGET_METHOD_RETURN = 20;
        TARGET_METHOD_RECEIVER = 21;
        TARGET_METHOD_FORMAL_PARAMETER = 22;
        TARGET_THROWS = 23;
        TARGET_LOCAL_VARIABLE = 64;
        TARGET_RESOURCE_VARIABLE = 65;
        TARGET_EXCEPTION_PARAMETER = 66;
        TARGET_INSTANCEOF = 67;
        TARGET_NEW = 68;
        TARGET_CONSTRUCTOR_REFERENCE = 69;
        TARGET_METHOD_REFERENCE = 70;
        TARGET_CAST = 71;
        TARGET_CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = 72;
        TARGET_METHOD_INVOCATION_TYPE_ARGUMENT = 73;
        TARGET_CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = 74;
        TARGET_METHOD_REFERENCE_TYPE_ARGUMENT = 75;
        ANN_TARGET_TYPE = ANN_TARGET_TYPE;
        ANN_TYPE_IND = ANN_TYPE_IND;
        ANN_BOUND_IND = ANN_BOUND_IND;
        ANN_PARAM_IND = ANN_PARAM_IND;
        ANN_PATH = ANN_PATH;
    }
}

