/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

import com.sun.webkit.ContextMenu;
import com.sun.webkit.MethodHelper;
import com.sun.webkit.Pasteboard;
import com.sun.webkit.PopupMenu;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Set;

public abstract class Utilities {
    private static Utilities instance;
    private static final Set<String> CLASS_METHODS_ALLOW_LIST;
    private static final Set<String> CLASSES_REJECT_LIST;
    private static final List<String> PACKAGES_REJECT_LIST;

    public static synchronized void setUtilities(Utilities utilities) {
        instance = utilities;
    }

    public static synchronized Utilities getUtilities() {
        return instance;
    }

    protected abstract Pasteboard createPasteboard();

    protected abstract PopupMenu createPopupMenu();

    protected abstract ContextMenu createContextMenu();

    private static Object fwkInvokeWithContext(Method method, Object object, Object[] objectArray, AccessControlContext accessControlContext) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.equals(Class.class)) {
            if (!CLASS_METHODS_ALLOW_LIST.contains(method.getName())) {
                throw new UnsupportedOperationException("invocation not supported");
            }
        } else {
            String string = clazz.getName();
            if (CLASSES_REJECT_LIST.contains(string)) {
                throw new UnsupportedOperationException("invocation not supported");
            }
            PACKAGES_REJECT_LIST.forEach(string2 -> {
                if (string.startsWith(string2 + ".")) {
                    throw new UnsupportedOperationException("invocation not supported");
                }
            });
        }
        try {
            return AccessController.doPrivileged(() -> MethodHelper.invoke(method, object, objectArray), accessControlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable == null) {
                throwable = privilegedActionException;
            } else if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            throw throwable;
        }
    }

    static {
        CLASS_METHODS_ALLOW_LIST = Set.of("getCanonicalName", "getEnumConstants", "getFields", "getMethods", "getName", "getPackageName", "getSimpleName", "getSuperclass", "getTypeName", "getTypeParameters", "isAssignableFrom", "isArray", "isEnum", "isInstance", "isInterface", "isLocalClass", "isMemberClass", "isPrimitive", "isSynthetic", "toGenericString", "toString");
        CLASSES_REJECT_LIST = Set.of("java.lang.ClassLoader", "java.lang.Module", "java.lang.Runtime", "java.lang.System");
        PACKAGES_REJECT_LIST = List.of("java.lang.invoke", "java.lang.module", "java.lang.reflect", "java.security", "sun.misc");
    }
}

