/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.EventLoop;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.mac.MacAccessible;
import com.sun.glass.ui.mac.MacCommonDialogs;
import com.sun.glass.ui.mac.MacCursor;
import com.sun.glass.ui.mac.MacPixels;
import com.sun.glass.ui.mac.MacRobot;
import com.sun.glass.ui.mac.MacTimer;
import com.sun.glass.ui.mac.MacView;
import com.sun.glass.ui.mac.MacWindow;
import com.sun.javafx.util.Logging;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javafx.scene.paint.Color;

final class MacApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    private String applicationClassName;
    private boolean isTaskbarApplication = false;
    private final InvokeLaterDispatcher invokeLaterDispatcher;
    private Menu appleMenu;
    private final CountDownLatch reactivationLatch = new CountDownLatch(1);
    private boolean firstDidResignActive = false;
    private static final String SUPPRESS_AWT_WARNING_PROPERTY = "javafx.preferences.suppressAppleAwtWarning";
    private static final String AWT_APPEARANCE_PROPERTY = "apple.awt.application.appearance";
    private static final String AWT_APPLICATION_CLASS = "NSApplicationAWT";
    private static final String AWT_SYSTEM_APPEARANCE = "system";
    private boolean checkSystemAppearance = AccessController.doPrivileged(() -> !Boolean.getBoolean(SUPPRESS_AWT_WARNING_PROPERTY));

    private static native void _initIDs(boolean var0);

    static native int _getMacKey(int var0);

    MacApplication() {
        boolean bl = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        if (!bl) {
            this.invokeLaterDispatcher = new InvokeLaterDispatcher(this);
            this.invokeLaterDispatcher.start();
        } else {
            this.invokeLaterDispatcher = null;
        }
    }

    native void _runLoop(ClassLoader var1, Runnable var2, boolean var3);

    @Override
    protected void runLoop(Runnable runnable) {
        boolean bl;
        Runnable runnable2 = () -> {
            if (this.isTriggerReactivation()) {
                this.waitForReactivation();
            }
            this.applicationClassName = this._getApplicationClassName();
            runnable.run();
        };
        this.isTaskbarApplication = bl = AccessController.doPrivileged(() -> {
            String string = System.getProperty("glass.taskbarApplication");
            return !"false".equalsIgnoreCase(string);
        }).booleanValue();
        ClassLoader classLoader = MacApplication.class.getClassLoader();
        this._runLoop(classLoader, runnable2, this.isTaskbarApplication);
    }

    void waitForReactivation() {
        EventLoop eventLoop = this.createEventLoop();
        Thread thread = new Thread(() -> {
            try {
                if (!this.reactivationLatch.await(5L, TimeUnit.SECONDS)) {
                    Logging.getJavaFXLogger().warning("Timeout while waiting for app reactivation");
                }
            }
            catch (InterruptedException interruptedException) {
                Logging.getJavaFXLogger().warning("Exception while waiting for app reactivation: " + String.valueOf(interruptedException));
            }
            Application.invokeLater(() -> eventLoop.leave(null));
        });
        thread.setDaemon(true);
        thread.start();
        eventLoop.enter();
    }

    private native void _finishTerminating();

    @Override
    protected void finishTerminating() {
        this._finishTerminating();
        super.finishTerminating();
    }

    private void notifyApplicationDidTerminate() {
        MacApplication.setEventThread(null);
    }

    @Override
    protected void notifyDidResignActive() {
        this.firstDidResignActive = true;
        super.notifyDidResignActive();
    }

    @Override
    protected void notifyDidBecomeActive() {
        if (this.firstDidResignActive) {
            this.reactivationLatch.countDown();
        }
        super.notifyDidBecomeActive();
    }

    private void setEventThread() {
        MacApplication.setEventThread(Thread.currentThread());
    }

    private native Object _enterNestedEventLoopImpl();

    @Override
    protected Object _enterNestedEventLoop() {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        }
        try {
            Object object = this._enterNestedEventLoopImpl();
            return object;
        }
        finally {
            if (this.invokeLaterDispatcher != null) {
                this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
            }
        }
    }

    private native void _leaveNestedEventLoopImpl(Object var1);

    @Override
    protected void _leaveNestedEventLoop(Object object) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        }
        this._leaveNestedEventLoopImpl(object);
    }

    private native void _hide();

    private native void _hideOtherApplications();

    private native void _unhideAllApplications();

    public void installAppleMenu(MenuBar menuBar) {
        this.appleMenu = this.createMenu("Apple");
        MenuItem menuItem = this.createMenuItem("Hide " + this.getName(), new MenuItem.Callback(){

            @Override
            public void action() {
                MacApplication.this._hide();
            }

            @Override
            public void validate() {
            }
        }, 104, 16);
        this.appleMenu.add(menuItem);
        MenuItem menuItem2 = this.createMenuItem("Hide Others", new MenuItem.Callback(){

            @Override
            public void action() {
                MacApplication.this._hideOtherApplications();
            }

            @Override
            public void validate() {
            }
        }, 104, 24);
        this.appleMenu.add(menuItem2);
        MenuItem menuItem3 = this.createMenuItem("Show All", new MenuItem.Callback(){

            @Override
            public void action() {
                MacApplication.this._unhideAllApplications();
            }

            @Override
            public void validate() {
            }
        });
        this.appleMenu.add(menuItem3);
        this.appleMenu.add(MenuItem.Separator);
        MenuItem menuItem4 = this.createMenuItem("Quit " + this.getName(), new MenuItem.Callback(){

            @Override
            public void action() {
                Application.EventHandler eventHandler = MacApplication.this.getEventHandler();
                if (eventHandler != null) {
                    eventHandler.handleQuitAction(Application.GetApplication(), System.nanoTime());
                }
            }

            @Override
            public void validate() {
            }
        }, 113, 16);
        this.appleMenu.add(menuItem4);
        menuBar.add(this.appleMenu);
    }

    public Menu getAppleMenu() {
        return this.appleMenu;
    }

    @Override
    public void installDefaultMenus(MenuBar menuBar) {
        this.installAppleMenu(menuBar);
    }

    @Override
    public Window createWindow(Window window, Screen screen, int n) {
        return new MacWindow(window, screen, n);
    }

    @Override
    public View createView() {
        return new MacView();
    }

    @Override
    public Cursor createCursor(int n) {
        return new MacCursor(n);
    }

    @Override
    public Cursor createCursor(int n, int n2, Pixels pixels) {
        return new MacCursor(n, n2, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean bl) {
        MacCursor.setVisible_impl(bl);
    }

    @Override
    protected Size staticCursor_getBestSize(int n, int n2) {
        return MacCursor.getBestSize_impl(n, n2);
    }

    @Override
    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer) {
        return new MacPixels(n, n2, byteBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer, float f, float f2) {
        return new MacPixels(n, n2, byteBuffer, f, f2);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer) {
        return new MacPixels(n, n2, intBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer, float f, float f2) {
        return new MacPixels(n, n2, intBuffer, f, f2);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return MacPixels.getNativeFormat_impl();
    }

    @Override
    public GlassRobot createRobot() {
        return new MacRobot();
    }

    @Override
    protected native double staticScreen_getVideoRefreshPeriod();

    @Override
    protected native Screen[] staticScreen_getScreens();

    @Override
    public Timer createTimer(Runnable runnable) {
        return new MacTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return MacTimer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return MacTimer.getMaxPeriod_impl();
    }

    @Override
    public Accessible createAccessible() {
        return new MacAccessible();
    }

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window window, String string, String string2, String string3, int n, boolean bl, CommonDialogs.ExtensionFilter[] extensionFilterArray, int n2) {
        return MacCommonDialogs.showFileChooser_impl(window, string, string2, string3, n, bl, extensionFilterArray, n2);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window window, String string, String string2) {
        return MacCommonDialogs.showFolderChooser_impl(window, string, string2);
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return MacView.getMultiClickTime_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return MacView.getMultiClickMaxX_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return MacView.getMultiClickMaxY_impl();
    }

    @Override
    protected native void _invokeAndWait(Runnable var1);

    private native void _submitForLaterInvocation(Runnable var1);

    @Override
    public void submitForLaterInvocation(Runnable runnable) {
        this._submitForLaterInvocation(runnable);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeLater(runnable);
        } else {
            this.submitForLaterInvocation(runnable);
        }
    }

    @Override
    protected boolean _supportsInputMethods() {
        return true;
    }

    @Override
    protected boolean _supportsTransparentWindows() {
        return true;
    }

    @Override
    protected boolean _supportsUnifiedWindows() {
        return true;
    }

    @Override
    protected native boolean _supportsSystemMenu();

    private native boolean _isTriggerReactivation();

    boolean isTriggerReactivation() {
        return this._isTriggerReactivation();
    }

    private native String _getDataDirectory();

    @Override
    public String getDataDirectory() {
        MacApplication.checkEventThread();
        String string = this._getDataDirectory();
        if (string == null || string.length() == 0) {
            return super.getDataDirectory();
        }
        return string + File.separator + this.name + File.separator;
    }

    @Override
    protected native int _getKeyCodeForChar(char var1, int var2);

    @Override
    protected native int _isKeyLocked(int var1);

    private native String _getApplicationClassName();

    @Override
    public native Map<String, Object> getPlatformPreferences();

    @Override
    public Map<String, String> getPlatformKeyMappings() {
        return Map.of("macOS.NSColor.textColor", "foregroundColor", "macOS.NSColor.textBackgroundColor", "backgroundColor", "macOS.NSColor.controlAccentColor", "accentColor");
    }

    @Override
    public Map<String, Class<?>> getPlatformKeys() {
        return Map.ofEntries(Map.entry("macOS.NSColor.labelColor", Color.class), Map.entry("macOS.NSColor.secondaryLabelColor", Color.class), Map.entry("macOS.NSColor.tertiaryLabelColor", Color.class), Map.entry("macOS.NSColor.quaternaryLabelColor", Color.class), Map.entry("macOS.NSColor.textColor", Color.class), Map.entry("macOS.NSColor.placeholderTextColor", Color.class), Map.entry("macOS.NSColor.selectedTextColor", Color.class), Map.entry("macOS.NSColor.textBackgroundColor", Color.class), Map.entry("macOS.NSColor.selectedTextBackgroundColor", Color.class), Map.entry("macOS.NSColor.keyboardFocusIndicatorColor", Color.class), Map.entry("macOS.NSColor.unemphasizedSelectedTextColor", Color.class), Map.entry("macOS.NSColor.unemphasizedSelectedTextBackgroundColor", Color.class), Map.entry("macOS.NSColor.linkColor", Color.class), Map.entry("macOS.NSColor.separatorColor", Color.class), Map.entry("macOS.NSColor.selectedContentBackgroundColor", Color.class), Map.entry("macOS.NSColor.unemphasizedSelectedContentBackgroundColor", Color.class), Map.entry("macOS.NSColor.selectedMenuItemTextColor", Color.class), Map.entry("macOS.NSColor.gridColor", Color.class), Map.entry("macOS.NSColor.headerTextColor", Color.class), Map.entry("macOS.NSColor.alternatingContentBackgroundColors", Color[].class), Map.entry("macOS.NSColor.controlAccentColor", Color.class), Map.entry("macOS.NSColor.controlColor", Color.class), Map.entry("macOS.NSColor.controlBackgroundColor", Color.class), Map.entry("macOS.NSColor.controlTextColor", Color.class), Map.entry("macOS.NSColor.disabledControlTextColor", Color.class), Map.entry("macOS.NSColor.selectedControlColor", Color.class), Map.entry("macOS.NSColor.selectedControlTextColor", Color.class), Map.entry("macOS.NSColor.alternateSelectedControlTextColor", Color.class), Map.entry("macOS.NSColor.currentControlTint", String.class), Map.entry("macOS.NSColor.windowBackgroundColor", Color.class), Map.entry("macOS.NSColor.windowFrameTextColor", Color.class), Map.entry("macOS.NSColor.underPageBackgroundColor", Color.class), Map.entry("macOS.NSColor.findHighlightColor", Color.class), Map.entry("macOS.NSColor.highlightColor", Color.class), Map.entry("macOS.NSColor.shadowColor", Color.class), Map.entry("macOS.NSColor.systemBlueColor", Color.class), Map.entry("macOS.NSColor.systemBrownColor", Color.class), Map.entry("macOS.NSColor.systemGrayColor", Color.class), Map.entry("macOS.NSColor.systemGreenColor", Color.class), Map.entry("macOS.NSColor.systemIndigoColor", Color.class), Map.entry("macOS.NSColor.systemOrangeColor", Color.class), Map.entry("macOS.NSColor.systemPinkColor", Color.class), Map.entry("macOS.NSColor.systemPurpleColor", Color.class), Map.entry("macOS.NSColor.systemRedColor", Color.class), Map.entry("macOS.NSColor.systemTealColor", Color.class), Map.entry("macOS.NSColor.systemYellowColor", Color.class));
    }

    @Override
    public void checkPlatformPreferencesSupport() {
        String string;
        if (this.checkSystemAppearance && AWT_APPLICATION_CLASS.equals(this.applicationClassName) && !AWT_SYSTEM_APPEARANCE.equals(string = AccessController.doPrivileged(() -> System.getProperty(AWT_APPEARANCE_PROPERTY)))) {
            Logging.getJavaFXLogger().warning(String.format("Reported preferences may not reflect macOS system preferences unless the system%nproperty %s=%s is set. This warning can be disabled by%nsetting %s=true.", AWT_APPEARANCE_PROPERTY, AWT_SYSTEM_APPEARANCE, SUPPRESS_AWT_WARNING_PROPERTY));
        }
        this.checkSystemAppearance = false;
    }

    static {
        Void void_ = AccessController.doPrivileged(() -> {
            Application.loadNativeLibrary();
            return null;
        });
        boolean bl = AccessController.doPrivileged(() -> Boolean.getBoolean("glass.disableSyncRendering"));
        MacApplication._initIDs(bl);
    }
}

