/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import javafx.util.StringConverter;
import jfx.incubator.scene.control.richtext.model.ParagraphDirection;

public class Converters {
    public static StringConverter<Boolean> booleanConverter() {
        return new StringConverter<Boolean>(){

            public String toString(Boolean bl) {
                return null;
            }

            public Boolean fromString(String string) {
                return Boolean.TRUE;
            }
        };
    }

    public static StringConverter<Color> colorConverter() {
        return new StringConverter<Color>(){

            public String toString(Color color) {
                return Converters.toHexColor(color);
            }

            public Color fromString(String string) {
                return Converters.parseHexColor(string);
            }
        };
    }

    public static StringConverter<ParagraphDirection> paragraphDirectionConverter() {
        return new StringConverter<ParagraphDirection>(){

            public String toString(ParagraphDirection paragraphDirection) {
                return Converters.fromParagraphDirection(paragraphDirection);
            }

            public ParagraphDirection fromString(String string) {
                return Converters.toParagraphDirection(string);
            }
        };
    }

    public static StringConverter<TextAlignment> textAlignmentConverter() {
        return new StringConverter<TextAlignment>(){

            public String toString(TextAlignment textAlignment) {
                return Converters.fromTextAlignment(textAlignment);
            }

            public TextAlignment fromString(String string) {
                return Converters.toTextAlignment(string);
            }
        };
    }

    public static StringConverter<String> stringConverter() {
        return new StringConverter<String>(){

            public String toString(String string) {
                return string;
            }

            public String fromString(String string) {
                return string;
            }
        };
    }

    private static Color parseHexColor(String string) {
        double d = switch (string.length()) {
            case 8 -> (double)Converters.parseByte(string, 6) / 255.0;
            case 6 -> 1.0;
            default -> throw new IllegalArgumentException("unable to parse color: " + string);
        };
        int n = Converters.parseByte(string, 0);
        int n2 = Converters.parseByte(string, 2);
        int n3 = Converters.parseByte(string, 4);
        return Color.rgb((int)n, (int)n2, (int)n3, (double)d);
    }

    protected static String toHexColor(Color color) {
        return Converters.toHex8(color.getRed()) + Converters.toHex8(color.getGreen()) + Converters.toHex8(color.getBlue()) + (color.getOpacity() == 1.0 ? "" : Converters.toHex8(color.getOpacity()));
    }

    private static String toHex8(double d) {
        int n = (int)Math.round(255.0 * d);
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return String.format("%02X", n);
    }

    protected static int parseByte(String string, int n) {
        int n2 = Converters.parseHexChar(string.charAt(n)) << 4;
        return n2 += Converters.parseHexChar(string.charAt(n + 1));
    }

    private static int parseHexChar(int n) {
        int n2 = n - 48;
        if (n2 >= 0 && n2 <= 9) {
            return n2;
        }
        n2 = n - 55;
        if (n2 >= 10 && n2 <= 15) {
            return n2;
        }
        n2 = n - 97;
        if (n2 >= 10 && n2 <= 15) {
            return n2;
        }
        throw new IllegalArgumentException("not a hex char:" + n);
    }

    private static String fromTextAlignment(TextAlignment textAlignment) {
        switch (textAlignment) {
            case CENTER: {
                return "C";
            }
            case JUSTIFY: {
                return "J";
            }
            case RIGHT: {
                return "R";
            }
        }
        return "L";
    }

    private static TextAlignment toTextAlignment(String string) {
        switch (string) {
            case "C": {
                return TextAlignment.CENTER;
            }
            case "J": {
                return TextAlignment.JUSTIFY;
            }
            case "L": {
                return TextAlignment.LEFT;
            }
            case "R": {
                return TextAlignment.RIGHT;
            }
        }
        throw new IllegalArgumentException("bad text alignment: " + string);
    }

    private static String fromParagraphDirection(ParagraphDirection paragraphDirection) {
        switch (paragraphDirection) {
            case RIGHT_TO_LEFT: {
                return "R";
            }
        }
        return "L";
    }

    private static ParagraphDirection toParagraphDirection(String string) {
        switch (string) {
            case "R": {
                return ParagraphDirection.RIGHT_TO_LEFT;
            }
        }
        return ParagraphDirection.LEFT_TO_RIGHT;
    }
}

