/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.model;

import com.sun.jfx.incubator.scene.control.richtext.ImageCellPane;
import com.sun.jfx.incubator.scene.control.richtext.TextCell;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.RichParagraph;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledOutput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;
import jfx.incubator.scene.control.richtext.model.StyledTextModelViewOnlyBase;

public class SimpleViewOnlyStyledModel
extends StyledTextModelViewOnlyBase {
    private final ArrayList<Paragraph> paragraphs = new ArrayList();

    public static SimpleViewOnlyStyledModel of(String string) throws IOException {
        String string2;
        SimpleViewOnlyStyledModel simpleViewOnlyStyledModel = new SimpleViewOnlyStyledModel();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            simpleViewOnlyStyledModel.addSegment(string2);
            simpleViewOnlyStyledModel.nl();
        }
        return simpleViewOnlyStyledModel;
    }

    @Override
    public int size() {
        return this.paragraphs.size();
    }

    @Override
    public String getPlainText(int n) {
        return this.paragraphs.get(n).getPlainText();
    }

    @Override
    public RichParagraph getParagraph(int n) {
        return this.paragraphs.get(n).toRichParagraph();
    }

    public SimpleViewOnlyStyledModel addSegment(String string) {
        Objects.requireNonNull(string);
        return this.addSegment(string, StyleAttributeMap.EMPTY);
    }

    public SimpleViewOnlyStyledModel addWithInlineAndStyleNames(String string, String string2, String ... stringArray) {
        Objects.requireNonNull(string);
        StyleAttributeMap styleAttributeMap = StyleAttributeMap.fromStyles(string2, stringArray);
        Paragraph paragraph = this.lastParagraph();
        paragraph.addSegment(string, styleAttributeMap);
        return this;
    }

    public SimpleViewOnlyStyledModel addWithStyleNames(String string, String ... stringArray) {
        Objects.requireNonNull(string);
        StyleAttributeMap styleAttributeMap = StyleAttributeMap.fromStyles(null, stringArray);
        Paragraph paragraph = this.lastParagraph();
        paragraph.addSegment(string, styleAttributeMap);
        return this;
    }

    public SimpleViewOnlyStyledModel addWithInlineStyle(String string, String string2) {
        Objects.requireNonNull(string);
        StyleAttributeMap styleAttributeMap = StyleAttributeMap.fromInlineStyle(string2);
        Paragraph paragraph = this.lastParagraph();
        paragraph.addSegment(string, styleAttributeMap);
        return this;
    }

    public SimpleViewOnlyStyledModel addSegment(String string, StyleAttributeMap styleAttributeMap) {
        Objects.requireNonNull(styleAttributeMap);
        Paragraph paragraph = this.lastParagraph();
        paragraph.addSegment(string, styleAttributeMap);
        return this;
    }

    public SimpleViewOnlyStyledModel highlight(int n, int n2, Color color) {
        Paragraph paragraph = this.lastParagraph();
        paragraph.addHighlight(n, n2, color);
        return this;
    }

    public SimpleViewOnlyStyledModel addWavyUnderline(int n, int n2, Color color) {
        Paragraph paragraph = this.lastParagraph();
        paragraph.addSquiggly(n, n2, color);
        return this;
    }

    private Paragraph lastParagraph() {
        int n = this.paragraphs.size();
        if (n == 0) {
            Paragraph paragraph = new Paragraph();
            this.paragraphs.add(paragraph);
            return paragraph;
        }
        return this.paragraphs.get(n - 1);
    }

    public SimpleViewOnlyStyledModel addImage(InputStream inputStream) {
        Image image = new Image(inputStream);
        Paragraph paragraph = Paragraph.of(() -> new ImageCellPane(image));
        this.paragraphs.add(paragraph);
        return this;
    }

    public SimpleViewOnlyStyledModel addParagraph(Supplier<Region> supplier) {
        Paragraph paragraph = Paragraph.of(() -> (Region)supplier.get());
        this.paragraphs.add(paragraph);
        return this;
    }

    public SimpleViewOnlyStyledModel addNodeSegment(Supplier<Node> supplier) {
        Paragraph paragraph = this.lastParagraph();
        paragraph.addInlineNode(supplier);
        return this;
    }

    public SimpleViewOnlyStyledModel nl() {
        return this.nl(1);
    }

    public SimpleViewOnlyStyledModel nl(int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = this.paragraphs.size();
            this.paragraphs.add(new Paragraph());
        }
        return this;
    }

    @Override
    public StyleAttributeMap getStyleAttributeMap(StyleResolver styleResolver, TextPos textPos) {
        int n = textPos.index();
        if (n < this.paragraphs.size()) {
            int n2 = textPos.offset();
            Paragraph paragraph = this.paragraphs.get(n);
            StyleAttributeMap styleAttributeMap = paragraph.getParagraphAttributes();
            StyleAttributeMap styleAttributeMap2 = paragraph.getStyleAttrs(styleResolver, n2);
            if (styleAttributeMap == null) {
                return styleAttributeMap2;
            }
            return styleAttributeMap.combine(styleAttributeMap2);
        }
        return StyleAttributeMap.EMPTY;
    }

    public SimpleViewOnlyStyledModel setParagraphAttributes(StyleAttributeMap styleAttributeMap) {
        Paragraph paragraph = this.lastParagraph();
        paragraph.setParagraphAttributes(styleAttributeMap);
        return this;
    }

    static class Paragraph {
        private ArrayList<StyledSegment> segments;
        private ArrayList<Consumer<TextCell>> highlights;
        private StyleAttributeMap paragraphAttributes;

        public static Paragraph of(final Supplier<Region> supplier) {
            return new Paragraph(){

                @Override
                public final Supplier<Region> getParagraphRegion() {
                    return supplier;
                }

                @Override
                public final String getPlainText() {
                    return "";
                }

                @Override
                public void export(int n, int n2, StyledOutput styledOutput) throws IOException {
                    StyledSegment styledSegment = StyledSegment.ofRegion(supplier);
                    styledOutput.consume(styledSegment);
                }
            };
        }

        public Supplier<Region> getParagraphRegion() {
            return null;
        }

        String getPlainText() {
            if (this.segments == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (StyledSegment styledSegment : this.segments) {
                stringBuilder.append(styledSegment.getText());
            }
            return stringBuilder.toString();
        }

        void addSegment(String string) {
            StyledSegment styledSegment = StyledSegment.of(string);
            this.segments().add(styledSegment);
        }

        void addSegment(String string, StyleAttributeMap styleAttributeMap) {
            StyledSegment styledSegment = StyledSegment.of(string, styleAttributeMap);
            this.segments().add(styledSegment);
        }

        void addSegment(String string, int n, int n2, StyleAttributeMap styleAttributeMap) {
            String string2 = string.substring(n, n2);
            this.addSegment(string2, styleAttributeMap);
        }

        void addHighlight(int n, int n2, Color color) {
            int n3 = n + n2;
            this.highlights().add(textCell -> textCell.addHighlight(n, n3, color));
        }

        void addSquiggly(int n, int n2, Color color) {
            int n3 = n + n2;
            this.highlights().add(textCell -> textCell.addSquiggly(n, n3, color));
        }

        private List<Consumer<TextCell>> highlights() {
            if (this.highlights == null) {
                this.highlights = new ArrayList(4);
            }
            return this.highlights;
        }

        void addInlineNode(Supplier<Node> supplier) {
            StyledSegment styledSegment = StyledSegment.ofInlineNode(supplier);
            this.segments().add(styledSegment);
        }

        private List<StyledSegment> segments() {
            if (this.segments == null) {
                this.segments = new ArrayList(8);
            }
            return this.segments;
        }

        private List<StyledSegment> getSegments() {
            return this.segments;
        }

        private int size() {
            return this.segments == null ? 0 : this.segments.size();
        }

        void export(int n, int n2, StyledOutput styledOutput) throws IOException {
            if (this.segments == null) {
                styledOutput.consume(StyledSegment.of(""));
            } else {
                int n3 = 0;
                int n4 = this.size();
                for (int i = 0; i < n4; ++i) {
                    int n5;
                    StyledSegment styledSegment = this.segments.get(i);
                    String string = styledSegment.getText();
                    int n6 = n5 = string == null ? 0 : string.length();
                    if (n <= n3 + n5) {
                        int n7 = Math.max(0, n - n3);
                        int n8 = Math.min(n5, n2 - n3);
                        if (n8 > n7) {
                            StyledSegment styledSegment2 = styledSegment.subSegment(n7, n8);
                            styledOutput.consume(styledSegment2);
                        }
                    }
                    if ((n3 += n5) < n2) continue;
                    return;
                }
            }
        }

        void setParagraphAttributes(StyleAttributeMap styleAttributeMap) {
            this.paragraphAttributes = styleAttributeMap;
        }

        StyleAttributeMap getParagraphAttributes() {
            return this.paragraphAttributes;
        }

        StyleAttributeMap getStyleAttrs(StyleResolver styleResolver, int n) {
            int n2 = 0;
            int n3 = this.size();
            for (int i = 0; i < n3; ++i) {
                StyledSegment styledSegment = this.segments.get(i);
                int n4 = styledSegment.getTextLength();
                if (n < n2 + n4 || i == n3 - 1) {
                    return styledSegment.getStyleAttributeMap(styleResolver);
                }
                n2 += n4;
            }
            return StyleAttributeMap.EMPTY;
        }

        public RichParagraph toRichParagraph() {
            return new RichParagraph(){

                @Override
                public final String getPlainText() {
                    return this.getPlainText();
                }

                @Override
                public final StyleAttributeMap getParagraphAttributes() {
                    return paragraphAttributes;
                }

                @Override
                final List<StyledSegment> getSegments() {
                    return this.getSegments();
                }

                @Override
                public final Supplier<Region> getParagraphRegion() {
                    return this.getParagraphRegion();
                }

                @Override
                final List<Consumer<TextCell>> getHighlights() {
                    return highlights;
                }
            };
        }
    }
}

