/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.model;

import com.sun.jfx.incubator.scene.control.richtext.CssStyles;
import com.sun.jfx.incubator.scene.control.richtext.StyleAttributeMapHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import jfx.incubator.scene.control.richtext.model.ParagraphDirection;
import jfx.incubator.scene.control.richtext.model.StyleAttribute;

public final class StyleAttributeMap {
    public static final StyleAttribute<Color> BACKGROUND = new StyleAttribute<Color>("BACKGROUND", Color.class, true);
    public static final StyleAttribute<String> BULLET = new StyleAttribute<String>("BULLET", String.class, true);
    public static final StyleAttribute<Boolean> BOLD = new StyleAttribute<Boolean>("BOLD", Boolean.class, false);
    public static final StyleAttribute<Double> FIRST_LINE_INDENT = new StyleAttribute<Double>("FIRST_LINE_INDENT", Double.class, true);
    public static final StyleAttribute<String> FONT_FAMILY = new StyleAttribute<String>("FONT_FAMILY", String.class, false);
    public static final StyleAttribute<Double> FONT_SIZE = new StyleAttribute<Double>("FONT_SIZE", Double.class, false);
    public static final StyleAttribute<Boolean> ITALIC = new StyleAttribute<Boolean>("ITALIC", Boolean.class, false);
    public static final StyleAttribute<Double> LINE_SPACING = new StyleAttribute<Double>("LINE_SPACING", Double.class, true);
    public static final StyleAttribute<ParagraphDirection> PARAGRAPH_DIRECTION = new StyleAttribute<ParagraphDirection>("PARAGRAPH_DIRECTION", ParagraphDirection.class, true);
    public static final StyleAttribute<Double> SPACE_ABOVE = new StyleAttribute<Double>("SPACE_ABOVE", Double.class, true);
    public static final StyleAttribute<Double> SPACE_BELOW = new StyleAttribute<Double>("SPACE_BELOW", Double.class, true);
    public static final StyleAttribute<Double> SPACE_LEFT = new StyleAttribute<Double>("SPACE_LEFT", Double.class, true);
    public static final StyleAttribute<Double> SPACE_RIGHT = new StyleAttribute<Double>("SPACE_RIGHT", Double.class, true);
    public static final StyleAttribute<Boolean> STRIKE_THROUGH = new StyleAttribute<Boolean>("STRIKE_THROUGH", Boolean.class, false);
    public static final StyleAttribute<TextAlignment> TEXT_ALIGNMENT = new StyleAttribute<TextAlignment>("TEXT_ALIGNMENT", TextAlignment.class, true);
    public static final StyleAttribute<Color> TEXT_COLOR = new StyleAttribute<Color>("TEXT_COLOR", Color.class, false);
    public static final StyleAttribute<Boolean> UNDERLINE = new StyleAttribute<Boolean>("UNDERLINE", Boolean.class, false);
    public static final StyleAttributeMap EMPTY = new StyleAttributeMap(Collections.emptyMap());
    private static final String[] EMPTY_ARRAY = new String[0];
    private final Map<StyleAttribute<?>, Object> attributes;

    private StyleAttributeMap(Map<StyleAttribute<?>, Object> map) {
        this.attributes = Collections.unmodifiableMap(map);
    }

    public static <V> StyleAttributeMap of(StyleAttribute<V> styleAttribute, V v) {
        return new Builder().set(styleAttribute, v).build();
    }

    static StyleAttributeMap fromStyles(String string, String ... stringArray) {
        if (string == null && stringArray == null) {
            return EMPTY;
        }
        if (stringArray == null) {
            stringArray = EMPTY_ARRAY;
        }
        return new Builder().set(CssStyles.CSS, new CssStyles(string, stringArray)).build();
    }

    static StyleAttributeMap fromInlineStyle(String string) {
        if (string == null) {
            return EMPTY;
        }
        return new Builder().set(CssStyles.CSS, new CssStyles(string, null)).build();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof StyleAttributeMap) {
            StyleAttributeMap styleAttributeMap = (StyleAttributeMap)object;
            return this.attributes.equals(styleAttributeMap.attributes);
        }
        return false;
    }

    public int hashCode() {
        return this.attributes.hashCode() + 31 * StyleAttributeMap.class.hashCode();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public <V> V get(StyleAttribute<V> styleAttribute) {
        return (V)this.attributes.get(styleAttribute);
    }

    public Set<StyleAttribute<?>> getAttributes() {
        return this.attributes.keySet();
    }

    public Set<Map.Entry<StyleAttribute<?>, Object>> getAttributeEntrySet() {
        return this.attributes.entrySet();
    }

    public boolean contains(StyleAttribute<?> styleAttribute) {
        return this.attributes.containsKey(styleAttribute);
    }

    public StyleAttributeMap combine(StyleAttributeMap styleAttributeMap) {
        return new Builder().merge(this).merge(styleAttributeMap).build();
    }

    public boolean getBoolean(StyleAttribute<Boolean> styleAttribute) {
        Object object = this.attributes.get(styleAttribute);
        return Boolean.TRUE.equals(object);
    }

    public double getDouble(StyleAttribute<? extends Number> styleAttribute, double d) {
        Object object = this.attributes.get(styleAttribute);
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.doubleValue();
        }
        return d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("{");
        boolean bl = false;
        for (StyleAttribute<?> styleAttribute : this.attributes.keySet()) {
            if (bl) {
                stringBuilder.append(",");
            } else {
                bl = true;
            }
            Object obj = this.get(styleAttribute);
            stringBuilder.append(styleAttribute);
            stringBuilder.append('=');
            stringBuilder.append(obj);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public Color getBackground() {
        return this.get(BACKGROUND);
    }

    public String getBullet() {
        return this.get(BULLET);
    }

    public Double getFirstLineIndent() {
        return this.get(FIRST_LINE_INDENT);
    }

    public final Double getFontSize() {
        return this.get(FONT_SIZE);
    }

    public String getFontFamily() {
        return this.get(FONT_FAMILY);
    }

    public Double getLineSpacing() {
        return this.get(LINE_SPACING);
    }

    public Double getSpaceAbove() {
        return this.get(SPACE_ABOVE);
    }

    public Double getSpaceBelow() {
        return this.get(SPACE_BELOW);
    }

    public Double getSpaceLeft() {
        return this.get(SPACE_LEFT);
    }

    public Double getSpaceRight() {
        return this.get(SPACE_RIGHT);
    }

    public TextAlignment getTextAlignment() {
        return this.get(TEXT_ALIGNMENT);
    }

    public Color getTextColor() {
        return this.get(TEXT_COLOR);
    }

    public boolean isBold() {
        return this.getBoolean(BOLD);
    }

    public boolean isItalic() {
        return this.getBoolean(ITALIC);
    }

    public ParagraphDirection getParagraphDirection() {
        return this.get(PARAGRAPH_DIRECTION);
    }

    public boolean isStrikeThrough() {
        return this.getBoolean(STRIKE_THROUGH);
    }

    public boolean isUnderline() {
        return this.getBoolean(UNDERLINE);
    }

    private StyleAttributeMap filterAttributes(boolean bl) {
        Builder builder = null;
        for (StyleAttribute<?> styleAttribute : this.attributes.keySet()) {
            if (styleAttribute.isParagraphAttribute() != bl) continue;
            if (builder == null) {
                builder = StyleAttributeMap.builder();
            }
            Object object = this.attributes.get(styleAttribute);
            builder.setUnguarded(styleAttribute, object);
        }
        return builder == null ? null : builder.build();
    }

    private static void initAccessor() {
        StyleAttributeMapHelper.setAccessor(new StyleAttributeMapHelper.Accessor(){

            @Override
            public StyleAttributeMap filterAttributes(StyleAttributeMap styleAttributeMap, boolean bl) {
                return styleAttributeMap == null ? null : styleAttributeMap.filterAttributes(bl);
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        StyleAttributeMap.initAccessor();
    }

    public static class Builder {
        private final HashMap<StyleAttribute<?>, Object> attributes = new HashMap(4);

        private Builder() {
        }

        public StyleAttributeMap build() {
            return new StyleAttributeMap(this.attributes);
        }

        public <V> Builder set(StyleAttribute<V> styleAttribute, V v) {
            if (v == null) {
                this.attributes.put(styleAttribute, null);
            } else if (v.getClass().isAssignableFrom(styleAttribute.getType())) {
                this.attributes.put(styleAttribute, v);
            } else {
                throw new IllegalArgumentException(String.valueOf(styleAttribute) + " requires value of type " + String.valueOf(styleAttribute.getType()));
            }
            return this;
        }

        private Builder setUnguarded(StyleAttribute<?> styleAttribute, Object object) {
            this.attributes.put(styleAttribute, object);
            return this;
        }

        public Builder merge(StyleAttributeMap styleAttributeMap) {
            if (styleAttributeMap != null) {
                for (StyleAttribute<?> styleAttribute : styleAttributeMap.attributes.keySet()) {
                    Object obj = styleAttributeMap.get(styleAttribute);
                    this.setUnguarded(styleAttribute, obj);
                }
            }
            return this;
        }

        public Builder setBackground(Color color) {
            this.set(BACKGROUND, color);
            return this;
        }

        public Builder setBold(boolean bl) {
            this.set(BOLD, bl);
            return this;
        }

        public Builder setBullet(String string) {
            this.set(BULLET, string);
            return this;
        }

        public Builder setFirstLineIndent(double d) {
            this.set(FIRST_LINE_INDENT, d);
            return this;
        }

        public Builder setFontFamily(String string) {
            this.set(FONT_FAMILY, string);
            return this;
        }

        public Builder setFontSize(double d) {
            this.set(FONT_SIZE, d);
            return this;
        }

        public Builder setLineSpacing(double d) {
            this.set(LINE_SPACING, d);
            return this;
        }

        public Builder setItalic(boolean bl) {
            this.set(ITALIC, bl);
            return this;
        }

        public Builder setRTL(ParagraphDirection paragraphDirection) {
            this.set(PARAGRAPH_DIRECTION, paragraphDirection);
            return this;
        }

        public Builder setSpaceAbove(double d) {
            this.set(SPACE_ABOVE, d);
            return this;
        }

        public Builder setSpaceBelow(double d) {
            this.set(SPACE_BELOW, d);
            return this;
        }

        public Builder setSpaceLeft(double d) {
            this.set(SPACE_LEFT, d);
            return this;
        }

        public Builder setSpaceRight(double d) {
            this.set(SPACE_RIGHT, d);
            return this;
        }

        public Builder setStrikeThrough(boolean bl) {
            this.set(STRIKE_THROUGH, bl);
            return this;
        }

        public Builder setTextAlignment(TextAlignment textAlignment) {
            this.set(TEXT_ALIGNMENT, textAlignment);
            return this;
        }

        public Builder setTextColor(Color color) {
            this.set(TEXT_COLOR, color);
            return this;
        }

        public Builder setUnderline(boolean bl) {
            this.set(UNDERLINE, bl);
            return this;
        }
    }
}

