/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.richtext.CssStyles;
import java.util.HashMap;
import javafx.scene.Node;
import javafx.scene.image.WritableImage;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;

public class CachingStyleResolver
implements StyleResolver {
    private final StyleResolver resolver;
    private final HashMap<CssStyles, StyleAttributeMap> cache = new HashMap();

    public CachingStyleResolver(StyleResolver styleResolver) {
        this.resolver = styleResolver;
    }

    @Override
    public StyleAttributeMap resolveStyles(StyleAttributeMap styleAttributeMap) {
        CssStyles cssStyles = styleAttributeMap.get(CssStyles.CSS);
        if (cssStyles == null) {
            return styleAttributeMap;
        }
        StyleAttributeMap styleAttributeMap2 = this.cache.get(cssStyles);
        if (styleAttributeMap2 == null) {
            styleAttributeMap2 = this.resolver.resolveStyles(styleAttributeMap);
            this.cache.put(cssStyles, styleAttributeMap2);
        }
        return styleAttributeMap2;
    }

    @Override
    public WritableImage snapshot(Node node) {
        return this.resolver.snapshot(node);
    }
}

