/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.scene.text.TabAdvancePolicy;

public class FixedTabAdvancePolicy
implements TabAdvancePolicy {
    private final float tabAdvance;

    public FixedTabAdvancePolicy(int n, float f) {
        this.tabAdvance = (float)Math.max(1, n) * f;
    }

    @Override
    public float nextTabStop(float f, float f2) {
        if ((double)this.tabAdvance == 0.0) {
            return -1.0f;
        }
        return FixedTabAdvancePolicy.nextPosition(f2, this.tabAdvance);
    }

    static float nextPosition(float f, float f2) {
        float f3 = f / f2;
        return (float)((int)(f3 + Math.ulp(f3)) + 1) * f2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FixedTabAdvancePolicy) {
            FixedTabAdvancePolicy fixedTabAdvancePolicy = (FixedTabAdvancePolicy)object;
            return this.tabAdvance == fixedTabAdvancePolicy.tabAdvance;
        }
        return false;
    }

    public int hashCode() {
        int n = FixedTabAdvancePolicy.class.hashCode();
        return n * 31 + Float.floatToIntBits(this.tabAdvance);
    }

    public String toString() {
        return "FixedTabAdvancePolicy{tabAdvance=" + this.tabAdvance + "}";
    }
}

