/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

public class FastCache<T> {
    private int size;
    private final Entry<T>[] linear;
    private final HashMap<Integer, T> data;
    private static final Random random = new Random();

    public FastCache(int n) {
        this.linear = new Entry[n];
        this.data = new HashMap(n);
    }

    public T get(int n) {
        return this.data.get(n);
    }

    public void add(int n, T t) {
        int n2 = this.size >= this.capacity() ? this.evict() : this.size++;
        this.data.put(n, t);
        this.linear[n2] = new Entry<T>(n, t);
    }

    protected int evict() {
        int n = random.nextInt(this.size);
        Entry<T> entry = this.linear[n];
        int n2 = entry.index();
        this.data.remove(n2);
        return n;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.linear.length;
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.linear, null);
        this.data.clear();
    }

    private record Entry<V>(int index, V cell) {
    }
}

