/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media;

import com.sun.javafx.css.media.MediaFeatures;
import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.expression.ConjunctionExpression;
import com.sun.javafx.css.media.expression.ConstantExpression;
import com.sun.javafx.css.media.expression.DisjunctionExpression;
import com.sun.javafx.css.media.expression.FunctionExpression;
import com.sun.javafx.css.media.expression.NegationExpression;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javafx.css.StyleConverter;

public final class MediaQuerySerializer {
    private MediaQuerySerializer() {
    }

    public static void writeBinary(MediaQuery mediaQuery, DataOutputStream dataOutputStream, StyleConverter.StringStore stringStore) throws IOException {
        dataOutputStream.writeByte(QueryType.of((MediaQuery)mediaQuery).serializedId);
        MediaQuery mediaQuery2 = mediaQuery;
        Objects.requireNonNull(mediaQuery2);
        MediaQuery mediaQuery3 = mediaQuery2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantExpression.class, FunctionExpression.class, NegationExpression.class, ConjunctionExpression.class, DisjunctionExpression.class}, (MediaQuery)mediaQuery3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ConstantExpression constantExpression = (ConstantExpression)mediaQuery3;
                dataOutputStream.writeBoolean(constantExpression.value());
                break;
            }
            case 1: {
                FunctionExpression functionExpression = (FunctionExpression)mediaQuery3;
                dataOutputStream.writeInt(stringStore.addString(functionExpression.featureName()));
                if (functionExpression.featureValue() != null) {
                    dataOutputStream.writeInt(stringStore.addString(functionExpression.featureValue()));
                    break;
                }
                dataOutputStream.writeInt(-1);
                break;
            }
            case 2: {
                NegationExpression negationExpression = (NegationExpression)mediaQuery3;
                MediaQuerySerializer.writeBinary(negationExpression.expression(), dataOutputStream, stringStore);
                break;
            }
            case 3: {
                ConjunctionExpression conjunctionExpression = (ConjunctionExpression)mediaQuery3;
                MediaQuerySerializer.writeBinary(conjunctionExpression.left(), dataOutputStream, stringStore);
                MediaQuerySerializer.writeBinary(conjunctionExpression.right(), dataOutputStream, stringStore);
                break;
            }
            case 4: {
                DisjunctionExpression disjunctionExpression = (DisjunctionExpression)mediaQuery3;
                MediaQuerySerializer.writeBinary(disjunctionExpression.left(), dataOutputStream, stringStore);
                MediaQuerySerializer.writeBinary(disjunctionExpression.right(), dataOutputStream, stringStore);
            }
        }
    }

    public static MediaQuery readBinary(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        return switch (QueryType.of(dataInputStream.readByte()).ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                String var2_2 = stringArray[dataInputStream.readInt()];
                int var3_3 = dataInputStream.readInt();
                String var4_4 = var3_3 >= 0 ? stringArray[var3_3] : null;
                yield MediaFeatures.featureQueryExpression(var2_2, var4_4);
            }
            case 0 -> new ConstantExpression(dataInputStream.readBoolean());
            case 4 -> new NegationExpression(MediaQuerySerializer.readBinary(dataInputStream, stringArray));
            case 2 -> new ConjunctionExpression(MediaQuerySerializer.readBinary(dataInputStream, stringArray), MediaQuerySerializer.readBinary(dataInputStream, stringArray));
            case 3 -> new DisjunctionExpression(MediaQuerySerializer.readBinary(dataInputStream, stringArray), MediaQuerySerializer.readBinary(dataInputStream, stringArray));
        };
    }

    private static enum QueryType {
        CONSTANT(1),
        FUNCTION(2),
        CONJUNCTION(3),
        DISJUNCTION(4),
        NEGATION(5);

        private final int serializedId;
        private static final QueryType[] VALUES;

        static QueryType of(MediaQuery mediaQuery) {
            MediaQuery mediaQuery2 = mediaQuery;
            Objects.requireNonNull(mediaQuery2);
            MediaQuery mediaQuery3 = mediaQuery2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantExpression.class, FunctionExpression.class, ConjunctionExpression.class, DisjunctionExpression.class, NegationExpression.class}, (MediaQuery)mediaQuery3, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> CONSTANT;
                case 1 -> FUNCTION;
                case 2 -> CONJUNCTION;
                case 3 -> DISJUNCTION;
                case 4 -> NEGATION;
            };
        }

        static QueryType of(int n) {
            for (QueryType queryType : VALUES) {
                if (queryType.serializedId != n) continue;
                return queryType;
            }
            throw new IllegalArgumentException("serializedId");
        }

        private QueryType(int n2) {
            this.serializedId = n2;
        }

        static {
            VALUES = QueryType.values();
        }
    }
}

