/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class HighlightShape
extends Path {
    private final Type type;
    private final int start;
    private final int end;

    public HighlightShape(Type type, int n, int n2) {
        this.type = type;
        this.start = n;
        this.end = n2;
    }

    private PathElement[] createPath(TextFlow textFlow) {
        switch (this.type.ordinal()) {
            case 0: {
                return textFlow.rangeShape(this.start, this.end);
            }
            case 1: {
                PathElement[] pathElementArray = textFlow.underlineShape(this.start, this.end);
                return this.generateSquiggly(pathElementArray);
            }
        }
        return new PathElement[0];
    }

    private PathElement[] generateSquiggly(PathElement[] pathElementArray) {
        ArrayList<PathElement> arrayList = new ArrayList<PathElement>(pathElementArray.length * 8);
        double d = 2.147483647E9;
        double d2 = -2.147483648E9;
        double d3 = 2.147483647E9;
        double d4 = -2.147483648E9;
        int n = pathElementArray.length + 1;
        for (int i = 0; i < n; ++i) {
            double d5;
            double d6;
            PathElement pathElement;
            PathElement pathElement2 = pathElement = i < pathElementArray.length ? pathElementArray[i] : null;
            if (pathElement == null || pathElement instanceof MoveTo) {
                if (d < d2) {
                    this.generateSquiggly(arrayList, d, d2, (d3 + d4) / 2.0, 1.0);
                }
                if (pathElement == null) break;
                d = 2.147483647E9;
                d2 = -2.147483648E9;
                d3 = 2.147483647E9;
                d4 = -2.147483648E9;
            }
            if (pathElement instanceof MoveTo) {
                MoveTo moveTo = (MoveTo)pathElement;
                d6 = moveTo.getX();
                if (d6 < d) {
                    d = d6;
                }
                if (d6 > d2) {
                    d2 = d6;
                }
                if ((d5 = moveTo.getY()) < d3) {
                    d3 = d5;
                }
                if (!(d5 > d4)) continue;
                d4 = d5;
                continue;
            }
            if (!(pathElement instanceof LineTo)) continue;
            LineTo lineTo = (LineTo)pathElement;
            d6 = lineTo.getX();
            if (d6 < d) {
                d = d6;
            }
            if (d6 > d2) {
                d2 = d6;
            }
            if ((d5 = lineTo.getY()) < d3) {
                d3 = d5;
            }
            if (!(d5 > d4)) continue;
            d4 = d5;
        }
        return arrayList.toArray(new PathElement[arrayList.size()]);
    }

    private void generateSquiggly(List<PathElement> list, double d, double d2, double d3, double d4) {
        double d5 = d;
        double d6 = d3;
        double d7 = d3 - d4;
        double d8 = d3 + d4;
        boolean bl = true;
        boolean bl2 = true;
        list.add((PathElement)new MoveTo(d5, d6));
        while (bl2) {
            double d9;
            double d10 = d9 = bl ? d6 - d7 : d8 - d6;
            if (d5 + d9 > d2) {
                d9 = d2 - d5;
                bl2 = false;
            }
            d6 = bl ? (d6 -= d9) : (d6 += d9);
            bl = !bl;
            list.add((PathElement)new LineTo(d5 += d9, d6));
        }
    }

    private void updatePath(TextFlow textFlow) {
        Object[] objectArray = this.createPath(textFlow);
        this.getElements().setAll(objectArray);
    }

    public static void addTo(Region region, Type type, int n, int n2, Color color) {
        if (region instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region;
            String string = HighlightShape.createStyle(type, color);
            HighlightShape.addHighlight(textFlow, type, n, n2, string, null);
        }
    }

    public static void addTo(Region region, Type type, int n, int n2, String ... stringArray) {
        if (region instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region;
            HighlightShape.addHighlight(textFlow, type, n, n2, null, stringArray);
        }
    }

    private static String createStyle(Type type, Color color) {
        switch (type.ordinal()) {
            case 0: {
                return "-fx-fill: " + RichUtils.toCssColor(color) + "; -fx-stroke-width:0;";
            }
        }
        return "-fx-stroke: " + RichUtils.toCssColor(color) + "; -fx-stroke-width:1;";
    }

    private static void addHighlight(TextFlow textFlow, Type type, int n, int n2, String string, String[] stringArray) {
        HighlightShape highlightShape = new HighlightShape(type, n, n2);
        highlightShape.setStyle(string);
        if (stringArray != null) {
            highlightShape.getStyleClass().addAll((Object[])stringArray);
        }
        textFlow.widthProperty().addListener(observable -> highlightShape.updatePath(textFlow));
        highlightShape.updatePath(textFlow);
        highlightShape.setManaged(false);
        ObservableList observableList = textFlow.getChildren();
        int n3 = observableList.size();
        int n4 = -1;
        for (int i = 0; i < n3; ++i) {
            if (!(observableList.get(i) instanceof Text)) continue;
            n4 = i;
            break;
        }
        if (n4 < 0) {
            observableList.add(highlightShape);
        } else {
            observableList.add(n4, highlightShape);
        }
    }

    public static enum Type {
        HIGHLIGHT,
        SQUIGGLY;

    }
}

