/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Base64;
import java.util.HashMap;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.model.StyleAttribute;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledOutput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;

public class HtmlStyledOutput
implements StyledOutput {
    private static final StyleAttribute<Key> SS_AND_UNDERLINE = new StyleAttribute<Key>("SS_AND_UNDERLINE", Key.class, false);
    private final StyleResolver resolver;
    private final Writer wr;
    private final boolean inlineStyles;
    private final HashMap<Key, Val> styles = new HashMap();

    public HtmlStyledOutput(StyleResolver styleResolver, Writer writer, boolean bl) {
        this.resolver = styleResolver;
        this.wr = writer;
        this.inlineStyles = bl;
    }

    @Override
    public void consume(StyledSegment styledSegment) throws IOException {
        switch (styledSegment.getType()) {
            case INLINE_NODE: {
                Node node = styledSegment.getInlineNodeGenerator().get();
                this.writeInlineNode(node);
                break;
            }
            case LINE_BREAK: {
                this.wr.write("<p/>\n");
                break;
            }
            case TEXT: {
                StyleAttributeMap styleAttributeMap = styledSegment.getStyleAttributeMap(this.resolver);
                String string = styleAttributeMap != null && !styleAttributeMap.isEmpty() ? this.extractStyles(styleAttributeMap) : null;
                if (string != null) {
                    this.wr.write("<span style='");
                    this.wr.write(string);
                    this.wr.write("'>");
                }
                String string2 = styledSegment.getText();
                String string3 = HtmlStyledOutput.encode(string2);
                this.wr.write(string3);
                if (string == null) break;
                this.wr.write("</span>");
                break;
            }
            case REGION: {
                Region region = styledSegment.getParagraphNodeGenerator().get();
                this.writeParagraph(region);
            }
        }
    }

    private String extractStyles(StyleAttributeMap styleAttributeMap) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (StyleAttribute<?> styleAttribute : styleAttributeMap.getAttributes()) {
            Val val;
            Key key;
            Object obj = styleAttributeMap.get(styleAttribute);
            if (obj == null || (key = HtmlStyledOutput.createKey(styleAttributeMap, styleAttribute, obj)) == null) continue;
            if (bl) {
                stringBuilder.append(' ');
            } else {
                bl = true;
            }
            if ((val = this.styles.get(key)) == null) continue;
            if (this.inlineStyles) {
                stringBuilder.append(val.css);
                continue;
            }
            stringBuilder.append(val.name);
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    private static Key createKey(StyleAttributeMap styleAttributeMap, StyleAttribute styleAttribute, Object object) {
        if (styleAttribute == StyleAttributeMap.STRIKE_THROUGH) {
            if (styleAttributeMap.isStrikeThrough() && styleAttributeMap.isUnderline()) {
                styleAttribute = SS_AND_UNDERLINE;
            }
        } else if (styleAttribute == StyleAttributeMap.UNDERLINE && styleAttributeMap.isStrikeThrough() && styleAttributeMap.isUnderline()) {
            return null;
        }
        return new Key(styleAttribute, object);
    }

    private void writeParagraph(Region region) throws IOException {
        WritableImage writableImage = this.resolver.snapshot((Node)region);
        int n = (int)writableImage.getWidth();
        int n2 = (int)writableImage.getHeight();
        byte[] byArray = RichUtils.writePNG((Image)writableImage);
        String string = Base64.getEncoder().encodeToString(byArray);
        this.wr.write("<p><img src=\"data:image/png;base64,");
        this.wr.write(string);
        this.wr.write("\" width=");
        this.wr.write(String.valueOf(n));
        this.wr.write(" height=");
        this.wr.write(String.valueOf(n2));
        this.wr.write("></p>");
    }

    private void writeInlineNode(Node node) throws IOException {
        WritableImage writableImage = this.resolver.snapshot(node);
        int n = (int)writableImage.getWidth();
        int n2 = (int)writableImage.getHeight();
        byte[] byArray = RichUtils.writePNG((Image)writableImage);
        String string = Base64.getEncoder().encodeToString(byArray);
        this.wr.write("<img src=\"data:image/png;base64,");
        this.wr.write(string);
        this.wr.write("\" width=");
        this.wr.write(String.valueOf(n));
        this.wr.write(" height=");
        this.wr.write(String.valueOf(n2));
        this.wr.write(">");
    }

    private static String encode(String string) {
        if (string == null) {
            return "";
        }
        int n = HtmlStyledOutput.indexOfSpecialChar(string);
        if (n < 0) {
            return string;
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 32);
        stringBuilder.append(string, 0, n);
        block10: for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c < ' ') {
                switch (c) {
                    case '\t': {
                        stringBuilder.append("<pre>\t</pre>");
                        break;
                    }
                    default: {
                        stringBuilder.append("&#");
                        stringBuilder.append(HtmlStyledOutput.nibbleChar(c >> 4));
                        stringBuilder.append(HtmlStyledOutput.nibbleChar(c));
                        stringBuilder.append(';');
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block10;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("&#34;");
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append("&#39;");
                    continue block10;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block10;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static int indexOfSpecialChar(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ') {
                return i;
            }
            switch (c) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    return i;
                }
            }
        }
        return -1;
    }

    private static char nibbleChar(int n) {
        return "0123456789abcdef".charAt(n & 0xF);
    }

    @Override
    public void flush() throws IOException {
        this.wr.flush();
    }

    @Override
    public void close() throws IOException {
        this.wr.close();
    }

    public StyledOutput firstPassBuilder() {
        return new StyledOutput(){

            @Override
            public void consume(StyledSegment styledSegment) throws IOException {
                switch (styledSegment.getType()) {
                    case TEXT: {
                        StyleAttributeMap styleAttributeMap = styledSegment.getStyleAttributeMap(HtmlStyledOutput.this.resolver);
                        if (styleAttributeMap == null || styleAttributeMap.isEmpty()) break;
                        for (StyleAttribute<?> styleAttribute : styleAttributeMap.getAttributes()) {
                            String string;
                            Key key;
                            Object obj = styleAttributeMap.get(styleAttribute);
                            if (obj == null || (key = HtmlStyledOutput.createKey(styleAttributeMap, styleAttribute, obj)) == null || HtmlStyledOutput.this.styles.containsKey(key) || (string = HtmlStyledOutput.createCss(key.attr, obj)) == null) continue;
                            String string2 = ".S" + HtmlStyledOutput.this.styles.size();
                            Val val = new Val(string2, string);
                            HtmlStyledOutput.this.styles.put(key, val);
                        }
                        break;
                    }
                }
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    private static String createCss(StyleAttribute styleAttribute, Object object) {
        if (styleAttribute == StyleAttributeMap.BOLD) {
            return Boolean.TRUE.equals(object) ? "font-weight: bold;" : null;
        }
        if (styleAttribute == StyleAttributeMap.FONT_FAMILY) {
            return "font-family: \"" + HtmlStyledOutput.encodeFontFamily(object.toString()) + "\";";
        }
        if (styleAttribute == StyleAttributeMap.FONT_SIZE) {
            return "font-size: " + String.valueOf(object) + "px;";
        }
        if (styleAttribute == StyleAttributeMap.ITALIC) {
            return Boolean.TRUE.equals(object) ? "font-style: italic;" : null;
        }
        if (styleAttribute == StyleAttributeMap.STRIKE_THROUGH && Boolean.TRUE.equals(object)) {
            return "text-decoration: line-through;";
        }
        if (styleAttribute == StyleAttributeMap.TEXT_COLOR) {
            return "color: " + RichUtils.toWebColor((Color)object) + ";";
        }
        if (styleAttribute == StyleAttributeMap.UNDERLINE) {
            return Boolean.TRUE.equals(object) ? "text-decoration: underline;" : null;
        }
        if (styleAttribute == SS_AND_UNDERLINE) {
            return Boolean.TRUE.equals(object) ? "text-decoration: line-through underline;" : null;
        }
        return null;
    }

    private static String encodeFontFamily(String string) {
        switch (string.toLowerCase()) {
            case "monospaced": {
                return "monospace";
            }
            case "system": 
            case "sans-serif": {
                return "sans-serif";
            }
            case "serif": {
                return "serif";
            }
            case "cursive": {
                return "cursive";
            }
            case "fantasy": {
                return "fantasy";
            }
        }
        return HtmlStyledOutput.encode(string);
    }

    public void writePrologue() throws IOException {
        this.wr.write("<html>\n");
        this.wr.write("<head>\n");
        this.wr.write("<meta charset=\"utf-8\">\n");
        if (!this.inlineStyles) {
            this.wr.write("<style>\n");
            for (Val val : this.styles.values()) {
                this.wr.write(val.name);
                this.wr.write(" { ");
                this.wr.write(val.css);
                this.wr.write(" }\n");
            }
            this.wr.write("</style>\n");
        }
        this.wr.write("</head>\n");
        this.wr.write("<body>\n");
    }

    public void writeEpilogue() throws IOException {
        this.wr.write("\n</body></html>\n");
    }

    private record Key(StyleAttribute attr, Object value) {
    }

    private static class Val {
        public final String name;
        public final String css;

        public Val(String string, String string2) {
            this.name = string;
            this.css = string2;
        }
    }
}

