/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IPredicate;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.flightrecorder.rules.tree.Range;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class TimeRangeThreadFilter
implements IItemFilter {
    private Map<IMCThread, Range> rangeMap;

    public TimeRangeThreadFilter(Map<IMCThread, Range> rangeMap) {
        this.rangeMap = rangeMap;
    }

    public TimeRangeThreadFilter(IMCThread thread, Range range) {
        this.rangeMap = new HashMap<IMCThread, Range>();
        this.rangeMap.put(thread, range);
    }

    public IPredicate<IItem> getPredicate(IType<IItem> type) {
        return new TimeRangePredicate();
    }

    public String toString() {
        return "TimeRangeThreadFilter " + this.toString(this.rangeMap);
    }

    private String toString(Map<IMCThread, Range> rangeMap) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        ArrayList<String> texts = new ArrayList<String>();
        for (Map.Entry<IMCThread, Range> entry : rangeMap.entrySet()) {
            texts.add(String.format("Thread: %s = Range: %s", entry.getKey().getThreadName(), String.valueOf(entry.getValue())));
        }
        builder.append(StringToolkit.join(texts, (String)", "));
        builder.append("]");
        return builder.toString();
    }

    public Map<IMCThread, Range> getRangeMap() {
        return this.rangeMap;
    }

    private class TimeRangePredicate
    implements IPredicate<IItem> {
        private TimeRangePredicate() {
        }

        public boolean evaluate(IItem o) {
            IMCThread thread = RulesToolkit.getThread(o);
            if (!TimeRangeThreadFilter.this.rangeMap.containsKey(thread)) {
                return false;
            }
            return this.intersects(o, (Range)TimeRangeThreadFilter.this.rangeMap.get(thread));
        }

        private boolean intersects(IItem o, Range range) {
            IQuantity startTime = RulesToolkit.getStartTime(o);
            IQuantity endTime = RulesToolkit.getStartTime(o);
            if (range.isInside(startTime) || range.isInside(endTime)) {
                return true;
            }
            return range.isBefore(startTime) && range.isAfter(endTime);
        }
    }
}

