/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.ColorToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.DurationPercentileTable;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemList;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.layout.SimpleLayout;
import org.openjdk.jmc.ui.layout.SimpleLayoutData;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class FileIOPage
extends AbstractDataPage {
    private static final Color WRITE_COLOR = TypeLabelProvider.getColor("jdk.FileWrite");
    private static final Color READ_COLOR = TypeLabelProvider.getColor("jdk.FileRead");
    private static final Color WRITE_ALPHA_COLOR = ColorToolkit.withAlpha((Color)WRITE_COLOR, (int)80);
    private static final Color READ_ALPHA_COLOR = ColorToolkit.withAlpha((Color)READ_COLOR, (int)80);
    private static final IItemFilter TABLE_ITEMS = ItemFilters.type((String[])new String[]{"jdk.FileRead", "jdk.FileWrite"});
    private static final String TOTAL_TIME = "totalTime";
    private static final String MAX_TIME = "maxTime";
    private static final String AVG_TIME = "avgTime";
    private static final String STDDEV_TIME = "stddevTime";
    private static final String READ_COUNT = "readCount";
    private static final String WRITE_COUNT = "writeCount";
    private static final String READ_SIZE = "readSize";
    private static final String WRITE_SIZE = "writeSize";
    private static final String READ_EOF = "endOfFile";
    private static final String PERCENTILE_READ_TIME = "percentileReadTime";
    private static final String PERCENTILE_READ_COUNT = "percentileReadCount";
    private static final String PERCENTILE_WRITE_TIME = "percentileWriteTime";
    private static final String PERCENTILE_WRITE_COUNT = "percentileWriteCount";
    private static final ItemHistogram.ItemHistogramBuilder HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private static final ItemList.ItemListBuilder LIST = new ItemList.ItemListBuilder();
    private static final DurationPercentileTable.DurationPercentileTableBuilder PERCENTILES = new DurationPercentileTable.DurationPercentileTableBuilder();
    private ColumnManager.SelectionState tableSelection;
    private ColumnManager.SelectionState itemListSelection;
    private ColumnManager.SelectionState percentileSelection;
    private IItemFilter tableFilter = null;
    private IItemFilter itemListFilter = null;
    private int tabFolderIndex = 0;
    private IRange<IQuantity> timelineRange;
    private IRange<IQuantity> durationRange;
    private IRange<IQuantity> sizeRange;
    public FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        HISTOGRAM.addCountColumn();
        HISTOGRAM.addColumn(TOTAL_TIME, JdkAggregators.TOTAL_IO_TIME);
        HISTOGRAM.addColumn(MAX_TIME, JdkAggregators.MAX_IO_TIME);
        HISTOGRAM.addColumn(AVG_TIME, JdkAggregators.AVG_IO_TIME);
        HISTOGRAM.addColumn(STDDEV_TIME, JdkAggregators.STDDEV_IO_TIME);
        HISTOGRAM.addColumn(READ_COUNT, JdkAggregators.FILE_READ_COUNT);
        HISTOGRAM.addColumn(WRITE_COUNT, JdkAggregators.FILE_WRITE_COUNT);
        HISTOGRAM.addColumn(READ_SIZE, JdkAggregators.FILE_READ_SIZE);
        HISTOGRAM.addColumn(WRITE_SIZE, JdkAggregators.FILE_WRITE_SIZE);
        LIST.addColumn(JdkAttributes.IO_PATH);
        LIST.addColumn(JfrAttributes.START_TIME);
        LIST.addColumn(JfrAttributes.END_TIME);
        LIST.addColumn(JfrAttributes.DURATION);
        LIST.addColumn(JdkAttributes.IO_FILE_BYTES_READ);
        LIST.addColumn(JdkAttributes.IO_FILE_BYTES_WRITTEN);
        LIST.addColumn(JfrAttributes.EVENT_THREAD);
        LIST.addColumn(JdkAttributes.IO_FILE_READ_EOF);
        PERCENTILES.addSeries(PERCENTILE_READ_TIME, Messages.FileIOPage_ROW_FILE_READ, PERCENTILE_READ_COUNT, JdkAggregators.FILE_READ_COUNT.getName(), "jdk.FileRead");
        PERCENTILES.addSeries(PERCENTILE_WRITE_TIME, Messages.FileIOPage_ROW_FILE_WRITE, PERCENTILE_WRITE_COUNT, JdkAggregators.FILE_WRITE_COUNT.getName(), "jdk.FileWrite");
    }

    private static TableSettings getTableSettings(IState state) {
        if (state == null) {
            return new TableSettings(TOTAL_TIME, Arrays.asList(new TableSettings.ColumnSettings("itemhistogram.key", Boolean.valueOf(false), Integer.valueOf(500), null), new TableSettings.ColumnSettings(TOTAL_TIME, Boolean.valueOf(true), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(MAX_TIME, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(AVG_TIME, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(STDDEV_TIME, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(READ_COUNT, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(WRITE_COUNT, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(READ_SIZE, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(WRITE_SIZE, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(READ_EOF, Boolean.valueOf(false), Integer.valueOf(80), Boolean.valueOf(false))));
        }
        return new TableSettings(state);
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new IOPageUi(parent, toolkit, pageContainer, state);
    }

    public FileIOPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.timelineRange = editor.getRecordingRange();
        this.durationRange = editor.getRecordingRange();
        this.sizeRange = DataPageToolkit.buildSizeRange(items.getItems(), false);
    }

    private static Color getColor(IItem item) {
        return "jdk.FileRead".equals(item.getType().getIdentifier()) ? READ_ALPHA_COLOR : WRITE_ALPHA_COLOR;
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return TABLE_ITEMS;
    }

    private static String pathCount(int count) {
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return " (" + Messages.FileIOPage_SELECTED_PATH + ")";
            }
        }
        return " (" + NLS.bind((String)Messages.FileIOPage_SELECTED_PATHS, (Object)count) + ")";
    }

    static /* synthetic */ Color access$23(IItem iItem) {
        return FileIOPage.getColor(iItem);
    }

    public static class FileIOPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.FileIOPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/io.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"file_io"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new FileIOPage(dpd, items, editor);
        }
    }

    private class IOPageUi
    implements IPageUI {
        private static final String FILE_IO_TABLE = "fileIoTable";
        private static final String FILE_IO_LIST = "fileIoList";
        private static final String SASH_ELEMENT = "sash";
        private static final String LIST_ELEMENT = "eventList";
        private static final String TABLE_ELEMENT = "table";
        private static final String PERCENTILE_TABLE_ELEMENT = "percentileTable";
        private final ChartCanvas timelineCanvas;
        private final ChartCanvas durationCanvas;
        private final ChartCanvas sizeCanvas;
        private XYChart timelineChart;
        private IRange<IQuantity> timeRange;
        private IItemCollection selectionItems;
        private final ItemList itemList;
        private final ItemHistogram table;
        private final SashForm sash;
        private final IPageContainer pageContainer;
        private FilterComponent tableFilter;
        private FilterComponent itemListFilter;
        private FlavorSelector flavorSelector;
        private DurationPercentileTable percentileTable;
        private Composite durationParent;

        IOPageUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.pageContainer = pageContainer;
            Form form = DataPageToolkit.createForm(parent, toolkit, FileIOPage.this.getName(), FileIOPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            toolkit.adapt((Composite)this.sash);
            FileIOPage.this.addResultActions(form);
            this.table = HISTOGRAM.buildWithoutBorder((Composite)this.sash, JdkAttributes.IO_PATH, FileIOPage.getTableSettings(state.getChild(TABLE_ELEMENT)));
            MCContextMenuManager mm = MCContextMenuManager.create((Control)this.table.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.table.getManager(), (MCContextMenuManager)mm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.table, Messages.FileIOPage_HISTOGRAM_SELECTION, (IContributionManager)mm);
            this.table.getManager().getViewer().addSelectionChangedListener(e -> this.updateDetails());
            this.table.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(this.table.getSelection().getItems()));
            this.tableFilter = FilterComponent.createFilterComponent(this.table, FileIOPage.this.tableFilter, FileIOPage.this.getDataSource().getItems().apply(TABLE_ITEMS), pageContainer.getSelectionStore()::getSelections, this::onTableFilterChange);
            mm.add(this.tableFilter.getShowFilterAction());
            mm.add(this.tableFilter.getShowSearchAction());
            CTabFolder tabFolder = new CTabFolder((Composite)this.sash, 0);
            toolkit.adapt((Composite)tabFolder);
            CTabItem t1 = new CTabItem(tabFolder, 0);
            t1.setToolTipText(Messages.IO_PAGE_TIMELINE_DESCRIPTION);
            this.timelineCanvas = new ChartCanvas((Composite)tabFolder);
            t1.setText(Messages.PAGES_TIMELINE);
            t1.setControl((Control)this.timelineCanvas);
            DataPageToolkit.createChartTimestampTooltip(this.timelineCanvas);
            CTabItem t2 = new CTabItem(tabFolder, 0);
            this.durationParent = toolkit.createComposite((Composite)tabFolder);
            this.durationParent.setLayout((Layout)new SimpleLayout());
            t2.setToolTipText(Messages.IO_PAGE_DURATIONS_DESCRIPTION);
            this.durationCanvas = new ChartCanvas(this.durationParent);
            this.durationCanvas.setLayoutData((Object)new SimpleLayoutData(3.5f));
            DataPageToolkit.createChartTooltip(this.durationCanvas);
            this.percentileTable = PERCENTILES.build(this.durationParent, TableSettings.forState((IState)state.getChild(PERCENTILE_TABLE_ELEMENT)));
            this.percentileTable.getManager().getViewer().getControl().setLayoutData((Object)new SimpleLayoutData(6.5f));
            MCContextMenuManager percentileTableMm = MCContextMenuManager.create((Control)this.percentileTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.percentileTable.getManager(), (MCContextMenuManager)percentileTableMm);
            SelectionStoreActionToolkit.addSelectionStoreActions((StructuredViewer)this.percentileTable.getManager().getViewer(), pageContainer.getSelectionStore(), this.percentileTable::getSelectedItems, Messages.FileIOPage_PERCENTILE_SELECTION, (IContributionManager)percentileTableMm);
            t2.setText(Messages.PAGES_DURATIONS);
            t2.setControl((Control)this.durationParent);
            CTabItem t3 = new CTabItem(tabFolder, 0);
            t3.setToolTipText(Messages.IO_PAGE_SIZE_DESCRIPTION);
            this.sizeCanvas = new ChartCanvas((Composite)tabFolder);
            t3.setText(Messages.PAGES_SIZE);
            t3.setControl((Control)this.sizeCanvas);
            DataPageToolkit.createChartTooltip(this.sizeCanvas);
            CTabItem t4 = new CTabItem(tabFolder, 0);
            t4.setToolTipText(Messages.IO_PAGE_EVENT_LOG_DESCRIPTION);
            this.itemList = LIST.buildWithoutBorder((Composite)tabFolder, FileIOPage.getTableSettings(state.getChild(LIST_ELEMENT)));
            MCContextMenuManager itemListMm = MCContextMenuManager.create((Control)this.itemList.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.itemList.getManager(), (MCContextMenuManager)itemListMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.itemList, Messages.FileIOPage_LOG_SELECTION, (IContributionManager)itemListMm);
            this.itemList.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.itemList.getSelection().get())));
            t4.setText(Messages.PAGES_EVENT_LOG);
            this.itemListFilter = FilterComponent.createFilterComponent(this.itemList, FileIOPage.this.itemListFilter, FileIOPage.this.getDataSource().getItems().apply(TABLE_ITEMS), pageContainer.getSelectionStore()::getSelections, this::onListFilterChange);
            itemListMm.add(this.itemListFilter.getShowFilterAction());
            itemListMm.add(this.itemListFilter.getShowSearchAction());
            t4.setControl((Control)this.itemListFilter.getComponent());
            this.tableFilter.loadState(state.getChild(FILE_IO_TABLE));
            this.itemListFilter.loadState(state.getChild(FILE_IO_LIST));
            tabFolder.setSelection(FileIOPage.this.tabFolderIndex);
            tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileIOPage.this.tabFolderIndex = ((CTabFolder)e.getSource()).getSelectionIndex();
                }
            });
            this.timelineChart = this.createTimelineChart(pageContainer);
            this.hookUpTimeLineChart();
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(SASH_ELEMENT));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, TABLE_ITEMS, FileIOPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, this::onShowFlavor, FileIOPage.this.flavorSelectorState);
            this.table.getManager().setSelectionState(FileIOPage.this.tableSelection);
            this.percentileTable.getManager().setSelectionState(FileIOPage.this.percentileSelection);
            this.itemList.getManager().setSelectionState(FileIOPage.this.itemListSelection);
        }

        private XYChart createTimelineChart(IPageContainer pageContainer) {
            XYChart timelineChart = new XYChart(pageContainer.getRecordingRange(), RendererToolkit.empty(), 180);
            timelineChart.setVisibleRange((IQuantity)FileIOPage.this.timelineRange.getStart(), (IQuantity)FileIOPage.this.timelineRange.getEnd());
            timelineChart.addVisibleRangeListener(range -> {
                IRange iRange = range;
                IRange iRange2 = iRange;
                FileIOPage.this.timelineRange = iRange;
            });
            return timelineChart;
        }

        private void onTableFilterChange(IItemFilter filter) {
            this.tableFilter.filterChangeHelper(filter, this.table, FileIOPage.this.getDataSource().getItems().apply(TABLE_ITEMS));
            this.itemListFilter.notifyListener();
            FileIOPage.this.tableFilter = filter;
        }

        private void onListFilterChange(IItemFilter filter) {
            this.itemListFilter.filterChangeHelper(filter, this.itemList, FileIOPage.this.getDataSource().getItems().apply(TABLE_ITEMS));
            FileIOPage.this.itemListFilter = filter;
        }

        public void saveTo(IWritableState writableState) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)writableState.createChild(SASH_ELEMENT));
            this.table.getManager().getSettings().saveState(writableState.createChild(TABLE_ELEMENT));
            this.tableFilter.saveState(writableState.createChild(FILE_IO_TABLE));
            this.itemList.getManager().getSettings().saveState(writableState.createChild(LIST_ELEMENT));
            this.itemListFilter.saveState(writableState.createChild(FILE_IO_LIST));
            this.percentileTable.getManager().getSettings().saveState(writableState.createChild(PERCENTILE_TABLE_ELEMENT));
            this.saveToLocal();
        }

        private void saveToLocal() {
            FileIOPage.this.tableSelection = this.table.getManager().getSelectionState();
            FileIOPage.this.itemListSelection = this.itemList.getManager().getSelectionState();
            FileIOPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
            FileIOPage.this.percentileSelection = this.percentileTable.getManager().getSelectionState();
        }

        private void onShowFlavor(Boolean show) {
            IRange<IQuantity> range = show != false ? this.timeRange : this.pageContainer.getRecordingRange();
            this.timelineChart.setVisibleRange((IQuantity)range.getStart(), (IQuantity)range.getEnd());
            this.hookUpTimeLineChart();
        }

        private void hookUpTimeLineChart() {
            DataPageToolkit.setChart(this.timelineCanvas, this.timelineChart, this.pageContainer::showSelection);
            SelectionStoreActionToolkit.addSelectionStoreRangeActions(this.pageContainer.getSelectionStore(), this.timelineChart, (IAttribute<IRange<IQuantity>>)JfrAttributes.LIFETIME, Messages.FileIOPage_TIMELINE_SELECTION, (IContributionManager)this.timelineCanvas.getContextMenu());
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.selectionItems = items;
            this.timeRange = timeRange;
            this.updateDetails();
        }

        private void updateDetails() {
            IItemCollection writeItems;
            IItemCollection items = this.selectionItems != null ? this.selectionItems.apply(TABLE_ITEMS) : FileIOPage.this.getDataSource().getItems().apply(TABLE_ITEMS);
            this.table.show(items);
            ItemHistogram.HistogramSelection histogramSelection = this.table.getSelection();
            IItemCollection selectedItems = histogramSelection.getRowCount() == 0 ? items : histogramSelection.getItems();
            String pathCount = FileIOPage.pathCount(histogramSelection.getRowCount());
            ArrayList<IXDataRenderer> timelineRows = new ArrayList<IXDataRenderer>();
            ArrayList<ItemRow> durationRows = new ArrayList<ItemRow>();
            ArrayList<ItemRow> sizeRows = new ArrayList<ItemRow>();
            IItemCollection readItems = selectedItems.apply(JdkFilters.FILE_READ);
            if (readItems.hasItems()) {
                timelineRows.add(DataPageToolkit.buildSizeRow(String.valueOf(Messages.FileIOPage_ROW_FILE_READ) + pathCount, JdkAggregators.FILE_READ_SIZE.getDescription(), readItems, JdkAggregators.FILE_READ_SIZE, READ_COLOR, (AWTChartToolkit.IColorProvider<IItem>)((AWTChartToolkit.IColorProvider)FileIOPage::access$23)));
                durationRows.add(DataPageToolkit.buildDurationHistogram(String.valueOf(Messages.FileIOPage_ROW_FILE_READ) + pathCount, JdkAggregators.FILE_READ_COUNT.getDescription(), readItems, JdkAggregators.FILE_READ_COUNT, READ_COLOR));
                sizeRows.add(DataPageToolkit.buildSizeHistogram(String.valueOf(Messages.FileIOPage_ROW_FILE_READ) + pathCount, JdkAggregators.FILE_READ_COUNT.getDescription(), readItems, JdkAggregators.FILE_READ_COUNT, READ_COLOR, (IAttribute<IQuantity>)JdkAttributes.IO_FILE_BYTES_READ));
            }
            if ((writeItems = selectedItems.apply(JdkFilters.FILE_WRITE)).hasItems()) {
                timelineRows.add(DataPageToolkit.buildSizeRow(String.valueOf(Messages.FileIOPage_ROW_FILE_WRITE) + pathCount, JdkAggregators.FILE_WRITE_SIZE.getDescription(), writeItems, JdkAggregators.FILE_WRITE_SIZE, WRITE_COLOR, (AWTChartToolkit.IColorProvider<IItem>)((AWTChartToolkit.IColorProvider)FileIOPage::access$23)));
                durationRows.add(DataPageToolkit.buildDurationHistogram(String.valueOf(Messages.FileIOPage_ROW_FILE_WRITE) + pathCount, JdkAggregators.FILE_WRITE_COUNT.getDescription(), writeItems, JdkAggregators.FILE_WRITE_COUNT, WRITE_COLOR));
                sizeRows.add(DataPageToolkit.buildSizeHistogram(String.valueOf(Messages.FileIOPage_ROW_FILE_WRITE) + pathCount, JdkAggregators.FILE_WRITE_COUNT.getDescription(), writeItems, JdkAggregators.FILE_WRITE_COUNT, WRITE_COLOR, (IAttribute<IQuantity>)JdkAttributes.IO_FILE_BYTES_WRITTEN));
            }
            this.timelineCanvas.replaceRenderer(RendererToolkit.uniformRows(timelineRows));
            IXDataRenderer durationRoot = RendererToolkit.uniformRows(durationRows);
            IQuantity max = (IQuantity)selectedItems.getAggregate(JdkAggregators.LONGEST_EVENT);
            max = max == null ? UnitLookup.MILLISECOND.quantity(20L) : max.add((IQuantity)UnitLookup.MILLISECOND.quantity(20L));
            XYChart durationChart = new XYChart((IQuantity)UnitLookup.MILLISECOND.quantity(0L), max, durationRoot, 180);
            DataPageToolkit.setChart(this.durationCanvas, durationChart, (IAttribute<IQuantity>)JfrAttributes.DURATION, selection -> this.pageContainer.showSelection((IItemCollection)selection));
            durationChart.setVisibleRange((IQuantity)FileIOPage.this.durationRange.getStart(), (IQuantity)FileIOPage.this.durationRange.getEnd());
            durationChart.addVisibleRangeListener(range -> {
                IRange iRange = range;
                IRange iRange2 = iRange;
                FileIOPage.this.durationRange = iRange;
            });
            this.durationCanvas.setChart(durationChart);
            SelectionStoreActionToolkit.addSelectionStoreActions(this.pageContainer.getSelectionStore(), durationChart, (IAttribute<IQuantity>)JfrAttributes.DURATION, Messages.FileIOPage_DURATION_SELECTION, (IContributionManager)this.durationCanvas.getContextMenu());
            this.itemList.show(selectedItems);
            this.percentileTable.update(selectedItems);
            IXDataRenderer sizeRoot = RendererToolkit.uniformRows(sizeRows);
            IQuantity sizeMax = (IQuantity)selectedItems.getAggregate(JdkAggregators.FILE_READ_LARGEST);
            sizeMax = sizeMax == null ? UnitLookup.BYTE.quantity(64L) : sizeMax.add((IQuantity)UnitLookup.BYTE.quantity(64L));
            XYChart sizeChart = new XYChart((IQuantity)UnitLookup.BYTE.quantity(0L), sizeMax, sizeRoot, 180);
            DataPageToolkit.setChart(this.sizeCanvas, sizeChart, (IAttribute<IQuantity>)JdkAttributes.IO_SIZE, selection -> this.pageContainer.showSelection((IItemCollection)selection));
            sizeChart.setVisibleRange((IQuantity)FileIOPage.this.sizeRange.getStart(), (IQuantity)FileIOPage.this.sizeRange.getEnd());
            sizeChart.addVisibleRangeListener(range -> {
                IRange iRange = range;
                IRange iRange2 = iRange;
                FileIOPage.this.sizeRange = iRange;
            });
            this.sizeCanvas.setChart(sizeChart);
            SelectionStoreActionToolkit.addSelectionStoreActions(this.pageContainer.getSelectionStore(), sizeChart, (IAttribute<IQuantity>)JdkAttributes.IO_SIZE, Messages.FileIOPage_SIZE_SELECTION, (IContributionManager)this.sizeCanvas.getContextMenu());
        }
    }
}

