/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import java.util.List;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Root;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.HprofParsingCancelledException;
import org.openjdk.jmc.joverflow.stats.InterimRefChain;

abstract class HeapScaner {
    protected final Snapshot snapshot;
    private final InterimRefChain refChain;
    protected int currentProcessedObjNo;
    private final int nTotalObjects;
    protected boolean cancelled;
    private static final boolean REPORT_UNVISITED = false;

    protected HeapScaner(Snapshot snapshot, InterimRefChain refChain) {
        this.snapshot = snapshot;
        this.refChain = refChain;
        this.nTotalObjects = snapshot.getNumObjects();
    }

    protected abstract void scanObjectsFromRootObj(JavaHeapObject var1);

    protected void analyzeViaRoots() throws HprofParsingCancelledException {
        List<Root> roots = this.snapshot.getRoots();
        for (Root root : roots) {
            this.refChain.setCurrentRoot(root);
            JavaHeapObject rootObj = this.snapshot.getObjectForId(root.getId());
            if (rootObj == null || rootObj instanceof JavaValueArray) continue;
            this.scanObjectsFromRootObj(rootObj);
        }
        this.refChain.setCurrentRoot(null);
    }

    protected void analyzeViaAllObjectsEnum() throws HprofParsingCancelledException {
        int nObjsBefore = this.currentProcessedObjNo;
        this.refChain.setCurrentRoot(Root.UNKNOWN_ROOT);
        if (this.cancelled) {
            throw new HprofParsingCancelledException();
        }
        for (JavaLazyReadObject javaLazyReadObject : this.snapshot.getUnvisitedObjects()) {
            if (!javaLazyReadObject.getClazz().isCollectionWithOtherCollectionInImpl()) continue;
            this.refChain.resetCurrentRoot();
            this.scanObjectsFromRootObj(javaLazyReadObject);
        }
        if (this.cancelled) {
            throw new HprofParsingCancelledException();
        }
        for (JavaHeapObject javaHeapObject : this.snapshot.getUnvisitedObjects()) {
            JavaClass objClazz = javaHeapObject.getClazz();
            if (!objClazz.isCollection() && !objClazz.isString()) continue;
            this.refChain.resetCurrentRoot();
            this.scanObjectsFromRootObj(javaHeapObject);
        }
        if (this.cancelled) {
            throw new HprofParsingCancelledException();
        }
        for (JavaHeapObject javaHeapObject : this.snapshot.getUnvisitedObjects()) {
            this.refChain.resetCurrentRoot();
            this.scanObjectsFromRootObj(javaHeapObject);
        }
        if (this.cancelled) {
            throw new HprofParsingCancelledException();
        }
    }

    protected void done() {
        this.refChain.convertRefChainElementsToFinalRepresentation();
    }

    protected InterimRefChain getRefChain() {
        return this.refChain;
    }

    public synchronized int getProgressPercentage() {
        return (int)((long)this.currentProcessedObjNo * 100L / (long)this.nTotalObjects);
    }

    public synchronized void cancelCalculation() {
        this.cancelled = true;
    }

    void incrementCurrentProcessedObjNo() {
        ++this.currentProcessedObjNo;
    }
}

