/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.flameview.tree;

import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.flightrecorder.flameview.tree.TraceNode;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;

public class TraceTreeUtils {
    public static final String DEFAULT_ROOT_NAME = "__root";
    public static final FrameSeparator DEFAULT_FRAME_SEPARATOR = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);

    public static TraceNode createTree(StacktraceModel model, String rootName) {
        StacktraceModel.Fork rootFork = model.getRootFork();
        TraceNode root = new TraceNode(rootName == null ? DEFAULT_ROOT_NAME : rootName, rootFork.getItemsInFork());
        StacktraceModel.Branch[] branchArray = rootFork.getBranches();
        int n = branchArray.length;
        int n2 = 0;
        while (n2 < n) {
            StacktraceModel.Branch branch = branchArray[n2];
            TraceTreeUtils.addBranch(root, branch);
            ++n2;
        }
        return root;
    }

    public static TraceNode createTree(IItemCollection items, FrameSeparator frameSeparator, boolean threadRootAtTop, String rootName) {
        return TraceTreeUtils.createTree(new StacktraceModel(threadRootAtTop, frameSeparator, items), rootName);
    }

    private static void addBranch(TraceNode root, StacktraceModel.Branch branch) {
        StacktraceFrame firstFrame = branch.getFirstFrame();
        TraceNode currentNode = new TraceNode(TraceTreeUtils.format(firstFrame), firstFrame.getItemCount());
        root.addChild(currentNode);
        StacktraceFrame[] stacktraceFrameArray = branch.getTailFrames();
        int n = stacktraceFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            StacktraceFrame frame = stacktraceFrameArray[n2];
            TraceNode newNode = new TraceNode(TraceTreeUtils.format(frame), frame.getItemCount());
            currentNode.addChild(newNode);
            currentNode = newNode;
            ++n2;
        }
        TraceTreeUtils.addFork(currentNode, branch.getEndFork());
    }

    private static void addFork(TraceNode node, StacktraceModel.Fork fork) {
        StacktraceModel.Branch[] branchArray = fork.getBranches();
        int n = branchArray.length;
        int n2 = 0;
        while (n2 < n) {
            StacktraceModel.Branch branch = branchArray[n2];
            TraceTreeUtils.addBranch(node, branch);
            ++n2;
        }
    }

    private static String format(StacktraceFrame sFrame) {
        IMCFrame frame = sFrame.getFrame();
        IMCMethod method = frame.getMethod();
        return FormatToolkit.getHumanReadable((IMCMethod)method, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)false);
    }

    public static String printTree(TraceNode node) {
        StringBuilder builder = new StringBuilder();
        builder.append("=== Tree Printout ===");
        builder.append(System.lineSeparator());
        TraceTreeUtils.printTree(builder, 0, node);
        return builder.toString();
    }

    private static void printTree(StringBuilder builder, int indentation, TraceNode node) {
        builder.append(String.format("%s%s - %d%n", TraceTreeUtils.indent(indentation), node.getName(), node.getValue()));
        for (TraceNode child : node.getChildren()) {
            TraceTreeUtils.printTree(builder, indentation + 1, child);
        }
    }

    private static String indent(int indentation) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < indentation) {
            builder.append("   ");
            ++i;
        }
        return builder.toString();
    }
}

