/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.flameview.views;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.flightrecorder.flameview.tree.TraceNode;
import org.openjdk.jmc.flightrecorder.flameview.tree.TraceTreeUtils;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.CoreImages;
import org.openjdk.jmc.ui.common.util.AdapterUtil;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class FlameGraphView
extends ViewPart
implements ISelectionListener {
    private static final String HTML_PAGE;
    private static final ExecutorService MODEL_EXECUTOR;
    private FrameSeparator frameSeparator;
    private Browser browser;
    private SashForm container;
    private TraceNode currentRoot;
    private CompletableFuture<TraceNode> currentModelCalculator;
    private boolean threadRootAtTop = true;
    private IItemCollection currentItems;
    private GroupByAction[] groupByActions;

    static {
        String cssD3Flamegraph = "jslibs/d3-flamegraph.css";
        String jsHtml5shiv = "jslibs/html5shiv.min.js";
        String jsRespond = "jslibs/respond.min.js";
        String jsD3V4 = "jslibs/d3.v4.min.js";
        String jsD3Tip = "jslibs/d3-tip.min.js";
        String jsD3FlameGraph = "jslibs/d3-flamegraph.min.js";
        String jsIeLibraries = FlameGraphView.loadLibraries(jsHtml5shiv, jsRespond);
        String jsD3Libraries = FlameGraphView.loadLibraries(jsD3V4, jsD3Tip, jsD3FlameGraph);
        HTML_PAGE = String.format(FlameGraphView.fileContent("page.template"), FlameGraphView.fileContent(cssD3Flamegraph), jsIeLibraries, jsD3Libraries);
        MODEL_EXECUTOR = Executors.newFixedThreadPool(1);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.frameSeparator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
        this.groupByActions = new GroupByAction[]{new GroupByAction(false), new GroupByAction(true)};
        IMenuManager siteMenu = site.getActionBars().getMenuManager();
        siteMenu.add((IContributionItem)new Separator("group.top"));
        siteMenu.add((IContributionItem)new Separator("group.viewerSetup"));
        IToolBarManager toolBar = site.getActionBars().getToolBarManager();
        Stream.of(this.groupByActions).forEach(arg_0 -> ((IToolBarManager)toolBar).add(arg_0));
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.container = new SashForm(parent, 256);
        this.browser = new Browser((Composite)this.container, 0);
        this.container.setMaximizedControl((Control)this.browser);
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void saveState(IMemento memento) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            this.setItems((IItemCollection)AdapterUtil.getAdapter((Object)first, IItemCollection.class));
        }
    }

    private void setItems(IItemCollection items) {
        if (items != null) {
            this.currentItems = items;
            this.rebuildModel(items);
        }
    }

    private void rebuildModel(IItemCollection items) {
        if (this.currentModelCalculator != null) {
            this.currentModelCalculator.cancel(true);
        }
        this.currentModelCalculator = this.getModelPreparer(items, this.frameSeparator, true);
        ((CompletableFuture)this.currentModelCalculator.thenAcceptAsync(this::setModel, DisplayToolkit.inDisplayThread())).exceptionally(FlameGraphView::handleModelBuildException);
    }

    private CompletableFuture<TraceNode> getModelPreparer(IItemCollection items, FrameSeparator separator, boolean materializeSelectedBranches) {
        return CompletableFuture.supplyAsync(() -> TraceTreeUtils.createTree(items, separator, this.threadRootAtTop, "-- <Root> --"), MODEL_EXECUTOR);
    }

    private void setModel(TraceNode root) {
        if (!this.browser.isDisposed() && !root.equals(this.currentRoot)) {
            this.currentRoot = root;
            this.setViewerInput(root);
        }
    }

    private void setViewerInput(final TraceNode root) {
        this.browser.setText(HTML_PAGE);
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                FlameGraphView.this.browser.removeProgressListener((ProgressListener)this);
                FlameGraphView.this.browser.execute(String.format("processGraph(%s);", FlameGraphView.toJSon(root)));
            }
        });
    }

    private static Void handleModelBuildException(Throwable ex) {
        if (!(ex.getCause() instanceof CancellationException)) {
            FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Failed to build stacktrace view model", ex);
        }
        return null;
    }

    private static String toJSon(TraceNode root) {
        if (root == null) {
            return "\"\"";
        }
        return FlameGraphView.render(root);
    }

    private static String render(TraceNode root) {
        StringBuilder builder = new StringBuilder();
        FlameGraphView.render(builder, root);
        return builder.toString();
    }

    private static void render(StringBuilder builder, TraceNode node) {
        String start = String.format("{%s,%s, \"c\": [ ", FlameGraphView.toJSonKeyValue("n", node.getName()), FlameGraphView.toJSonKeyValue("v", String.valueOf(node.getValue())));
        builder.append(start);
        int i = 0;
        while (i < node.getChildren().size()) {
            FlameGraphView.render(builder, node.getChildren().get(i));
            if (i < node.getChildren().size() - 1) {
                builder.append(",");
            }
            ++i;
        }
        builder.append("]}");
    }

    private static String toJSonKeyValue(String key, String value) {
        return "\"" + key + "\": " + "\"" + value + "\"";
    }

    private static String loadLibraries(String ... libs) {
        if (libs == null || libs.length == 0) {
            return "";
        }
        return Stream.of(libs).map(FlameGraphView::fileContent).collect(Collectors.joining("\n"));
    }

    private static String fileContent(String fileName) {
        try {
            return StringToolkit.readString((InputStream)FlameGraphView.class.getClassLoader().getResourceAsStream(fileName));
        }
        catch (IOException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, MessageFormat.format("Could not load script \"{0}\",\"{1}\"", fileName, e.getMessage()));
            return "";
        }
    }

    private class GroupByAction
    extends Action {
        private final boolean fromThreadRootAction;

        GroupByAction(boolean fromRoot) {
            super(fromRoot ? Messages.STACKTRACE_VIEW_THREAD_ROOT : Messages.STACKTRACE_VIEW_LAST_FRAME, 8);
            this.fromThreadRootAction = fromRoot;
            this.setToolTipText(fromRoot ? Messages.STACKTRACE_VIEW_GROUP_TRACES_FROM_ROOT : Messages.STACKTRACE_VIEW_GROUP_TRACES_FROM_LAST_FRAME);
            this.setImageDescriptor(fromRoot ? CoreImages.THREAD : CoreImages.METHOD_NON_OPTIMIZED);
            this.setChecked(fromRoot == FlameGraphView.this.threadRootAtTop);
        }

        public void run() {
            boolean newValue;
            boolean bl = newValue = this.isChecked() == this.fromThreadRootAction;
            if (newValue != FlameGraphView.this.threadRootAtTop) {
                FlameGraphView.this.threadRootAtTop = newValue;
                FlameGraphView.this.rebuildModel(FlameGraphView.this.currentItems);
            }
        }
    }
}

