/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.exceptions;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanSquare;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanToolkit;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class ExceptionRule
implements IRule {
    private static final String RESULT_ID = "Exceptions";
    public static final TypedPreference<IQuantity> EXCEPTIONS_INFO_LIMIT = new TypedPreference("exception.info.limit", Messages.getString("ExceptionRule_CONFIG_INFO_LIMIT"), Messages.getString("ExceptionRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(5000L));
    public static final TypedPreference<IQuantity> EXCEPTIONS_WARNING_LIMIT = new TypedPreference("exception.warning.limit", Messages.getString("ExceptionRule_CONFIG_WARN_LIMIT"), Messages.getString("ExceptionRule_CONFIG_WARN_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(10000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(EXCEPTIONS_INFO_LIMIT, EXCEPTIONS_WARNING_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ExceptionStatistics"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.ExceptionStatistics"});
        }
        long infoLimit = ((IQuantity)vp.getPreferenceValue(EXCEPTIONS_INFO_LIMIT)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        long warningLimit = ((IQuantity)vp.getPreferenceValue(EXCEPTIONS_WARNING_LIMIT)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        SpanSquare maxExceptionPeriod = SpanToolkit.getMaxCountCluster(items.apply(JdkFilters.THROWABLES_STATISTICS), (IAttribute<IQuantity>)JdkAttributes.EXCEPTION_THROWABLES_COUNT, (IAttribute<IQuantity>)JfrAttributes.EVENT_TIMESTAMP);
        if (maxExceptionPeriod != null) {
            double duration = (double)(maxExceptionPeriod.end - maxExceptionPeriod.start) / 1.0E9;
            double exPerSec = (double)maxExceptionPeriod.mass / duration;
            double score = RulesToolkit.mapExp100((double)exPerSec, (double)infoLimit, (double)warningLimit);
            String startTime = KindOfQuantity.format((Number)maxExceptionPeriod.start, (IUnit)UnitLookup.EPOCH_NS);
            String durationStr = KindOfQuantity.format((Number)duration, (IUnit)UnitLookup.SECOND);
            String exPerSecStr = KindOfQuantity.format((Number)exPerSec, (IUnit)UnitLookup.NUMBER_UNITY);
            String message = MessageFormat.format(Messages.getString("ExceptionRule_TEXT_MESSAGE"), durationStr, startTime, exPerSecStr);
            String longMessage = null;
            if (score >= 25.0) {
                longMessage = message + "<p>" + Messages.getString("ExceptionRule_TEXT_INFO_LONG");
            }
            return new Result((IRule)this, score, message, longMessage, JdkQueries.THROWABLES_STATISTICS);
        }
        return RulesToolkit.getTooFewEventsResult((IRule)this);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return ExceptionRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ExceptionRule_RULE_NAME");
    }

    public String getTopic() {
        return "exceptions";
    }
}

