/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class TlabAllocationRatioRule
implements IRule {
    private static final String RESULT_ID = "TlabAllocationRatio";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        String shortMessage;
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
        if (eventAvailability == RulesToolkit.EventAvailability.DISABLED || eventAvailability == RulesToolkit.EventAvailability.UNKNOWN) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
        }
        IQuantity insideSum = (IQuantity)items.getAggregate(JdkAggregators.ALLOC_INSIDE_TLAB_SUM);
        IQuantity outsideSum = (IQuantity)items.getAggregate(JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM);
        if (outsideSum == null) {
            return new Result((IRule)this, 0.0, Messages.getString("TlabAllocationRatioRuleFactory_TEXT_OK_NO_OUTSIDE"));
        }
        if (insideSum == null) {
            String shortMessage2 = Messages.getString("TlabAllocationRatioRuleFactory_TEXT_INFO_ONLY_OUTSIDE");
            String longMessage = Messages.getString("TlabAllocationRatioRuleFactory_TEXT_INFO_ONLY_OUTSIDE_LONG") + "<p>" + Messages.getString("TlabAllocationRatioRuleFactory_TEXT_RECOMMEND_LESS_ALLOCATION");
            return new Result((IRule)this, 100.0, shortMessage2, longMessage);
        }
        IQuantity totalSum = insideSum.add(outsideSum);
        double rawRatio = outsideSum.ratioTo(totalSum);
        double score = RulesToolkit.mapExp74((double)rawRatio, (double)0.2);
        String longMessage = shortMessage = MessageFormat.format(Messages.getString("TlabAllocationRatioRuleFactory_TEXT_INFO"), UnitLookup.PERCENT_UNITY.quantity(rawRatio).displayUsing("auto"));
        if (score >= 25.0) {
            longMessage = longMessage + "<p>" + Messages.getString("TlabAllocationRatioRuleFactory_TEXT_RECOMMEND_LESS_ALLOCATION");
        }
        return new Result((IRule)this, score, shortMessage, longMessage);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return TlabAllocationRatioRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("TlabAllocationRatioRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "tlab";
    }
}

