/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.joverflow.ui.util.BaseArcAttributeProvider;

public class ColorIndexedArcAttributeProvider
extends BaseArcAttributeProvider {
    private final Color COLOR_GRAY = Display.getCurrent().getSystemColor(15);
    private int totalWeight = 0;
    private int minimumAngle = 0;
    private Map<Object, Color> colors = new HashMap<Object, Color>();

    public ColorIndexedArcAttributeProvider() {
        this.addListener(event -> {
            Object e;
            this.totalWeight = 0;
            this.colors.clear();
            Object[] objectArray = event.getElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                e = objectArray[n2];
                this.totalWeight += this.getWeight(e);
                ++n2;
            }
            Arrays.sort(event.getElements(), (o1, o2) -> this.getWeight(o2) - this.getWeight(o1));
            objectArray = event.getElements();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                e = objectArray[n2];
                this.getColor(e);
                ++n2;
            }
        });
    }

    public void setMinimumArcAngle(int angle) {
        this.minimumAngle = angle;
    }

    @Override
    public Color getColor(Object element) {
        Color color = this.colors.get(element);
        if (color != null) {
            return color;
        }
        color = (double)this.getWeight(element) / (double)this.totalWeight * 360.0 < (double)this.minimumAngle ? this.COLOR_GRAY : super.getColor(element);
        this.colors.put(element, color);
        return color;
    }
}

