/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.viewers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.openjdk.jmc.joverflow.heap.model.JavaField;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.ui.model.JavaThingItem;

public class JavaThingTreeViewer<T extends JavaThingItem>
extends TreeViewer {
    public JavaThingTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.setContentProvider((IContentProvider)new JavaThingItemContentProvider());
        this.createTreeViewerColumn("Name", JavaThingItem::getName);
        this.createTreeViewerColumn("Value", JavaThingItem::getValue);
        this.createTreeViewerColumn("Size", JavaThingItem::getSize);
        this.getTree().setLinesVisible(true);
        this.getTree().setHeaderVisible(true);
    }

    private void createTreeViewerColumn(String label, final Function<T, String> labelProvider) {
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this, 0);
        column.getColumn().setWidth(300);
        column.getColumn().setText(label);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)labelProvider.apply((JavaThingItem)element);
            }
        });
    }

    private class JavaThingItemContentProvider
    implements ITreeContentProvider {
        private JavaThingItemContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            List items = (List)inputElement;
            return items.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            JavaThingItem item = (JavaThingItem)parentElement;
            Iterable<JavaThingItem> childItems = item.getChildItems();
            if (childItems == null) {
                ArrayList<JavaThingItem> items = new ArrayList<JavaThingItem>();
                JavaThing thing = item.getContent();
                if (thing instanceof JavaObject) {
                    JavaObject o = (JavaObject)thing;
                    JavaField[] fields = o.getClazz().getFieldsForInstance();
                    JavaThing[] values = o.getFields();
                    int i = 0;
                    while (i < fields.length) {
                        items.add(new JavaThingItem(item.getLevel() + 1, fields[i].getName(), values[i]));
                        ++i;
                    }
                } else if (thing instanceof JavaObjectArray) {
                    JavaObjectArray o = (JavaObjectArray)thing;
                    int i = 0;
                    JavaHeapObject[] javaHeapObjectArray = o.getElements();
                    int n = javaHeapObjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JavaHeapObject th = javaHeapObjectArray[n2];
                        items.add(new JavaThingItem(item.getLevel() + 1, "[" + i++ + "]", (JavaThing)th));
                        ++n2;
                    }
                } else if (thing instanceof JavaValueArray) {
                    JavaValueArray o = (JavaValueArray)thing;
                    int i = 0;
                    String[] stringArray = o.getValuesAsStrings();
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String value = stringArray[n3];
                        items.add(new JavaThingItem(item.getLevel() + 1, "[" + i++ + "]", value, o.getElementSize(), null));
                        ++n3;
                    }
                }
                item.setChildItems(items);
                return items.toArray();
            }
            return StreamSupport.stream(childItems.spliterator(), false).toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            JavaThingItem item = (JavaThingItem)element;
            JavaThing thing = item.getContent();
            return thing instanceof JavaObject && ((JavaObject)thing).getClazz().getFieldsForInstance().length > 0 || thing instanceof JavaObjectArray && ((JavaObjectArray)thing).getLength() > 0 || thing instanceof JavaValueArray && ((JavaValueArray)thing).getLength() > 0;
        }
    }
}

