/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx;

import javax.management.MBeanServerConnection;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.common.version.JavaVersionSupport;
import org.openjdk.jmc.rjmx.ConnectionToolkit;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.internal.ServerToolkit;
import org.openjdk.jmc.rjmx.messages.internal.Messages;
import org.openjdk.jmc.rjmx.services.internal.HotspotManagementToolkit;
import org.openjdk.jmc.ui.common.jvm.JVMDescriptor;
import org.openjdk.jmc.ui.common.jvm.JVMType;

public final class JVMSupportToolkit {
    private JVMSupportToolkit() {
        throw new IllegalArgumentException("Don't instantiate this toolkit");
    }

    public static String[] checkConsoleSupport(IConnectionHandle connection) {
        String title = null;
        String message = null;
        if (ConnectionToolkit.isJRockit(connection)) {
            title = Messages.JVMSupport_TITLE_JROCKIT_NOT_SUPPORTED;
            message = Messages.JVMSupport_MESSAGE_JROCKIT_NOT_SUPPORTED;
        } else if (!ConnectionToolkit.isHotSpot(connection)) {
            title = Messages.JVMSupport_TITLE_UNKNOWN_JVM;
            message = Messages.JVMSupport_MESSAGE_UNKNOWN_JVM;
        } else if (!ConnectionToolkit.isJavaVersionAboveOrEqual(connection, JavaVersionSupport.DIAGNOSTIC_COMMANDS_SUPPORTED)) {
            title = Messages.JVMSupport_TITLE_LEGACY_JVM_CONSOLE;
            message = Messages.JVMSupport_MESSAGE_LEGACY_JVM_CONSOLE;
        }
        if (title != null) {
            String[] returnInfo = new String[]{title, message};
            return returnInfo;
        }
        return new String[0];
    }

    public static boolean isFlightRecorderDisabled(IConnectionHandle connection, boolean explicitFlag) {
        try {
            boolean disabled;
            MBeanServerConnection server = connection.getServiceOrThrow(MBeanServerConnection.class);
            boolean bl = disabled = !Boolean.parseBoolean(HotspotManagementToolkit.getVMOption(server, "FlightRecorder").toString());
            if (explicitFlag) {
                return disabled && HotspotManagementToolkit.isVMOptionExplicit(server, "FlightRecorder");
            }
            return disabled;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getNoFlightRecorderErrorMessage(IConnectionHandle handle, boolean shortMessage) {
        if (ConnectionToolkit.isJRockit(handle)) {
            return JVMSupportToolkit.getJfrJRockitNotSupported(shortMessage);
        }
        if (!ConnectionToolkit.isHotSpot(handle)) {
            return JVMSupportToolkit.getJfrNonHotSpotNotSupported(shortMessage);
        }
        if (!ConnectionToolkit.isJavaVersionAboveOrEqual(handle, JavaVersionSupport.JFR_ENGINE_SUPPORTED)) {
            return JVMSupportToolkit.getJfrOldHotSpotNotSupported(shortMessage);
        }
        if (JVMSupportToolkit.isFlightRecorderDisabled(handle, true)) {
            return JVMSupportToolkit.getJfrDisabled(shortMessage);
        }
        return JVMSupportToolkit.getJfrNotEnabled(shortMessage);
    }

    public static String checkFlightRecorderSupport(IServerHandle handle, boolean shortMessage) {
        if (ServerToolkit.getJvmInfo(handle) != null) {
            JVMDescriptor jvmInfo = ServerToolkit.getJvmInfo(handle);
            if (jvmInfo.getJvmType() == null) {
                return null;
            }
            if (jvmInfo.getJvmType() == JVMType.JROCKIT) {
                return JVMSupportToolkit.getJfrJRockitNotSupported(shortMessage);
            }
            if (jvmInfo.getJvmType() == JVMType.UNKNOWN) {
                return null;
            }
            if (jvmInfo.getJvmType() != JVMType.HOTSPOT) {
                return JVMSupportToolkit.getJfrNonHotSpotNotSupported(shortMessage);
            }
            if (jvmInfo.getJavaVersion() == null) {
                return null;
            }
            if (!new JavaVersion(jvmInfo.getJavaVersion()).isGreaterOrEqualThan(JavaVersionSupport.JFR_ENGINE_SUPPORTED)) {
                return JVMSupportToolkit.getJfrOldHotSpotNotSupported(shortMessage);
            }
            if (!new JavaVersion(jvmInfo.getJavaVersion()).isGreaterOrEqualThan(JavaVersionSupport.JFR_FULLY_SUPPORTED)) {
                return JVMSupportToolkit.getJfrOldHotSpotNotFullySupported(shortMessage);
            }
        }
        return null;
    }

    private static String getJfrNotEnabled(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_ENABLED_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_ENABLED;
    }

    private static String getJfrDisabled(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_DISABLED_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_DISABLED;
    }

    private static String getJfrOldHotSpotNotSupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_OLD_HOTSPOT_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_OLD_HOTSPOT;
    }

    private static String getJfrOldHotSpotNotFullySupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_FULLY_SUPPORTED_OLD_HOTSPOT_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_FULLY_SUPPORTED_OLD_HOTSPOT;
    }

    private static String getJfrNonHotSpotNotSupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_NOT_HOTSPOT_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_NOT_HOTSPOT;
    }

    private static String getJfrJRockitNotSupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_JROCKIT_NO_LONGER_SUPPORTED_SHORT : Messages.JVMSupport_JROCKIT_NO_LONGER_SUPPORTED;
    }
}

