/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.charts;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.openjdk.jmc.common.IDisplayable;

public interface IChartInfoVisitor {
    public boolean enterScope(String var1, boolean var2);

    public void leaveScope();

    public void visit(IBucket var1);

    public void visit(IPoint var1);

    public void visit(ISpan var1);

    public void visit(ITick var1);

    public void visit(ILane var1);

    public static abstract class Adapter
    implements IChartInfoVisitor {
        @Override
        public boolean enterScope(String context, boolean fullyShown) {
            return false;
        }

        @Override
        public void leaveScope() {
        }

        @Override
        public void visit(IBucket bucket) {
        }

        @Override
        public void visit(IPoint point) {
        }

        @Override
        public void visit(ISpan span) {
        }

        @Override
        public void visit(ITick tick) {
        }

        @Override
        public void visit(ILane lane) {
        }
    }

    public static interface IBucket {
        public IBucket keeper();

        public String getName();

        public Color getColor();

        public Rectangle2D getTarget();

        public IDisplayable getRange();

        public IDisplayable getStartX();

        public IDisplayable getEndX();

        public IDisplayable getWidth();

        public IDisplayable getY();

        public Object getPayload();
    }

    public static interface ILane {
        public String getLaneName();

        public String getLaneDescription();
    }

    public static interface IPoint {
        public IPoint keeper();

        public String getName();

        public Color getColor();

        public Point2D getTarget();

        public IDisplayable getX();

        public IDisplayable getY();
    }

    public static interface ISpan {
        public ISpan keeper();

        public Color getColor();

        public Rectangle2D getTarget();

        public IDisplayable getRange();

        public IDisplayable getStartX();

        public IDisplayable getEndX();

        public IDisplayable getWidth();

        public Object getPayload();
    }

    public static interface ITick {
        public Point2D getTarget();

        public IDisplayable getValue();
    }
}

