/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IMemento;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.ui.handlers.Messages;
import org.openjdk.jmc.ui.misc.MementoToolkit;

public class MethodFormatter {
    private static final String RETURN_VALUE = "returnValue";
    private static final String CLASS = "class";
    private static final String PARAMETER = "parameter";
    private static final int RETURN_VALUE_INDEX = 0;
    private static final int CLASS_INDEX = 1;
    private static final int PARAMETER_INDEX = 2;
    private final Option[] options = new Option[3];
    private final Runnable onUpdate;

    public MethodFormatter(IMemento memento, Runnable onUpdate) {
        IState state = MementoToolkit.asState(memento);
        this.options[0] = (Option)StateToolkit.readEnum((IState)state, (String)RETURN_VALUE, (Enum)Option.CLASS, Option.class);
        this.options[1] = (Option)StateToolkit.readEnum((IState)state, (String)CLASS, (Enum)Option.QUALIFIED, Option.class);
        this.options[2] = (Option)StateToolkit.readEnum((IState)state, (String)PARAMETER, (Enum)Option.CLASS, Option.class);
        this.onUpdate = onUpdate;
    }

    public MenuManager createMenu() {
        MenuManager menu = new MenuManager(Messages.MethodFormatter_FORMATTING_OPTIONS);
        MenuManager returnValueMenu = new MenuManager(Messages.MethodFormatter_RETURN_VALUE_MENU_TEXT);
        returnValueMenu.setRemoveAllWhenShown(true);
        returnValueMenu.addMenuListener(this.createMenuListener(0));
        menu.add((IContributionItem)returnValueMenu);
        MenuManager classMenu = new MenuManager(Messages.MethodFormatter_CLASS_MENU_TEXT);
        classMenu.setRemoveAllWhenShown(true);
        classMenu.addMenuListener(this.createMenuListener(1));
        menu.add((IContributionItem)classMenu);
        MenuManager parameterMenu = new MenuManager(Messages.MethodFormatter_PARAMETERS_MENU_TEXT);
        parameterMenu.setRemoveAllWhenShown(true);
        parameterMenu.addMenuListener(this.createMenuListener(2));
        menu.add((IContributionItem)parameterMenu);
        return menu;
    }

    private IMenuListener createMenuListener(final int optionIndex) {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Option selected = MethodFormatter.this.options[optionIndex];
                Option[] optionArray = Option.values();
                int n = optionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Option o = optionArray[n2];
                    OptionAction a = new OptionAction(optionIndex, o);
                    a.setChecked(selected == o);
                    manager.add((IAction)a);
                    ++n2;
                }
            }
        };
    }

    private boolean show(int optionIndex) {
        return this.options[optionIndex] != Option.HIDDEN;
    }

    private boolean qualified(int optionIndex) {
        return this.options[optionIndex] == Option.QUALIFIED;
    }

    public String format(IMCMethod method) {
        return FormatToolkit.getHumanReadable((IMCMethod)method, (boolean)this.showReturnValue(), (boolean)this.showReturnValuePackage(), (boolean)this.showClassName(), (boolean)this.showClassPackageName(), (boolean)this.showArguments(), (boolean)this.showArgumentsPackage());
    }

    public String format(IMCType type) {
        return FormatToolkit.getType((IMCType)type, (boolean)this.showClassPackageName());
    }

    public boolean showReturnValue() {
        return this.show(0);
    }

    public boolean showReturnValuePackage() {
        return this.qualified(0);
    }

    public boolean showClassName() {
        return this.show(1);
    }

    public boolean showClassPackageName() {
        return this.qualified(1);
    }

    public boolean showArguments() {
        return this.show(2);
    }

    public boolean showArgumentsPackage() {
        return this.qualified(2);
    }

    public void saveState(IMemento state) {
        state.putString(RETURN_VALUE, this.options[0].name());
        state.putString(CLASS, this.options[1].name());
        state.putString(PARAMETER, this.options[2].name());
    }

    public static enum Option {
        HIDDEN(Messages.MethodFormatter_OPTION_HIDDEN),
        CLASS(Messages.MethodFormatter_OPTION_CLASS),
        QUALIFIED(Messages.MethodFormatter_OPTION_CLASS_AND_PACKAGE);

        private final String localizedName;

        private Option(String localizedName) {
            this.localizedName = localizedName;
        }
    }

    private class OptionAction
    extends Action {
        private final int index;
        private final Option value;

        OptionAction(int index, Option value) {
            super(value.localizedName, 8);
            this.value = value;
            this.index = index;
        }

        public void run() {
            ((MethodFormatter)MethodFormatter.this).options[this.index] = this.value;
            MethodFormatter.this.onUpdate.run();
        }
    }
}

