/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.overview;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.ui.DataPageDescriptor;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.overview.ResultOverview;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.TypedLabelProvider;

class ResultTableUi {
    static final String TABLE_PREF_ROOT = "table";
    private final ColumnManager columnsManager;
    private Map<Result, DataPageDescriptor> resultMap;
    private final IPageContainer editor;
    private TableViewer viewer;
    private IDoubleClickListener listener;

    public ResultTableUi(Form parent, FormToolkit toolkit, IPageContainer editor, IState state, Map<Result, DataPageDescriptor> resultMap) {
        this.editor = editor;
        this.resultMap = resultMap;
        this.viewer = new TableViewer(parent.getBody(), 68354);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.columnsManager = ColumnManager.build((TableViewer)this.viewer, this.createColumns(), (TableSettings)TableSettings.forState((IState)state.getChild(TABLE_PREF_ROOT)));
        MCContextMenuManager mm = MCContextMenuManager.create((Control)this.viewer.getControl());
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnsManager, (MCContextMenuManager)mm);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setInput((Object)resultMap.keySet().toArray());
        this.listener = this.navigateListener(editor, resultMap);
        this.viewer.addDoubleClickListener(this.listener);
    }

    private IDoubleClickListener navigateListener(IPageContainer editor, Map<Result, DataPageDescriptor> resultMap) {
        return event -> {
            DataPageDescriptor page;
            StructuredSelection selection;
            if (event.getSelection() instanceof StructuredSelection && !(selection = (StructuredSelection)event.getSelection()).isEmpty() && selection.getFirstElement() instanceof Result && (page = (DataPageDescriptor)resultMap.get(selection.getFirstElement())) != null) {
                editor.navigateTo(page);
            }
        };
    }

    void updateInput(Map<Result, DataPageDescriptor> resultMap) {
        this.resultMap = resultMap;
        this.viewer.setInput((Object)resultMap.keySet().toArray());
        this.updateListener();
    }

    private void updateListener() {
        this.viewer.removeDoubleClickListener(this.listener);
        this.listener = this.navigateListener(this.editor, this.resultMap);
        this.viewer.addDoubleClickListener(this.listener);
    }

    private List<IColumn> createColumns() {
        IColumn scoreColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_SCORE, "score", (ColumnLabelProvider)new ScoreLabelProvider(Result.class)).comparator((Comparator)new ScoreComparator()).build();
        IColumn nameColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_RULE_NAME, "name", (ColumnLabelProvider)new TypedLabelProvider<Result>(Result.class){

            public String getTextTyped(Result result) {
                return result.getRule().getName();
            }
        }).build();
        IColumn shortDescColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_SHORT_DESCRIPTION, "shortDesc", (ColumnLabelProvider)new TypedLabelProvider<Result>(Result.class){

            public String getTextTyped(Result result) {
                return result.getShortDescription();
            }
        }).build();
        IColumn longDescColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_LONG_DESCRIPTION, "longDesc", (ColumnLabelProvider)new TypedLabelProvider<Result>(Result.class){

            public String getTextTyped(Result result) {
                return result.getLongDescription();
            }
        }).build();
        IColumn idColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_RESULT_ID, "id", (ColumnLabelProvider)new TypedLabelProvider<Result>(Result.class){

            public String getTextTyped(Result result) {
                return result.getRule().getId();
            }
        }).build();
        IColumn pageColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_PAGE, "page", (ColumnLabelProvider)new TypedLabelProvider<Result>(Result.class){

            public String getTextTyped(Result result) {
                DataPageDescriptor page = (DataPageDescriptor)ResultTableUi.this.resultMap.get(result);
                if (page == null) {
                    return null;
                }
                return ResultTableUi.this.editor.getDisplayablePage(page).getName();
            }
        }).comparator((Comparator)new PageComparator()).build();
        return Arrays.asList(scoreColumn, nameColumn, shortDescColumn, longDescColumn, idColumn, pageColumn);
    }

    public void saveTo(IWritableState state) {
        this.columnsManager.getSettings().saveState(state.createChild(TABLE_PREF_ROOT));
    }

    private class PageComparator
    implements Comparator<Object> {
        private PageComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Result && o2 instanceof Result) {
                DataPageDescriptor p1 = (DataPageDescriptor)ResultTableUi.this.resultMap.get(o1);
                DataPageDescriptor p2 = (DataPageDescriptor)ResultTableUi.this.resultMap.get(o2);
                if (p1 != null && p2 != null) {
                    return ResultTableUi.this.editor.getDisplayablePage(p1).getName().compareTo(ResultTableUi.this.editor.getDisplayablePage(p2).getName());
                }
            }
            return 0;
        }
    }

    private static class ScoreComparator
    implements Comparator<Object> {
        private ScoreComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Result && o2 instanceof Result) {
                return Double.compare(((Result)o1).getScore(), ((Result)o2).getScore());
            }
            return 0;
        }
    }

    private static class ScoreLabelProvider
    extends TypedLabelProvider<Result> {
        private final Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

        private ScoreLabelProvider(Class<Result> elementClass) {
            super(elementClass);
        }

        private Image image(ImageDescriptor descr) {
            Image image = this.images.get(descr);
            if (image != null) {
                return image;
            }
            image = descr.createImage();
            this.images.put(descr, image);
            return image;
        }

        protected Image getImageTyped(Result result) {
            switch (Severity.get((double)result.getScore())) {
                case WARNING: {
                    return this.image(ResultOverview.ICON_WARNING);
                }
                case INFO: {
                    return this.image(ResultOverview.ICON_INFO);
                }
                case OK: {
                    return this.image(ResultOverview.ICON_OK);
                }
                case NA: {
                    return this.image(ResultOverview.ICON_NA);
                }
            }
            return null;
        }

        public String getTextTyped(Result result) {
            return Long.toString(Math.round(result.getScore()));
        }

        protected String getToolTipTextTyped(Result result) {
            return MessageFormat.format(Messages.ResultTableUi_SCORE_TOOLTIP, Severity.get((double)result.getScore()).getLocalizedName(), result.getScore());
        }

        public void dispose() {
            super.dispose();
            for (Image image : this.images.values()) {
                image.dispose();
            }
            this.images.clear();
        }
    }
}

