/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.common.version.JavaVersionSupport;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class DebugNonSafepointsRule
implements IRule {
    private static final String DEBUG_NON_SAFEPOINTS_RESULT_ID = "DebugNonSafepoints";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        boolean dnsEnabled = null != RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JVM_ARGUMENTS, (String)"\\-XX\\:\\+DebugNonSafepoints", (boolean)false);
        boolean dnsDisabled = null != RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JVM_ARGUMENTS, (String)"\\-XX\\:\\-DebugNonSafepoints", (boolean)false);
        JavaVersion javaVersion = RulesToolkit.getJavaSpecVersion((IItemCollection)items);
        if (javaVersion == null) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (String)Messages.getString("General_TEXT_COULD_NOT_DETERMINE_JAVA_VERSION"));
        }
        boolean implicitlyEnabled = javaVersion.isGreaterOrEqualThan(JavaVersionSupport.DEBUG_NON_SAFEPOINTS_IMPLICITLY_ENABLED);
        if (!implicitlyEnabled) {
            if (dnsDisabled) {
                String shortMessage = Messages.getString("DebugNonSafepointsRule_DISABLED_TEXT_INFO");
                String longMessage = shortMessage + "<p>" + Messages.getString("DebugNonSafepointsRule_NOT_ENABLED_TEXT_INFO_LONG");
                return new Result((IRule)this, 25.0, shortMessage, longMessage);
            }
            if (!dnsEnabled) {
                String shortMessage = Messages.getString("DebugNonSafepointsRule_NOT_ENABLED_TEXT_INFO");
                String longMessage = shortMessage + "<p>" + Messages.getString("DebugNonSafepointsRule_NOT_ENABLED_TEXT_INFO_LONG");
                return new Result((IRule)this, 50.0, shortMessage, longMessage);
            }
            return new Result((IRule)this, 0.0, Messages.getString("DebugNonSafepointsRule_TEXT_OK"));
        }
        return new Result((IRule)this, 0.0, Messages.getString("DebugNonSafepointsRule_IMPLICIT_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return DebugNonSafepointsRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return DEBUG_NON_SAFEPOINTS_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DebugNonSafepointsRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }
}

