/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public class PasswordsInEnvironmentRule
implements IRule {
    private static final String PWD_RESULT_ID = "PasswordsInEnvironment";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.InitialEnvironmentVariable"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.InitialEnvironmentVariable"});
        }
        String pwds = RulesToolkit.findMatches((String)"jdk.InitialEnvironmentVariable", (IItemCollection)items, (IAttribute)JdkAttributes.ENVIRONMENT_KEY, (String)"PASSW", (boolean)true);
        if (pwds != null && pwds.length() > 0) {
            String[] envs = pwds.split(", ");
            StringBuffer passwords = new StringBuffer("<ul>");
            for (String env : envs) {
                passwords.append("<li>");
                passwords.append(Encode.forHtml((String)env));
                passwords.append("</li>");
            }
            passwords.append("</ul>");
            pwds = passwords.toString();
            String message = MessageFormat.format(Messages.getString("PasswordsInEnvironmentRuleFactory_TEXT_INFO_LONG"), pwds);
            return new Result((IRule)this, 100.0, Messages.getString("PasswordsInEnvironmentRuleFactory_TEXT_INFO"), message);
        }
        return new Result((IRule)this, 0.0, Messages.getString("PasswordsInEnvironmentRuleFactory_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return PasswordsInEnvironmentRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return PWD_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("PasswordsInEnvironmentRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "environment_variables";
    }
}

