/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.latency;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public class VMOperationRule
implements IRule {
    private static final String RESULT_ID = "VMOperations";
    public static final TypedPreference<IQuantity> WARNING_LIMIT = new TypedPreference("vm.vmoperation.warning.limit", Messages.getString("VMOperationRule_CONFIG_WARNING_LIMIT"), Messages.getString("VMOperationRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(2000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WARNING_LIMIT);

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider vp) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return VMOperationRule.this.evaluate(items, (IQuantity)vp.getPreferenceValue(WARNING_LIMIT));
            }
        });
        return evaluationTask;
    }

    private Result evaluate(IItemCollection items, IQuantity warningLimit) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ExecuteVMOperation"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNKNOWN || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.ExecuteVMOperation"});
        }
        IQuantity infoLimit = warningLimit.multiply(0.5);
        IItem longestEvent = (IItem)items.apply(JdkFilters.VM_OPERATIONS_BLOCKING_OR_SAFEPOINT).getAggregate(Aggregators.itemWithMax((IAttribute)JfrAttributes.DURATION));
        if (longestEvent == null) {
            String zeroDuration = UnitLookup.SECOND.quantity(0L).displayUsing("auto");
            return new Result((IRule)this, 0.0, MessageFormat.format(Messages.getString("VMOperationRuleFactory_TEXT_OK"), zeroDuration), null, JdkQueries.VM_OPERATIONS);
        }
        IQuantity longestDuration = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.DURATION);
        String timeStr = ((IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.START_TIME)).displayUsing("auto");
        String peakDuration = longestDuration.displayUsing("auto");
        double score = RulesToolkit.mapExp100((double)longestDuration.doubleValueIn((IUnit)UnitLookup.SECOND), (double)infoLimit.doubleValueIn((IUnit)UnitLookup.SECOND), (double)warningLimit.doubleValueIn((IUnit)UnitLookup.SECOND));
        if (Severity.get((double)score) == Severity.WARNING || Severity.get((double)score) == Severity.INFO) {
            String operation = (String)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.OPERATION);
            IMCThread caller = (IMCThread)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.CALLER);
            return new Result((IRule)this, score, MessageFormat.format(Messages.getString("VMOperationRuleFactory_TEXT_WARN"), peakDuration), MessageFormat.format(Messages.getString("VMOperationRuleFactory_TEXT_WARN_LONG"), peakDuration, operation, Encode.forHtml((String)caller.getThreadName()), timeStr), JdkQueries.VM_OPERATIONS_BLOCKING);
        }
        return new Result((IRule)this, score, MessageFormat.format(Messages.getString("VMOperationRuleFactory_TEXT_OK"), peakDuration), null, JdkQueries.FILE_READ);
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("VMOperations_RULE_NAME");
    }

    public String getTopic() {
        return "vm_operations";
    }
}

