/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.editor.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IWorkbenchPart;
import org.openjdk.jmc.console.ui.editor.IConsolePageSupportTester;
import org.openjdk.jmc.ui.UIPlugin;

public final class ConsolePageContributionFactory {
    private static final String EXTENSION_PLUGIN = "org.openjdk.jmc.console.ui";
    private static final String EXTENSION_POINT = "org.openjdk.jmc.console.ui.consolepage";
    private static final String EXTENSION_ELEMENT_CONSOLEPAGE = "consolePage";
    public static final String CONSOLEPAGE_CONTAINER_CLASS = "consolePageClass";
    public static final String CONSOLEPAGE_ATTRIBUTE_CLASS = "class";
    private static final String SHARED_ATTRIBUTE_EDITOR_ID = "hostEditorId";
    private static final String SHARED_ATTRIBUTE_PLACEMENT = "placement";
    private static final String SHARED_ATTRIBUTE_IS_SUPPORTED = "isSupportedClass";
    private static Comparator<IConfigurationElement> PAGE_COMPARATOR = new Comparator<IConfigurationElement>(){

        @Override
        public int compare(IConfigurationElement o1, IConfigurationElement o2) {
            String path1 = o1.getAttribute(ConsolePageContributionFactory.SHARED_ATTRIBUTE_PLACEMENT);
            String path2 = o2.getAttribute(ConsolePageContributionFactory.SHARED_ATTRIBUTE_PLACEMENT);
            if (path1 != null) {
                return path2 != null ? path1.compareTo(path2) : -1;
            }
            return path2 != null ? 1 : 0;
        }
    };

    private ConsolePageContributionFactory() {
        throw new IllegalArgumentException("Should not be instantiated!");
    }

    public static List<IConfigurationElement> getContributionsFor(IWorkbenchPart editor) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exPoint = registry.getExtensionPoint(EXTENSION_POINT);
        IExtension[] extensions = exPoint.getExtensions();
        ArrayList<IConfigurationElement> pageElements = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equalsIgnoreCase(EXTENSION_ELEMENT_CONSOLEPAGE) && ConsolePageContributionFactory.isForEditor(element, editor)) {
                    pageElements.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        Collections.sort(pageElements, PAGE_COMPARATOR);
        return pageElements;
    }

    private static boolean isForEditor(IConfigurationElement element, IWorkbenchPart editor) {
        String hostId = element.getAttribute(SHARED_ATTRIBUTE_EDITOR_ID);
        if (editor.getSite().getId().equals(hostId)) {
            String isSupportedClass = element.getAttribute(SHARED_ATTRIBUTE_IS_SUPPORTED);
            if (isSupportedClass == null) {
                return true;
            }
            try {
                IConsolePageSupportTester tester = (IConsolePageSupportTester)element.createExecutableExtension(SHARED_ATTRIBUTE_IS_SUPPORTED);
                return tester.isSupported(editor);
            }
            catch (Exception e) {
                String message = "Error when creating a console page support tester for extension pointorg.openjdk.jmc.console.ui.consolepage";
                UIPlugin.getDefault().getLogger().log(Level.SEVERE, message, e);
            }
        }
        return false;
    }
}

