/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;

public class JComponentNavigator
extends Canvas {
    private static final int GRABBER_RADIUS_Y = 5;
    private static final int GRABBER_RADIUS_X = 3;
    private final FormToolkit toolkit;
    private int lastDragPosition = -1;
    private boolean showGrabbers = false;
    private Image coloredImage;
    private Image greyImage;
    private volatile boolean invalidateNavigator;
    private DragHandles dragHandles;
    private SubdividedQuantityRange axis;
    private IRange<IQuantity> restorableRange;
    private IRange<IQuantity> selectedRange;
    private int height;

    public JComponentNavigator(Composite parent, FormToolkit toolkit) {
        super(parent, 0x20040000);
        this.toolkit = toolkit;
        this.addListeners();
    }

    public void setNavigatorRange(IRange<IQuantity> range) {
        this.setAxis(range, this.getClientArea().width);
        this.doSetCurrentRange(range);
    }

    private void setAxis(IRange<IQuantity> range, int width) {
        this.axis = new SubdividedQuantityRange((IQuantity)range.getStart(), (IQuantity)range.getEnd(), width == 0 ? 100 : width, 1);
    }

    public void setCurrentRange(IRange<IQuantity> range) {
        this.doSetCurrentRange(range);
        this.rangeUpdated();
    }

    protected void doSetCurrentRange(IRange<IQuantity> range) {
        this.restorableRange = this.isAxis(range) ? (this.isAxis(this.selectedRange) ? this.restorableRange : this.selectedRange) : null;
        this.selectedRange = range;
        this.dragHandles = null;
    }

    private boolean isAxis(IRange<IQuantity> range) {
        return range != null && this.axis.getStart().compareTo((Object)((IQuantity)range.getStart())) == 0 && this.axis.getEnd().compareTo((Object)((IQuantity)range.getEnd())) == 0;
    }

    private void rangeUpdated() {
        this.redraw();
        this.onRangeChange();
    }

    protected void onRangeChange() {
    }

    protected void renderBackdrop(Graphics2D context, int width, int height) {
    }

    private void addListeners() {
        this.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (JComponentNavigator.this.dragHandles == null) {
                    JComponentNavigator.this.updateCursor(e.x, e.y);
                } else {
                    DragHandles handles = JComponentNavigator.this.dragHandles;
                    if (((JComponentNavigator)JComponentNavigator.this).dragHandles.left < 0) {
                        handles = JComponentNavigator.this.comapareAndCreateRange(JComponentNavigator.this.getStartPosition(), ((JComponentNavigator)JComponentNavigator.this).dragHandles.right);
                    } else if (((JComponentNavigator)JComponentNavigator.this).dragHandles.right < 0) {
                        handles = JComponentNavigator.this.comapareAndCreateRange(((JComponentNavigator)JComponentNavigator.this).dragHandles.left, JComponentNavigator.this.getEndPosition());
                    }
                    IQuantity start = (IQuantity)JComponentNavigator.this.selectedRange.getStart();
                    IQuantity end = (IQuantity)JComponentNavigator.this.selectedRange.getEnd();
                    if (handles.left != JComponentNavigator.this.getStartPosition()) {
                        start = JComponentNavigator.this.axis.getQuantityAtPixel((Number)handles.left);
                    }
                    if (handles.right != JComponentNavigator.this.getEndPosition()) {
                        end = JComponentNavigator.this.axis.getQuantityAtPixel((Number)(handles.right + 1));
                    }
                    if (start.compareTo((Object)((IQuantity)JComponentNavigator.this.selectedRange.getStart())) != 0 || end.compareTo((Object)((IQuantity)JComponentNavigator.this.selectedRange.getEnd())) != 0) {
                        JComponentNavigator.this.setCurrentRange((IRange<IQuantity>)QuantityRange.createWithEnd((IQuantity)start, (IQuantity)end));
                    }
                    JComponentNavigator.this.dragHandles = null;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 1 || (e.stateMask & SWT.MOD4) != 0) {
                    return;
                }
                int startPosition = JComponentNavigator.this.getStartPosition();
                int endPosition = JComponentNavigator.this.getEndPosition();
                if (JComponentNavigator.this.hitTest(startPosition, e.x, e.y)) {
                    JComponentNavigator.this.dragHandles = new DragHandles(startPosition, -1);
                } else if (JComponentNavigator.this.hitTest(endPosition, e.x, e.y)) {
                    JComponentNavigator.this.dragHandles = new DragHandles(-1, endPosition);
                } else if (e.x > startPosition && e.x < endPosition) {
                    JComponentNavigator.this.dragHandles = new DragHandles(startPosition, endPosition);
                }
                JComponentNavigator.this.lastDragPosition = e.x;
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (JComponentNavigator.this.restorableRange == null) {
                    JComponentNavigator.this.setCurrentRange((IRange<IQuantity>)JComponentNavigator.this.axis);
                } else {
                    JComponentNavigator.this.setCurrentRange((IRange<IQuantity>)JComponentNavigator.this.restorableRange);
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (JComponentNavigator.this.dragHandles == null) {
                    JComponentNavigator.this.updateCursor(e.x, e.y);
                } else {
                    JComponentNavigator.this.dragHandles.move(e.x - JComponentNavigator.this.lastDragPosition);
                    JComponentNavigator.this.lastDragPosition = e.x;
                    JComponentNavigator.this.redraw();
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                JComponentNavigator.this.setShowGrabbers(false);
            }

            public void mouseEnter(MouseEvent e) {
                JComponentNavigator.this.setShowGrabbers(true);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                DragHandles handles;
                Rectangle clientArea = JComponentNavigator.this.getClientArea();
                if (JComponentNavigator.this.isChartImagesInvalid(clientArea)) {
                    JComponentNavigator.this.redrawChartImages(e, clientArea);
                }
                if ((handles = JComponentNavigator.this.dragHandles) == null) {
                    handles = new DragHandles(JComponentNavigator.this.getStartPosition(), JComponentNavigator.this.getEndPosition());
                } else if (handles.left < 0) {
                    handles = JComponentNavigator.this.comapareAndCreateRange(JComponentNavigator.this.getStartPosition(), handles.right);
                } else if (handles.right < 0) {
                    handles = JComponentNavigator.this.comapareAndCreateRange(handles.left, JComponentNavigator.this.getEndPosition());
                }
                JComponentNavigator.this.drawBackground(e.gc, clientArea, handles.left, handles.right);
                JComponentNavigator.this.drawSlider(e.gc, clientArea, handles.left, handles.right);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JComponentNavigator.this.disposeResources();
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle clientArea = JComponentNavigator.this.getClientArea();
                if (JComponentNavigator.this.axis != null) {
                    JComponentNavigator.this.setAxis((IRange<IQuantity>)((IRange)JComponentNavigator.this.axis), clientArea.width);
                }
                JComponentNavigator.this.height = clientArea.height;
            }
        });
    }

    private void updateCursor(int x, int y) {
        int startPosition = this.getStartPosition();
        int endPosition = this.getEndPosition();
        if (this.hitTest(startPosition, x, y) || this.hitTest(endPosition, x, y)) {
            this.setCursor(Display.getCurrent().getSystemCursor(13));
        } else if (x > startPosition && x < endPosition) {
            this.setCursor(Display.getCurrent().getSystemCursor(21));
        } else {
            this.setCursor(Display.getCurrent().getSystemCursor(0));
        }
    }

    public IRange<IQuantity> getCurrentRange() {
        return this.selectedRange;
    }

    public boolean isLimitingMin() {
        return ((IQuantity)this.selectedRange.getStart()).compareTo((Object)this.axis.getStart()) > 0;
    }

    public boolean isLimitingMax() {
        return ((IQuantity)this.selectedRange.getEnd()).compareTo((Object)this.axis.getEnd()) < 0;
    }

    private int getStartPosition() {
        return (int)this.axis.getPixel((IQuantity)this.selectedRange.getStart());
    }

    private int getEndPosition() {
        return (int)this.axis.getPixel((IQuantity)this.selectedRange.getEnd());
    }

    private boolean isChartImagesInvalid(Rectangle clientArea) {
        return this.invalidateNavigator || this.coloredImage == null || this.coloredImage.isDisposed() || this.coloredImage.getBounds().width != clientArea.width || this.coloredImage.getBounds().height != clientArea.height;
    }

    private void drawBackground(GC gc, Rectangle clientArea, int leftW, int winRight) {
        int height = clientArea.height;
        int winW = winRight - leftW;
        gc.drawImage(this.greyImage, 0, 0, leftW, height, clientArea.x, clientArea.y, leftW, height);
        gc.drawImage(this.coloredImage, leftW, 0, winW, height, clientArea.x + leftW, clientArea.y, winW, height);
        int rightW = clientArea.width - winRight;
        if (rightW > 0) {
            gc.drawImage(this.greyImage, winRight, 0, rightW, height, clientArea.x + winRight, clientArea.y, rightW, height);
        }
    }

    private void drawSlider(GC gc, Rectangle clientArea, int windowLeft, int windowRight) {
        int top = 1;
        int bottom = clientArea.height - 2;
        gc.setForeground(this.toolkit.getColors().getBorderColor());
        gc.drawRectangle(0, 0, clientArea.width - 1, clientArea.height - 1);
        gc.setForeground(this.toolkit.getColors().getForeground());
        this.drawEdge(gc, windowLeft, bottom, top - bottom);
        int oldAlpha = gc.getAlpha();
        gc.setAlpha(128);
        gc.drawLine(windowLeft, top, windowRight, top);
        gc.drawLine(windowLeft, bottom, windowRight, bottom);
        gc.setAlpha(oldAlpha);
        this.drawEdge(gc, windowRight, bottom, top - bottom);
    }

    private void redrawChartImages(PaintEvent e, Rectangle rect) {
        if (this.coloredImage != null && !this.coloredImage.isDisposed()) {
            this.coloredImage.dispose();
        }
        if (this.greyImage != null && !this.greyImage.isDisposed()) {
            this.greyImage.dispose();
        }
        BufferedImage imageAWT = new BufferedImage(rect.width, rect.height, 5);
        PaletteData vpPalette = new PaletteData(255, 65280, 0xFF0000);
        byte[] byteData = ((DataBufferByte)imageAWT.getRaster().getDataBuffer()).getData();
        Graphics2D graphicsAWT = imageAWT.createGraphics();
        ImageData coloredImageData = new ImageData(rect.width, rect.height, 24, vpPalette, 3 * rect.width, byteData);
        graphicsAWT.translate(1, 1);
        this.renderBackdrop(graphicsAWT, rect.width - 2, rect.height - 2);
        this.coloredImage = new Image((Device)e.display, coloredImageData);
        int x = 0;
        while (x < rect.width) {
            int y = 0;
            while (y < rect.height) {
                int value;
                RGB rgb = vpPalette.getRGB(coloredImageData.getPixel(x, y));
                rgb.red = value = (int)(192.0 + 0.2 * (0.3 * (double)rgb.red + 0.59 * (double)rgb.green + 0.11 * (double)rgb.blue));
                rgb.green = value;
                rgb.blue = value;
                coloredImageData.setPixel(x, y, vpPalette.getPixel(rgb));
                ++y;
            }
            ++x;
        }
        this.greyImage = new Image((Device)e.display, coloredImageData);
        this.invalidateNavigator = false;
    }

    private void drawEdge(GC gc, int x, int y, int height) {
        if (this.getShowGrabbers()) {
            int grabber_bottom = y + height / 2 + 5;
            int grabber_top = y + height / 2 - 5;
            gc.drawLine(x, y, x, grabber_bottom);
            gc.fillRoundRectangle(x - 3, grabber_top, 6, 10, 2, 5);
            gc.drawRoundRectangle(x - 3, grabber_top, 6, 10, 2, 5);
            gc.drawLine(x, grabber_top, x, y + height);
            gc.drawLine(x - 1, grabber_top + 3, x - 1, grabber_bottom - 3);
            gc.drawLine(x + 1, grabber_top + 3, x + 1, grabber_bottom - 3);
        } else {
            gc.drawLine(x, y, x, y + height);
        }
    }

    public void invalidateNavigator(boolean invalidateNavigator) {
        this.invalidateNavigator = invalidateNavigator;
    }

    private boolean getShowGrabbers() {
        return this.showGrabbers;
    }

    private void setShowGrabbers(boolean showGrabbers) {
        this.showGrabbers = showGrabbers;
        this.redraw();
    }

    private void disposeResources() {
        if (this.coloredImage != null && !this.coloredImage.isDisposed()) {
            this.coloredImage.dispose();
        }
        if (this.greyImage != null && !this.greyImage.isDisposed()) {
            this.greyImage.dispose();
        }
    }

    private DragHandles comapareAndCreateRange(int a, int b) {
        return a < b ? new DragHandles(a, b) : new DragHandles(b, a);
    }

    private boolean hitTest(int position, int x, int y) {
        return Math.abs(x - position) <= 3 && Math.abs(y - this.height / 2) <= 5;
    }

    private class DragHandles {
        int left;
        int right;

        DragHandles(int left, int right) {
            this.left = left;
            this.right = right;
        }

        void move(int offset) {
            if (this.left >= 0) {
                this.left = this.getNewPos(this.left, offset);
            }
            if (this.right >= 0) {
                this.right = this.getNewPos(this.right, offset);
            }
        }

        int getNewPos(int pos, int offset) {
            return Math.min(JComponentNavigator.this.axis.getPixelExtent() - 1, Math.max(0, pos + offset));
        }
    }
}

