/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.ThreadGraphLanes;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.ChartAndTableUI;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;

public class ThreadsPage
extends AbstractDataPage {
    private static final String THREAD_START_COL = "threadStart";
    private static final String THREAD_END_COL = "threadEnd";
    private static final String THREAD_DURATION_COL = "threadDuration";
    private static final String THREAD_LANE = "threadLane";
    private static final IItemFilter pageFilter = ItemFilters.hasAttribute((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD);
    private static final ItemHistogram.ItemHistogramBuilder HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private FlavorSelector.FlavorSelectorState flavorSelectorState;
    private ColumnManager.SelectionState histogramSelectionState;
    private IItemFilter tableFilter;
    private IRange<IQuantity> visibleRange;

    static {
        HISTOGRAM.addColumn(JdkAttributes.EVENT_THREAD_GROUP_NAME);
        HISTOGRAM.addColumn(JdkAttributes.EVENT_THREAD_ID);
        HISTOGRAM.addColumn(THREAD_START_COL, Aggregators.min((String)Messages.JavaApplicationPage_COLUMN_THREAD_START, (String)Messages.JavaApplicationPage_COLUMN_THREAD_START_DESC, (String)"jdk.ThreadStart", (IAttribute)JfrAttributes.EVENT_TIMESTAMP));
        HISTOGRAM.addColumn(THREAD_END_COL, Aggregators.max((String)Messages.JavaApplicationPage_COLUMN_THREAD_END, (String)Messages.JavaApplicationPage_COLUMN_THREAD_END_DESC, (String)"jdk.ThreadEnd", (IAttribute)JfrAttributes.EVENT_TIMESTAMP));
        HISTOGRAM.addColumn(THREAD_DURATION_COL, ic -> {
            IQuantity threadStart = (IQuantity)ic.apply(ItemFilters.type((String)"jdk.ThreadStart")).getAggregate(Aggregators.min((IAttribute)JfrAttributes.EVENT_TIMESTAMP));
            IQuantity threadEnd = (IQuantity)ic.apply(ItemFilters.type((String)"jdk.ThreadEnd")).getAggregate(Aggregators.max((IAttribute)JfrAttributes.EVENT_TIMESTAMP));
            if (threadStart != null && threadEnd != null) {
                return threadEnd.subtract(threadStart);
            }
            return null;
        }, Messages.JavaApplicationPage_COLUMN_THREAD_DURATION, Messages.JavaApplicationPage_COLUMN_THREAD_DURATION_DESC);
    }

    public ThreadsPage(IPageDefinition definition, StreamModel model, IPageContainer editor) {
        super(definition, model, editor);
        this.visibleRange = editor.getRecordingRange();
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
        return new ThreadsPageUi(parent, toolkit, editor, state);
    }

    public static class ThreadsPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.ThreadsPage_NAME;
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"threads"};
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/threadgraph.png");
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition definition, StreamModel items, IPageContainer editor) {
            return new ThreadsPage(definition, items, editor);
        }
    }

    private class ThreadsPageUi
    extends ChartAndTableUI {
        private static final String THREADS_TABLE_FILTER = "threadsTableFilter";
        private ThreadGraphLanes lanes;
        private MCContextMenuManager mm;

        ThreadsPageUi(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
            super(pageFilter, ThreadsPage.this.getDataSource(), parent, toolkit, editor, state, ThreadsPage.this.getName(), pageFilter, ThreadsPage.this.getIcon(), ThreadsPage.this.flavorSelectorState);
            this.mm = (MCContextMenuManager)this.chartCanvas.getContextMenu();
            this.sash.setOrientation(256);
            this.mm.add((IContributionItem)new Separator());
            this.lanes.updateContextMenu(this.mm, false);
            this.form.getToolBarManager().add(ActionToolkit.action(() -> this.lanes.openEditLanesDialog(this.mm, false), (String)Messages.ThreadsPage_EDIT_LANES, (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("lanes_edit.gif")));
            this.form.getToolBarManager().update(true);
            this.chartLegend.getControl().dispose();
            this.buildChart();
            this.table.getManager().setSelectionState(ThreadsPage.this.histogramSelectionState);
            this.tableFilterComponent.loadState(state.getChild(THREADS_TABLE_FILTER));
            this.chart.setVisibleRange((IQuantity)ThreadsPage.this.visibleRange.getStart(), (IQuantity)ThreadsPage.this.visibleRange.getEnd());
            this.onFilterChange(ThreadsPage.this.tableFilter);
        }

        @Override
        protected ItemHistogram buildHistogram(Composite parent, IState state) {
            ItemHistogram build = HISTOGRAM.buildWithoutBorder(parent, JfrAttributes.EVENT_THREAD, TableSettings.forState((IState)state));
            return build;
        }

        @Override
        protected IXDataRenderer getChartRenderer(IItemCollection itemsInTable, ItemHistogram.HistogramSelection tableSelection) {
            boolean useDefaultSelection;
            ItemHistogram.HistogramSelection selection;
            IItemCollection selectedItems;
            List<IXDataRenderer> rows = new ArrayList<IXDataRenderer>();
            if (tableSelection.getRowCount() == 0) {
                selectedItems = itemsInTable;
                selection = this.table.getAllRows();
            } else {
                selectedItems = tableSelection.getItems();
                selection = tableSelection;
            }
            boolean bl = useDefaultSelection = rows.size() > 1;
            if (this.lanes.getLaneDefinitions().stream().anyMatch(a -> a.isEnabled()) && selection.getRowCount() > 0) {
                List threadRows = selection.getSelectedRows((object, items) -> this.lanes.buildThreadRenderer(object, (IItemCollection)items)).collect(Collectors.toList());
                double threadsWeight = Math.sqrt(threadRows.size()) * 0.15;
                double otherRowWeight = Math.max(threadsWeight * 0.1, (1.0 - threadsWeight) / (double)rows.size());
                List weights = Stream.concat(Stream.generate(() -> otherRowWeight).limit(rows.size()), Stream.of(Double.valueOf(threadsWeight))).collect(Collectors.toList());
                rows.add(RendererToolkit.uniformRows(threadRows));
                useDefaultSelection = true;
                rows = Arrays.asList(RendererToolkit.weightedRows(rows, weights));
            }
            IXDataRenderer root = rows.size() == 1 ? (IXDataRenderer)rows.get(0) : RendererToolkit.uniformRows(rows);
            return useDefaultSelection ? new ItemRow(root, selectedItems.apply(this.lanes.getEnabledLanesFilter())) : root;
        }

        @Override
        protected void onFilterChange(IItemFilter filter) {
            super.onFilterChange(filter);
            ThreadsPage.this.tableFilter = filter;
        }

        @Override
        public void saveTo(IWritableState state) {
            super.saveTo(state);
            this.tableFilterComponent.saveState(state.createChild(THREADS_TABLE_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            ThreadsPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
            ThreadsPage.this.histogramSelectionState = this.table.getManager().getSelectionState();
            ThreadsPage.this.visibleRange = this.chart.getVisibleRange();
        }

        @Override
        protected List<IAction> initializeChartConfiguration(IState state) {
            this.lanes = new ThreadGraphLanes(() -> ThreadsPage.this.getDataSource(), () -> this.buildChart());
            return this.lanes.initializeChartConfiguration(Stream.of(state.getChildren(ThreadsPage.THREAD_LANE)));
        }
    }
}

