/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.selection;

import java.text.MessageFormat;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.JfrPropertySheet;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.FlavoredSelectionBase;
import org.openjdk.jmc.flightrecorder.ui.selection.IItemStreamFlavor;
import org.openjdk.jmc.flightrecorder.ui.selection.IPropertyFlavor;

public class ChartSelection
extends FlavoredSelectionBase {
    private final IItemCollection selectedRowsItems;
    private final IAttribute<IQuantity> xAttribute;
    private final IItemFilter rangeFilter;
    private final IRange<IQuantity> range;

    public ChartSelection(String name, IItemCollection selectedItems, IQuantity selectionStart, IQuantity selectionEnd, IAttribute<IQuantity> xAttribute) {
        super(name);
        this.xAttribute = xAttribute;
        if (selectionStart != null && selectionEnd != null) {
            this.range = QuantityRange.createWithEnd((IQuantity)selectionStart, (IQuantity)selectionEnd);
            this.rangeFilter = ItemFilters.interval(xAttribute, (Comparable)((IQuantity)this.range.getStart()), (boolean)true, (Comparable)((IQuantity)this.range.getEnd()), (boolean)true);
            this.selectedRowsItems = selectedItems.apply(this.rangeFilter);
        } else {
            this.range = null;
            this.rangeFilter = null;
            this.selectedRowsItems = selectedItems;
        }
    }

    @Override
    public Stream<IItemStreamFlavor> getFlavors(IItemFilter dstFilter, IItemCollection items, List<IAttribute<?>> dstAttributes) {
        IItemCollection dstItems = ItemCollectionToolkit.filterIfNotNull(items, dstFilter);
        boolean itemsApplicableOnPage = ItemCollectionToolkit.filterIfNotNull(this.selectedRowsItems, dstFilter).hasItems();
        Stream.Builder<IItemStreamFlavor> builder = Stream.builder();
        Predicate<IAttribute<?>> includeAttributes = a -> true;
        IItemStreamFlavor selectedItemsFlavor = IItemStreamFlavor.build(MessageFormat.format(Messages.FLAVOR_SELECTED_EVENTS, ItemCollectionToolkit.getDescription(this.selectedRowsItems)), this.selectedRowsItems);
        if (this.rangeFilter != null) {
            IPropertyFlavor selectedRangeFlavor = this.buildRange(MessageFormat.format(Messages.FLAVOR_SELECTED_RANGE, IPropertyFlavor.getIntervalDescription(this.xAttribute, this.range)), items);
            if (!itemsApplicableOnPage) {
                builder.accept(selectedRangeFlavor);
            }
            if (this.selectedRowsItems.hasItems()) {
                builder.accept(selectedItemsFlavor);
                selectedItemsFlavor = null;
            }
            if (itemsApplicableOnPage) {
                builder.accept(selectedRangeFlavor);
            }
            includeAttributes = a -> !a.equals(this.xAttribute) && (!this.xAttribute.equals((Object)JfrAttributes.LIFETIME) || !a.equals(JfrAttributes.START_TIME) && !a.equals(JfrAttributes.END_TIME));
        } else if (this.selectedRowsItems.hasItems() && itemsApplicableOnPage) {
            builder.accept(selectedItemsFlavor);
            selectedItemsFlavor = null;
        }
        JfrPropertySheet.calculatePersistableFilterFlavors(this.selectedRowsItems, dstItems, items, dstAttributes, includeAttributes).forEach(builder::accept);
        if (selectedItemsFlavor != null) {
            builder.accept(selectedItemsFlavor);
        }
        return builder.build();
    }

    private IPropertyFlavor buildRange(String name, IItemCollection items) {
        return IPropertyFlavor.buildPointRange(name, this.xAttribute, this.range, items);
    }
}

