/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ErrorTracker {
    private Map<Object, String> errorMap;
    private Consumer<String> errorConsumer;

    public ErrorTracker(Consumer<String> errorConsumer) {
        this.errorConsumer = errorConsumer;
        this.errorMap = new IdentityHashMap<Object, String>();
    }

    public void trackError(Object key, String errorMessage) {
        if (errorMessage != null) {
            this.errorMap.put(key, errorMessage);
        } else {
            this.errorMap.remove(key);
        }
        String error = this.errorMap.isEmpty() ? null : this.errorMap.values().iterator().next();
        this.errorConsumer.accept(error);
    }

    public boolean hasErrors() {
        return !this.errorMap.isEmpty();
    }

    public void clear() {
        this.errorMap.clear();
        this.errorConsumer.accept(null);
    }
}

