/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLAttributeInstance;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTag;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTagInstance;

final class PrettyPrinter {
    private final PrintWriter m_out;
    private final Set<XMLTag> m_detailTags;

    PrettyPrinter(PrintWriter out, Set<XMLTag> oneLineElements) {
        this.m_out = out;
        this.m_detailTags = oneLineElements != null ? oneLineElements : Collections.emptySet();
    }

    public void print(XMLModel model) {
        this.printHeader();
        this.prettyPrint("", model.getRoot());
    }

    private void printHeader() {
        this.m_out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    private void prettyPrint(String padding, XMLTagInstance tagInstance) {
        String tagName = tagInstance.getTag().getName();
        if (tagInstance.getTagsInstances().size() == 0 && !tagInstance.hasContent()) {
            this.m_out.print(String.valueOf(padding) + '<' + tagName);
            this.printAttributes(tagInstance.getAttributeInstances());
            this.m_out.println("/>");
        } else {
            this.m_out.print(String.valueOf(padding) + '<' + tagName);
            this.printAttributes(tagInstance.getAttributeInstances());
            this.m_out.print('>');
            this.m_out.print(XmlToolkit.escapeAll((String)tagInstance.getContent().trim()));
            if (tagInstance.getTagsInstances().size() > 0) {
                this.m_out.println("");
                boolean first = true;
                for (XMLTagInstance childTagInstance : tagInstance.getTagsInstances()) {
                    boolean keepOnOneRow = this.m_detailTags.contains(childTagInstance.getTag());
                    if (first && !keepOnOneRow) {
                        this.m_out.println("");
                    }
                    this.prettyPrint(String.valueOf(padding) + "  ", childTagInstance);
                    if (!keepOnOneRow) {
                        this.m_out.println("");
                    }
                    first = false;
                }
                this.m_out.println(String.valueOf(padding) + "</" + tagName + '>');
            } else {
                this.m_out.println("</" + tagName + '>');
            }
        }
    }

    private void printAttributes(List<XMLAttributeInstance> attributeInstances) {
        for (XMLAttributeInstance ai : attributeInstances) {
            if (ai.isImplicitDefault() && !ai.getAttribute().isRequired()) continue;
            this.m_out.print(' ');
            this.m_out.print(ai.getAttribute().getName());
            this.m_out.print("=\"");
            this.m_out.print(XmlToolkit.escapeAll((String)ai.getValue()));
            this.m_out.print('\"');
        }
    }
}

