/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class DiscouragedVmOptionsRule
implements IRule {
    private static final String DISCOURAGED_VM_OPTIONS_RESULT_ID = "DiscouragedVmOptions";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.BooleanFlag"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNKNOWN || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.BooleanFlag"});
        }
        Boolean unlockExperimentalVMOptions = (Boolean)items.getAggregate(JdkAggregators.UNLOCK_EXPERIMENTAL_VM_OPTIONS);
        Boolean ignoreUnrecognizedVMOptions = (Boolean)items.getAggregate(JdkAggregators.IGNORE_UNRECOGNIZED_VM_OPTIONS);
        if (unlockExperimentalVMOptions != null && ignoreUnrecognizedVMOptions != null && unlockExperimentalVMOptions.booleanValue() && ignoreUnrecognizedVMOptions.booleanValue()) {
            String shortMessage = Messages.getString("DiscouragedVmOptionsRule_BOTH_EXPERIMENTAL_AND_IGNORE");
            String longMessage = shortMessage + " " + Messages.getString("UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO_LONG") + " " + Messages.getString("IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO_LONG");
            return new Result((IRule)this, 50.0, shortMessage, longMessage);
        }
        if (ignoreUnrecognizedVMOptions != null && ignoreUnrecognizedVMOptions.booleanValue()) {
            return new Result((IRule)this, 50.0, Messages.getString("IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO"), Messages.getString("IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO_LONG"));
        }
        if (unlockExperimentalVMOptions != null && unlockExperimentalVMOptions.booleanValue()) {
            return new Result((IRule)this, 50.0, Messages.getString("UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO"), Messages.getString("UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO_LONG"));
        }
        return new Result((IRule)this, 0.0, Messages.getString("DiscouragedVmOptionsRule_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return DiscouragedVmOptionsRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return DISCOURAGED_VM_OPTIONS_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DiscouragedVmOptionsRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }
}

