/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.CollectorType;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionsInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class GcStallRule
implements IRule {
    private static final String GC_STALL_RESULT_ID = "GcStall";

    public RunnableFuture<Result> evaluate(final IItemCollection items, IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.GarbageCollection"});
                if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
                    return RulesToolkit.getEventAvailabilityResult((IRule)GcStallRule.this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.GarbageCollection"});
                }
                GarbageCollectionsInfo aggregate = (GarbageCollectionsInfo)items.getAggregate(GarbageCollectionsInfo.GC_INFO_AGGREGATOR);
                return GcStallRule.this.getGcStallResult(aggregate.foundNonRequestedSerialOldGc(), items);
            }
        });
        return evaluationTask;
    }

    private Result getGcStallResult(boolean nonRequestedSerialOldGc, IItemCollection items) {
        IQuantity c;
        if (nonRequestedSerialOldGc) {
            CollectorType oldCollectorType = CollectorType.getOldCollectorType(items);
            if (oldCollectorType == CollectorType.CMS) {
                return new Result((IRule)this, 100.0, Messages.getString("SerialOldRuleFactory_TEXT_WARN_CMS"), Messages.getString("SerialOldRuleFactory_TEXT_WARN_CMS_LONG"));
            }
            if (oldCollectorType == CollectorType.G1_OLD) {
                return new Result((IRule)this, 100.0, Messages.getString("SerialOldRuleFactory_TEXT_WARN_G1"), Messages.getString("SerialOldRuleFactory_TEXT_WARN_G1_LONG"));
            }
        }
        if ((c = (IQuantity)items.getAggregate(Aggregators.count(null, null, (IItemFilter)JdkFilters.CONCURRENT_MODE_FAILURE))) != null && c.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY) > 0L) {
            return new Result((IRule)this, 100.0, Messages.getString("ConcurrentFailedRuleFactory_TEXT_WARN"), Messages.getString("ConcurrentFailedRuleFactory_TEXT_WARN_LONG"), JdkQueries.CONCURRENT_MODE_FAILURE);
        }
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ConcurrentModeFailure", "jdk.GCConfiguration", "jdk.GarbageCollection"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.ConcurrentModeFailure", "jdk.GCConfiguration", "jdk.GarbageCollection"});
        }
        return new Result((IRule)this, 0.0, Messages.getString("GcStallRule_TEXT_OK"));
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return GC_STALL_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("GcStallRule_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }
}

