/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.actionprovider.internal;

import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.actionprovider.internal.ActionProvider;
import org.openjdk.jmc.ui.common.action.IUserAction;
import org.openjdk.jmc.ui.common.resource.IImageResource;
import org.openjdk.jmc.ui.common.resource.Resource;

public class ActionProviderDescriptor
extends ActionProvider
implements IDescribable,
IImageResource {
    private final IConfigurationElement element;
    private final Resource imageResource;

    public ActionProviderDescriptor(IConfigurationElement element) throws Exception {
        this.element = element;
        this.imageResource = new Resource(element.getDeclaringExtension().getContributor().getName(), element.getAttribute("icon"));
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public Resource getImageResource() {
        return this.imageResource;
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public String getName() {
        return this.element.getAttribute("label");
    }

    public String toString() {
        return "label= " + this.getName() + " | " + this.getActions();
    }

    @Override
    public IUserAction getDefaultAction() {
        String attribute = this.element.getAttribute("doubleClickActionIndex");
        if (attribute != null) {
            try {
                Integer doubleClickActionIndex = Integer.parseInt(attribute);
                return (IUserAction)this.getActions().get(doubleClickActionIndex);
            }
            catch (NumberFormatException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not parse doubleClickActionIndex", e);
            }
        }
        return null;
    }
}

