/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.services.internal;

import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.rjmx.ConnectionException;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.ServiceNotAvailableException;
import org.openjdk.jmc.rjmx.services.ICommercialFeaturesService;
import org.openjdk.jmc.rjmx.services.IServiceFactory;
import org.openjdk.jmc.rjmx.services.internal.HotSpot23CommercialFeaturesService;
import org.openjdk.jmc.rjmx.services.internal.Jdk11CommercialFeaturesService;
import org.openjdk.jmc.ui.common.jvm.JVMDescriptor;

public class CommercialFeaturesServiceFactory
implements IServiceFactory<ICommercialFeaturesService> {
    @Override
    public ICommercialFeaturesService getServiceInstance(IConnectionHandle handle) throws ConnectionException, ServiceNotAvailableException {
        JavaVersion version;
        JVMDescriptor descriptor = handle.getServerDescriptor().getJvmInfo();
        if (descriptor != null && (version = new JavaVersion(descriptor.getJavaVersion())).getMajorVersion() >= 11) {
            return new Jdk11CommercialFeaturesService();
        }
        return new HotSpot23CommercialFeaturesService(handle);
    }

    @Override
    public Class<ICommercialFeaturesService> getServiceType() {
        return ICommercialFeaturesService.class;
    }
}

