/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openjdk.jmc.rjmx.ConnectionException;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.ServiceNotAvailableException;
import org.openjdk.jmc.rjmx.internal.IDisposableService;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.subscription.IMRISubscription;
import org.openjdk.jmc.rjmx.subscription.IMRITransformation;
import org.openjdk.jmc.rjmx.subscription.IMRIValueListener;
import org.openjdk.jmc.rjmx.subscription.ISubscriptionService;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.MRIValueEvent;
import org.openjdk.jmc.rjmx.subscription.internal.AbstractAttributeSubscription;
import org.openjdk.jmc.rjmx.subscription.internal.DefaultAttributeSubscription;
import org.openjdk.jmc.rjmx.subscription.internal.DefaultAttributeSubscriptionThread;
import org.openjdk.jmc.rjmx.subscription.internal.DefaultNotificationSubscriptionManager;
import org.openjdk.jmc.rjmx.subscription.internal.IMRISubscriptionDebugInformation;
import org.openjdk.jmc.rjmx.subscription.internal.ISubscriptionDebugService;
import org.openjdk.jmc.rjmx.subscription.internal.MRITransformationToolkit;
import org.openjdk.jmc.rjmx.subscription.internal.TransformationSubscription;
import org.openjdk.jmc.rjmx.subscription.internal.UpdatePolicyToolkit;

public final class DefaultAttributeSubscriptionService
implements ISubscriptionService,
IDisposableService,
ISubscriptionDebugService {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rjmx.subscription");
    private final IConnectionHandle handle;
    private final Map<MRI, AbstractAttributeSubscription> activeSubscriptions;
    private final Map<IMRIValueListener, Object> activeListeners;
    private final DefaultAttributeSubscriptionThread subscriptionThread;
    private final DefaultNotificationSubscriptionManager notificationManager;

    public DefaultAttributeSubscriptionService(IConnectionHandle handle) throws ConnectionException, ServiceNotAvailableException {
        this.handle = handle;
        this.activeSubscriptions = new HashMap<MRI, AbstractAttributeSubscription>();
        this.activeListeners = new HashMap<IMRIValueListener, Object>();
        this.subscriptionThread = new DefaultAttributeSubscriptionThread(handle);
        this.subscriptionThread.start();
        this.notificationManager = new DefaultNotificationSubscriptionManager(handle);
    }

    @Override
    public void collectDebugInformation(boolean collect) {
        this.subscriptionThread.collectDebugInformation(collect);
        this.notificationManager.collectDebugInformation(collect);
    }

    @Override
    public void clearDebugInformation() {
        this.subscriptionThread.clearDebugInformation();
        this.notificationManager.clearDebugInformation();
    }

    @Override
    public Collection<IMRISubscriptionDebugInformation> getDebugInformation() {
        HashSet<IMRISubscriptionDebugInformation> debugInformation = new HashSet<IMRISubscriptionDebugInformation>();
        debugInformation.addAll(this.subscriptionThread.getDebugInformation());
        debugInformation.addAll(this.notificationManager.getDebugInformation());
        return debugInformation;
    }

    private void addAttributeToListener(IMRIValueListener listener, MRI attributeDescriptor) {
        Object listenerAttributes = this.activeListeners.get(listener);
        if (listenerAttributes == null) {
            this.activeListeners.put(listener, attributeDescriptor);
        } else if (listenerAttributes instanceof MRI) {
            HashSet<MRI> attributes = new HashSet<MRI>(5);
            attributes.add((MRI)listenerAttributes);
            attributes.add(attributeDescriptor);
            this.activeListeners.put(listener, attributes);
        } else {
            Set listenerAttributesSet = (Set)listenerAttributes;
            listenerAttributesSet.add(attributeDescriptor);
        }
    }

    private void removeAttributeFromListener(IMRIValueListener listener, MRI attributeDescriptor) {
        Object listenerAttributes = this.activeListeners.get(listener);
        if (listenerAttributes != null) {
            if (listenerAttributes instanceof MRI) {
                if (listenerAttributes.equals(attributeDescriptor)) {
                    this.activeListeners.remove(listener);
                }
            } else {
                Set attributes = (Set)listenerAttributes;
                attributes.remove(attributeDescriptor);
                if (attributes.isEmpty()) {
                    this.activeListeners.remove(listener);
                }
            }
        }
    }

    private MRI[] getListenerAttributes(IMRIValueListener listener) {
        Object listenerAttributes = this.activeListeners.get(listener);
        if (listenerAttributes == null) {
            return new MRI[0];
        }
        if (listenerAttributes instanceof MRI) {
            return new MRI[]{(MRI)listenerAttributes};
        }
        Set attributes = (Set)listenerAttributes;
        return attributes.toArray(new MRI[attributes.size()]);
    }

    private boolean listensToAttribute(IMRIValueListener listener, MRI attributeDescriptor) {
        Object listenerAttributes = this.activeListeners.get(listener);
        if (listenerAttributes == null) {
            return false;
        }
        if (listenerAttributes instanceof MRI) {
            return listenerAttributes.equals(attributeDescriptor);
        }
        Set listenerAttributesSet = (Set)listenerAttributes;
        return listenerAttributesSet.contains(attributeDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addValueListenerToSubscription(MRI attributeDescriptor, IMRIValueListener listener) {
        Map<MRI, AbstractAttributeSubscription> map = this.activeSubscriptions;
        synchronized (map) {
            AbstractAttributeSubscription activeSubscription = this.activeSubscriptions.get(attributeDescriptor);
            if (activeSubscription == null) {
                activeSubscription = this.createAttributeSubscription(attributeDescriptor);
                this.activeSubscriptions.put(attributeDescriptor, activeSubscription);
            }
            activeSubscription.addAttributeValueListener(listener);
        }
    }

    private void substituteValueListenerForSubscription(MRI attributeDescriptor, IMRIValueListener oldListener, IMRIValueListener newListener) {
        AbstractAttributeSubscription activeSubscription = this.activeSubscriptions.get(attributeDescriptor);
        activeSubscription.substituteAttributeValueListener(oldListener, newListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeValueListenerFromSubscription(MRI attributeDescriptor, IMRIValueListener listener) {
        Map<MRI, AbstractAttributeSubscription> map = this.activeSubscriptions;
        synchronized (map) {
            AbstractAttributeSubscription activeSubscription = this.activeSubscriptions.get(attributeDescriptor);
            activeSubscription.removeAttributeValueListener(listener);
            if (!activeSubscription.hasAttributeValueListeners()) {
                this.destroyAttibuteSubscription(activeSubscription);
                this.activeSubscriptions.remove(attributeDescriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMRIValueListener(MRI attributeDescriptor, IMRIValueListener listener) {
        Map<IMRIValueListener, Object> map = this.activeListeners;
        synchronized (map) {
            if (!this.listensToAttribute(listener, attributeDescriptor)) {
                this.addValueListenerToSubscription(attributeDescriptor, listener);
                this.addAttributeToListener(listener, attributeDescriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void substituteMRIValueListener(IMRIValueListener oldListener, IMRIValueListener newListener) {
        Map<IMRIValueListener, Object> map = this.activeListeners;
        synchronized (map) {
            MRI[] mRIArray = this.getListenerAttributes(oldListener);
            int n = mRIArray.length;
            int n2 = 0;
            while (n2 < n) {
                MRI attribute = mRIArray[n2];
                this.substituteValueListenerForSubscription(attribute, oldListener, newListener);
                this.addAttributeToListener(newListener, attribute);
                ++n2;
            }
            this.activeListeners.remove(oldListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMRIValueListener(IMRIValueListener listener) {
        Map<IMRIValueListener, Object> map = this.activeListeners;
        synchronized (map) {
            MRI[] mRIArray = this.getListenerAttributes(listener);
            int n = mRIArray.length;
            int n2 = 0;
            while (n2 < n) {
                MRI attribute = mRIArray[n2];
                this.removeValueListenerFromSubscription(attribute, listener);
                ++n2;
            }
            this.activeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMRIValueListener(MRI attributeDescriptor, IMRIValueListener listener) {
        Map<IMRIValueListener, Object> map = this.activeListeners;
        synchronized (map) {
            if (this.listensToAttribute(listener, attributeDescriptor)) {
                this.removeValueListenerFromSubscription(attributeDescriptor, listener);
                this.removeAttributeFromListener(listener, attributeDescriptor);
            }
        }
    }

    private void destroyAttibuteSubscription(AbstractAttributeSubscription subscription) {
        switch (subscription.getMRIMetadata().getMRI().getType()) {
            case ATTRIBUTE: {
                this.subscriptionThread.unregisterAttributeSubscription(subscription);
                break;
            }
            case NOTIFICATION: {
                this.notificationManager.unregisterNotificationAttributeSubscription(subscription);
                break;
            }
            case TRANSFORMATION: {
                if (!(subscription instanceof TransformationSubscription)) break;
                ((TransformationSubscription)subscription).unregisterSubscription();
            }
        }
        if (subscription instanceof IMRIValueListener) {
            this.removeMRIValueListener((IMRIValueListener)((Object)subscription));
        }
    }

    private AbstractAttributeSubscription createAttributeSubscription(MRI attributeDescriptor) {
        if (attributeDescriptor == null) {
            throw new IllegalArgumentException("Can not subscribe to null!");
        }
        IMRIMetadata attributeInfo = this.handle.getServiceOrDummy(IMRIMetadataService.class).getMetadata(attributeDescriptor);
        if (attributeInfo == null) {
            throw new IllegalArgumentException("Tried to get an AttributeSubscription for null!");
        }
        LOGGER.finest("Getting subscription for " + attributeDescriptor);
        return this.createAttributeSubscriptionInternal(attributeInfo);
    }

    private AbstractAttributeSubscription createAttributeSubscriptionInternal(IMRIMetadata info) {
        if (info.getMRI().getObjectName() == null) {
            throw new IllegalArgumentException("The attribute name associated with the attribute info must be resolved before being used to create subscriptions.");
        }
        if (info.getMRI().getType() == MRI.Type.TRANSFORMATION) {
            IMRITransformation transformation = MRITransformationToolkit.createTransformation(info.getMRI());
            return new TransformationSubscription(this.handle, info, transformation);
        }
        DefaultAttributeSubscription subscription = new DefaultAttributeSubscription(this.handle, info);
        this.registerWithSubscriptionManagers(this.handle, subscription);
        return subscription;
    }

    private void registerWithSubscriptionManagers(IConnectionHandle connectionHandle, AbstractAttributeSubscription subscription) {
        this.setUpPolicy(connectionHandle, subscription);
        if (!connectionHandle.isConnected()) {
            return;
        }
        if (subscription.getMRIMetadata().getMRI().getType() == MRI.Type.NOTIFICATION) {
            this.notificationManager.registerNotificationAttributeSubscription(subscription);
        } else {
            this.subscriptionThread.registerAttributeSubscription(subscription);
        }
    }

    private void setUpPolicy(IConnectionHandle connectionHandle, AbstractAttributeSubscription subscription) {
        subscription.setUpdatePolicy(UpdatePolicyToolkit.getUpdatePolicy(connectionHandle, subscription.getMRIMetadata().getMRI()));
    }

    @Override
    public synchronized void dispose() {
        this.subscriptionThread.shutdown();
        this.notificationManager.shutdown();
        this.activeSubscriptions.clear();
        this.activeListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMRISubscription getMRISubscription(MRI attributeDescriptor) {
        Map<MRI, AbstractAttributeSubscription> map = this.activeSubscriptions;
        synchronized (map) {
            return this.activeSubscriptions.get(attributeDescriptor);
        }
    }

    @Override
    public MRIValueEvent getLastMRIValueEvent(MRI attributeDescriptor) {
        IMRISubscription subscription = this.getMRISubscription(attributeDescriptor);
        if (subscription != null) {
            return subscription.getLastMRIValueEvent();
        }
        return null;
    }

    @Override
    public boolean isMRIUnavailable(MRI attributeDescriptor) {
        return this.subscriptionThread.isAttributeUnavailable(attributeDescriptor);
    }
}

