/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.CompositeKeyAccessorFactory;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class ProcessesPage
extends AbstractDataPage {
    private static final ItemHistogram.CompositeKeyHistogramBuilder HISTOGRAM = new ItemHistogram.CompositeKeyHistogramBuilder();
    private static final String SASH = "sash";
    private static final String PROCESSES_TABLE = "processesTable";
    private static final String PROCESSES_FILTER = "processesFilter";
    private final IAccessorFactory<IDisplayable> COMMANDLINE_PID_AF = CompositeKeyAccessorFactory.displayable(" + ", new IAccessorFactory[]{JdkAttributes.COMMAND_LINE, JdkAttributes.PID});
    private IRange<IQuantity> timelineRange;
    private IItemFilter processesFilterState;
    private ColumnManager.SelectionState processesSelection;
    private FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        HISTOGRAM.addKeyColumn(JdkAttributes.PID);
        HISTOGRAM.addKeyColumn(JdkAttributes.COMMAND_LINE);
        HISTOGRAM.addColumn("firstSample", Aggregators.min((String)Messages.ProcessesPage_AGGR_FIRST_SAMPLE, (String)Messages.ProcessesPage_AGGR_FIRST_SAMPLE_DESC, (String)"jdk.SystemProcess", (IAttribute)JfrAttributes.END_TIME));
        HISTOGRAM.addColumn("lastSample", Aggregators.max((String)Messages.ProcessesPage_AGGR_LAST_SAMPLE, (String)Messages.ProcessesPage_AGGR_LAST_SAMPLE_DESC, (String)"jdk.SystemProcess", (IAttribute)JfrAttributes.END_TIME));
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new ProcessesUi(parent, toolkit, pageContainer, state);
    }

    public ProcessesPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.timelineRange = editor.getRecordingRange();
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.CPU_LOAD, JdkFilters.PROCESSES});
    }

    public static class ProcessesPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.ProcessesPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/processes.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"processes"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new ProcessesPage(dpd, items, editor);
        }
    }

    private class ProcessesUi
    implements IPageUI {
        private final ChartCanvas cpuCanvas;
        private final ItemHistogram processesTable;
        private FilterComponent processesFilter;
        private final SashForm sash;
        private final IPageContainer pageContainer;
        private XYChart cpuChart;
        private IRange<IQuantity> timeRange;
        private FlavorSelector flavorSelector;

        ProcessesUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.pageContainer = pageContainer;
            Form form = DataPageToolkit.createForm(parent, toolkit, ProcessesPage.this.getName(), ProcessesPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            this.cpuCanvas = new ChartCanvas((Composite)this.sash);
            this.cpuChart = new XYChart(pageContainer.getRecordingRange(), RendererToolkit.empty(), 100);
            this.cpuChart.setVisibleRange((IQuantity)ProcessesPage.this.timelineRange.getStart(), (IQuantity)ProcessesPage.this.timelineRange.getEnd());
            this.cpuChart.addVisibleRangeListener(r -> {
                IRange iRange = r;
                IRange iRange2 = iRange;
                ProcessesPage.this.timelineRange = iRange;
            });
            DataPageToolkit.createChartTimestampTooltip(this.cpuCanvas);
            this.processesTable = HISTOGRAM.buildWithoutBorder((Composite)this.sash, TableSettings.forState((IState)state.getChild(ProcessesPage.PROCESSES_TABLE)));
            this.processesFilter = FilterComponent.createFilterComponent(this.processesTable, ProcessesPage.this.processesFilterState, ProcessesPage.this.getDataSource().getItems().apply(JdkQueries.PROCESSES.getFilter()), pageContainer.getSelectionStore()::getSelections, this::onFilterChange);
            ColumnViewer viewer = this.processesTable.getManager().getViewer();
            viewer.addSelectionChangedListener(e -> pageContainer.showSelection(this.processesTable.getSelection().getItems()));
            MCContextMenuManager mm = MCContextMenuManager.create((Control)viewer.getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.processesTable.getManager(), (MCContextMenuManager)mm);
            mm.add(this.processesFilter.getShowFilterAction());
            mm.add(this.processesFilter.getShowSearchAction());
            this.processesFilter.loadState(state.getChild(ProcessesPage.PROCESSES_FILTER));
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(ProcessesPage.SASH));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, JdkQueries.PROCESSES.getFilter(), ProcessesPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, this::onShow, ProcessesPage.this.flavorSelectorState);
            ProcessesPage.this.addResultActions(form);
            this.onFilterChange(ProcessesPage.this.processesFilterState);
            this.processesTable.getManager().setSelectionState(ProcessesPage.this.processesSelection);
        }

        private void onFilterChange(IItemFilter filter) {
            this.processesFilter.filterChangeHelper(filter, this.processesTable, ProcessesPage.this.getDataSource().getItems().apply(JdkQueries.PROCESSES.getFilter()));
            ProcessesPage.this.processesFilterState = filter;
        }

        public void saveTo(IWritableState memento) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)memento.createChild(ProcessesPage.SASH));
            this.processesTable.getManager().getSettings().saveState(memento.createChild(ProcessesPage.PROCESSES_TABLE));
            this.processesFilter.saveState(memento.createChild(ProcessesPage.PROCESSES_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            ProcessesPage.this.processesSelection = this.processesTable.getManager().getSelectionState();
            ProcessesPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        private void onShow(Boolean show) {
            IRange<IQuantity> range = show != false ? this.timeRange : this.pageContainer.getRecordingRange();
            this.cpuChart.setVisibleRange((IQuantity)range.getStart(), (IQuantity)range.getEnd());
            this.cpuCanvas.redrawChart();
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            IItemCollection processItems = items != null ? items.apply(JdkFilters.PROCESSES) : ProcessesPage.this.getDataSource().getItems().apply(JdkFilters.PROCESSES);
            this.timeRange = timeRange;
            ArrayList<IXDataRenderer> rows = new ArrayList<IXDataRenderer>();
            rows.add(DataPageToolkit.buildLinesRow(Messages.ProcessesPage_ROW_CPU_USAGE, Messages.ProcessesPage_ROW_CPU_USAGE_DESC, ProcessesPage.this.getDataSource().getItems(), true, JdkQueries.CPU_USAGE_DETAILED_GRAPH_QUERY, null, (IQuantity)UnitLookup.PERCENT.quantity(0L), (IQuantity)UnitLookup.PERCENT.quantity(100L)).orElse(RendererToolkit.empty()));
            IQuantity processesCount = (IQuantity)processItems.getAggregate(Aggregators.count());
            if (processesCount != null && processesCount.compareTo((Object)UnitLookup.NUMBER_UNITY.quantity(0L)) > 0) {
                rows.add(DataPageToolkit.buildTimestampHistogram(Messages.ProcessesPage_ROW_CONCURRENT_PROCESSES, Messages.ProcessesPage_AGGR_CONCURRENT_PROCESSES_DESC, processItems, Aggregators.countDistinct((String)Messages.ProcessesPage_AGGR_CONCURRENT_PROCESSES, (String)Messages.ProcessesPage_AGGR_CONCURRENT_PROCESSES_DESC, (IAccessorFactory)ProcessesPage.this.COMMANDLINE_PID_AF), TypeLabelProvider.getColor("jdk.SystemProcess")));
            }
            this.cpuChart.setRendererRoot(RendererToolkit.uniformRows(rows));
            DataPageToolkit.setChart(this.cpuCanvas, this.cpuChart, this.pageContainer::showSelection, this::onChartRangeSelection);
            this.processesTable.show(processItems);
        }

        private void onChartRangeSelection(IRange<IQuantity> range) {
            IItemCollection itemsInRange = range != null ? ProcessesPage.this.getDataSource().getItems(range) : ProcessesPage.this.getDataSource().getItems();
            IItemCollection processItems = itemsInRange.apply(JdkQueries.PROCESSES.getFilter());
            this.processesTable.show(processItems);
        }
    }
}

