/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages.itemhandler;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IStateful;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.PersistableItemFilter;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.RulesUiToolkit;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.LabeledPageFactory;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.itemhandler.AttributeComponentConfiguration;
import org.openjdk.jmc.flightrecorder.ui.pages.itemhandler.HistogramSequence;
import org.openjdk.jmc.flightrecorder.ui.pages.itemhandler.HistogramSettingsTree;
import org.openjdk.jmc.flightrecorder.ui.pages.itemhandler.ItemListAndChart;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.FilterEditor;
import org.openjdk.jmc.ui.misc.PersistableSashForm;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;

public class ItemHandlerPage
extends AbstractDataPage {
    private static final String ELEMENT_DEFAULT_NAME = "defaultName";
    private static final String ELEMENT_FILTER = "pageFilter";
    private static final String ELEMENT_TOPIC = "topic";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String FILTER_EDITOR = "pageFilterEditor";
    private LinkedList<ColumnManager.SelectionState> selectionStates;
    private int tabFolderIndex = 0;
    private ColumnManager.SelectionState itemListSelection;
    private IRange<IQuantity> itemChartRange;
    public IItemFilter itemListFilter;
    private FlavorSelector.FlavorSelectorState flavorSelectorState;
    private Image icon;
    private Form form;

    static IItemFilter getPageFilter(IState state) {
        if (state == null) {
            return null;
        }
        IState filterElement = state.getChild(ELEMENT_FILTER);
        return filterElement == null ? null : PersistableItemFilter.readFrom((IState)filterElement);
    }

    static String[] getTopics(IState state) {
        if (state == null) {
            return new String[0];
        }
        return (String[])Stream.of(state.getChildren(ELEMENT_TOPIC)).map(topicState -> topicState.getAttribute(ATTRIBUTE_VALUE)).toArray(String[]::new);
    }

    public ItemHandlerPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.itemChartRange = editor.getRecordingRange();
    }

    @Override
    protected Image getIcon() {
        return this.icon == null ? super.getIcon() : this.icon;
    }

    @Override
    public String getDescription() {
        ITypedQuantity itemCount = null;
        IItemFilter filter = ItemHandlerPage.getPageFilter(this.getState());
        if (filter != null) {
            IItemCollection filtered = this.getDataSource().getItems().apply(filter);
            itemCount = (IQuantity)filtered.getAggregate(Aggregators.count());
        }
        if (itemCount == null) {
            itemCount = UnitLookup.NUMBER_UNITY.quantity(0L);
        }
        String countMessage = NLS.bind((String)Messages.ItemHandlerPage_PAGE_EVENTS_COUNT_TOOLTIP, (Object)itemCount.displayUsing("auto"));
        String superDescription = super.getDescription();
        if (superDescription != null && superDescription.length() > 0) {
            return String.valueOf(superDescription) + System.getProperty("line.separator") + countMessage;
        }
        return countMessage;
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ItemHandlerPage.getPageFilter(this.getState());
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
        return new ItemHandlerUI(parent, toolkit, super.getName(), this.getConfiguredDescription(), state, this.getDataSource(), editor);
    }

    private static enum AggregatorIdPrefix {
        SUM,
        AVG,
        MIN,
        MAX,
        STDDEVP,
        COUNT,
        DISTINCT;

    }

    public static class Factory
    extends LabeledPageFactory {
        @Override
        protected String getDefaultName(IState state) {
            String name = state.getAttribute(ItemHandlerPage.ELEMENT_DEFAULT_NAME);
            if (name != null) {
                return name;
            }
            IItemFilter cf = ItemHandlerPage.getPageFilter(state);
            return cf instanceof ItemFilters.Type ? ((ItemFilters.Type)cf).getTypeId() : Messages.ItemHandlerPage_DEFAULT_PAGE_NAME;
        }

        @Override
        protected ImageDescriptor getDefaultImageDescriptor(IState state) {
            IItemFilter cf = ItemHandlerPage.getPageFilter(state);
            if (cf instanceof ItemFilters.Type) {
                return SWTColorToolkit.getColorThumbnailDescriptor((RGB)SWTColorToolkit.asRGB((Color)TypeLabelProvider.getColorOrDefault(((ItemFilters.Type)cf).getTypeId())));
            }
            return FlightRecorderUI.getDefault().getMCImageDescriptor("event-general-16.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return ItemHandlerPage.getTopics(state);
        }

        @Override
        public void resetToDefault(IState currentState, IWritableState newState) {
            super.resetToDefault(currentState, newState);
            IState filterElement = currentState.getChild(ItemHandlerPage.ELEMENT_FILTER);
            if (filterElement != null) {
                ((PersistableItemFilter)PersistableItemFilter.readFrom((IState)filterElement)).saveTo(newState.createChild(ItemHandlerPage.ELEMENT_FILTER));
            }
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new ItemHandlerPage(dpd, items, editor);
        }
    }

    private class ItemHandlerUI
    implements IPageUI {
        private static final String FILTER_SASH = "filterSash";
        private static final String HISTOGRAM_SASH = "histogramSash";
        private static final String LIST_AND_CHART_ELEMENT = "listAndChart";
        private static final String HISTOGRAM_ELEMENT = "histogram";
        private static final String SHOW_FILTER = "showFilter";
        private final HistogramSequence histogramSequence;
        private final IPageContainer pageContainer;
        private IItemFilter pageFilter;
        private final SashForm filterSash;
        private final SashForm histogramSash;
        private IAction showFilter;
        private final ItemListAndChart itemListAndChart;
        private IRange<IQuantity> currentRange;
        private IItemCollection filteredItems;
        private AttributeComponentConfiguration acc;
        private IItemCollection selectionItems;
        private String[] topics;
        private final String description;
        private FilterEditor filterEditor;
        private final StreamModel items;
        private FlavorSelector flavorSelector;

        ItemHandlerUI(Composite parent, FormToolkit toolkit, String pageName, String description, IState state, StreamModel items, IPageContainer c) {
            this.description = description;
            this.items = items;
            this.pageFilter = ItemHandlerPage.getPageFilter(state);
            this.pageContainer = c;
            ItemHandlerPage.this.form = DataPageToolkit.createForm(parent, toolkit, pageName, ItemHandlerPage.this.getImageDescriptor().createImage());
            ItemHandlerPage.this.form.addDisposeListener(e -> DisplayToolkit.dispose((Resource)ItemHandlerPage.this.form.getImage()));
            DataPageToolkit.addRenameAction(ItemHandlerPage.this.form, c);
            DataPageToolkit.addIconChangeAction(ItemHandlerPage.this.form, c, i -> {
                Image image = i;
                Image image2 = image;
                ItemHandlerPage.this.icon = image;
            });
            this.topics = ItemHandlerPage.getTopics(state);
            ItemHandlerPage.this.form.getMenuManager().add(this.createSetTopicAction());
            Composite formBody = ItemHandlerPage.this.form.getBody();
            formBody.setLayout((Layout)new GridLayout());
            if (description != null) {
                Label desc = new Label(formBody, 0);
                desc.setText(description);
                desc.setLayoutData((Object)new GridData(1, 1, false, false));
            }
            this.filterSash = new SashForm(formBody, 512);
            this.filterSash.setLayoutData((Object)new GridData(4, 4, true, true));
            this.filterSash.setSashWidth(this.filterSash.getSashWidth() * 2);
            toolkit.adapt((Composite)this.filterSash);
            this.filterEditor = DataPageToolkit.buildFilterSelector((Composite)this.filterSash, this.pageFilter, items.getItems(), c.getSelectionStore()::getSelections, this::onFilterChange, true);
            if (state != null) {
                this.filterEditor.loadState(state.getChild(ItemHandlerPage.FILTER_EDITOR));
            }
            this.acc = new AttributeComponentConfiguration(ItemCollectionToolkit.filterIfNotNull(items.getItems(), this.pageFilter));
            ItemHistogram.ItemHistogramBuilder histogramBuilder = new ItemHistogram.ItemHistogramBuilder();
            histogramBuilder.addCountColumn();
            for (Map.Entry<String, IAttribute<?>> entry : this.acc.getAllAttributes().entrySet()) {
                String combinedId = entry.getKey();
                IAttribute<?> iAttribute = entry.getValue();
                ContentType contentType = iAttribute.getContentType();
                if (!(contentType instanceof KindOfQuantity)) continue;
                IAttribute<?> quantityAttribute = iAttribute;
                if (contentType instanceof LinearKindOfQuantity) {
                    histogramBuilder.addColumn((Object)((Object)AggregatorIdPrefix.SUM) + combinedId, Aggregators.sum(quantityAttribute));
                }
                histogramBuilder.addColumn((Object)((Object)AggregatorIdPrefix.AVG) + combinedId, Aggregators.avg(quantityAttribute));
                histogramBuilder.addColumn((Object)((Object)AggregatorIdPrefix.MIN) + combinedId, Aggregators.min(quantityAttribute));
                histogramBuilder.addColumn((Object)((Object)AggregatorIdPrefix.MAX) + combinedId, Aggregators.max(quantityAttribute));
                if (!(contentType instanceof LinearKindOfQuantity)) continue;
                histogramBuilder.addColumn((Object)((Object)AggregatorIdPrefix.STDDEVP) + combinedId, Aggregators.stddevp(quantityAttribute));
            }
            HistogramSettingsTree histogramSettings = null;
            IState listAndChartState = null;
            if (state != null) {
                listAndChartState = state.getChild(LIST_AND_CHART_ELEMENT);
                IState histogramState = state.getChild(HISTOGRAM_ELEMENT);
                if (histogramState != null) {
                    try {
                        histogramSettings = new HistogramSettingsTree(histogramState);
                        for (Map.Entry<String, IAttribute<?>> entry : this.acc.getCommonAttributes().entrySet()) {
                            IAttribute<?> a = entry.getValue();
                            if (!histogramSettings.tableSettings.getColumns().stream().map(cs -> cs.getId()).anyMatch(s -> s.equals(a.getIdentifier()))) continue;
                            histogramBuilder.addColumn(a);
                        }
                        for (Map.Entry<String, IAttribute<?>> entry : this.acc.getAllTypes().entrySet()) {
                            String colId = (Object)((Object)AggregatorIdPrefix.COUNT) + entry.getKey();
                            if (!histogramSettings.tableSettings.getColumns().stream().map(cs -> cs.getId()).anyMatch(s -> s.equals(colId))) continue;
                            histogramBuilder.addColumn(colId, Aggregators.count((IType)((IType)entry.getValue())));
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Broken settings", runtimeException);
                    }
                }
            }
            if (histogramSettings == null) {
                ArrayList<TableSettings.ColumnSettings> defaultHistogramCols = new ArrayList<TableSettings.ColumnSettings>();
                defaultHistogramCols.add(new TableSettings.ColumnSettings("itemhistogram.key", Boolean.valueOf(false), Integer.valueOf(500), null));
                defaultHistogramCols.add(new TableSettings.ColumnSettings("itemhistogram.count", Boolean.valueOf(false), Integer.valueOf(150), Boolean.valueOf(false)));
                for (Map.Entry<String, IAttribute<?>> entry : this.acc.getAllAttributes().entrySet()) {
                    String combinedId = entry.getKey();
                    IAttribute<?> a = entry.getValue();
                    ContentType contentType = a.getContentType();
                    boolean commonAttribute = this.acc.getCommonAttributes().containsKey(entry.getKey());
                    if (!(contentType instanceof KindOfQuantity)) continue;
                    if (contentType instanceof LinearKindOfQuantity) {
                        defaultHistogramCols.add(new TableSettings.ColumnSettings((Object)((Object)AggregatorIdPrefix.SUM) + combinedId, Boolean.valueOf(!commonAttribute || contentType != UnitLookup.MEMORY), null, null));
                    }
                    defaultHistogramCols.add(new TableSettings.ColumnSettings((Object)((Object)AggregatorIdPrefix.AVG) + combinedId, Boolean.valueOf(!commonAttribute || contentType != UnitLookup.PERCENTAGE), null, null));
                    defaultHistogramCols.add(new TableSettings.ColumnSettings((Object)((Object)AggregatorIdPrefix.MIN) + combinedId, Boolean.valueOf(true), null, null));
                    defaultHistogramCols.add(new TableSettings.ColumnSettings((Object)((Object)AggregatorIdPrefix.MAX) + combinedId, Boolean.valueOf(true), null, null));
                    defaultHistogramCols.add(new TableSettings.ColumnSettings((Object)((Object)AggregatorIdPrefix.STDDEVP) + combinedId, Boolean.valueOf(true), null, null));
                }
                histogramSettings = new HistogramSettingsTree(null, new TableSettings("itemhistogram.count", defaultHistogramCols));
            }
            this.histogramSash = new SashForm((Composite)this.filterSash, 512);
            toolkit.adapt((Composite)this.histogramSash);
            this.itemListAndChart = new ItemListAndChart(toolkit, this.pageContainer, ItemHandlerPage.this.getDataSource(), this.pageFilter, ItemHandlerPage.this.itemListFilter, pageName, (Composite)this.histogramSash, listAndChartState, this.acc, this::onListItemsSelected);
            this.histogramSequence = new HistogramSequence(this.itemListAndChart.getControl(), this.itemListAndChart.getMenuManagers(), this.itemListAndChart.getMenuConsumers(), pageName, histogramSettings, histogramBuilder, this::onHistogramItemsSelected, this::onGrouped, this.acc, this.pageContainer.getSelectionStore());
            if (state != null && state.getChild(HISTOGRAM_SASH) != null) {
                PersistableSashForm.loadState((SashForm)this.histogramSash, (IState)state.getChild(HISTOGRAM_SASH));
            } else {
                int[] sashWeights = this.getDefaultSashWeights(this.histogramSash);
                this.histogramSash.setWeights(sashWeights);
            }
            if (state != null && state.getChild(FILTER_SASH) != null) {
                PersistableSashForm.loadState((SashForm)this.filterSash, (IState)state.getChild(FILTER_SASH));
            } else {
                this.filterSash.setWeights(new int[]{1, 6});
            }
            this.addShowFilterAction(state);
            this.flavorSelector = FlavorSelector.itemsWithTimerange(ItemHandlerPage.this.form, this.pageFilter, items.getItems(), this.pageContainer, this::onInputSelected, this::onUseRange, ItemHandlerPage.this.flavorSelectorState);
            ItemHandlerPage.this.addResultActions(ItemHandlerPage.this.form);
            this.onGrouped(histogramSettings.groupBy != null);
            Consumer<Result> listener = r -> {
                String[] stringArray = ItemHandlerPage.this.getTopics();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String topic = stringArray[n2];
                    if (ItemHandlerPage.this.form != null && r.getRule().getTopic().equals(topic)) {
                        DisplayToolkit.safeAsyncExec(() -> ItemHandlerPage.this.form.setImage(ItemHandlerPage.this.getImageDescriptor().createImage()));
                        return;
                    }
                    ++n2;
                }
            };
            this.pageContainer.getRuleManager().addResultListener(listener);
            ItemHandlerPage.this.form.addDisposeListener(e -> this.pageContainer.getRuleManager().removeResultListener(listener));
            this.histogramSequence.setSelectionStates(ItemHandlerPage.this.selectionStates);
            this.itemListAndChart.setTabFolderIndex(ItemHandlerPage.this.tabFolderIndex);
            this.itemListAndChart.setVisibleRange((IRange<IQuantity>)ItemHandlerPage.this.itemChartRange);
            this.itemListAndChart.setListSelectionState(ItemHandlerPage.this.itemListSelection);
        }

        private IAction createSetTopicAction() {
            return ActionToolkit.action(() -> {
                ListSelectionDialog dialog = new ListSelectionDialog(ItemHandlerPage.this.form.getShell(), RulesUiToolkit.getTopics().stream().sorted().toArray(), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new ColumnLabelProvider(), Messages.ItemHandlerPage_SET_TOPICS_DIALOG_MESSAGE){

                    protected Label createMessageArea(Composite parent) {
                        Composite composite = new Composite(parent, 0);
                        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
                        composite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
                        Label label = new Label(composite, 64);
                        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(300, -1).grab(true, false).align(4, 1).create());
                        if (this.getMessage() != null) {
                            label.setText(this.getMessage());
                        }
                        label.setFont(parent.getFont());
                        return label;
                    }
                };
                dialog.setTitle(Messages.ItemHandlerPage_SET_TOPICS_TITLE);
                if (this.topics != null) {
                    dialog.setInitialSelections((Object[])this.topics);
                }
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    this.topics = new String[result.length];
                    int i = 0;
                    while (i < result.length) {
                        this.topics[i] = result[i].toString();
                        ++i;
                    }
                    this.pageContainer.currentPageRefresh();
                }
            }, (String)Messages.ItemHandlerPage_SET_TOPICS_ACTION);
        }

        private int[] getDefaultSashWeights(SashForm sash) {
            int length = sash.getChildren().length;
            int[] weights = new int[length];
            int i = 0;
            while (i < length - 1) {
                weights[i] = 1;
                ++i;
            }
            weights[length - 1] = Math.max(1, 6 - length);
            return weights;
        }

        private void addShowFilterAction(IState state) {
            this.showFilter = ActionToolkit.checkAction(b -> this.showFilter((boolean)b), (String)Messages.ItemHandlerPage_SHOW_FILTER_ACTION, (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("filter.gif"));
            ItemHandlerPage.this.form.getToolBarManager().add(this.showFilter);
            ItemHandlerPage.this.form.getToolBarManager().update(true);
            this.showFilter.setChecked(StateToolkit.readBoolean((IState)state, (String)SHOW_FILTER, (Boolean)true).booleanValue());
            this.showFilter(this.showFilter.isChecked());
        }

        private void showFilter(boolean showFilter) {
            this.filterEditor.getControl().setVisible(showFilter);
            this.filterSash.layout(false);
        }

        public void saveTo(IWritableState state) {
            if (this.pageFilter instanceof PersistableItemFilter) {
                ((PersistableItemFilter)this.pageFilter).saveTo(state.createChild(ItemHandlerPage.ELEMENT_FILTER));
            }
            String[] stringArray = this.topics;
            int n = this.topics.length;
            int n2 = 0;
            while (n2 < n) {
                String topic = stringArray[n2];
                state.createChild(ItemHandlerPage.ELEMENT_TOPIC).putString(ItemHandlerPage.ATTRIBUTE_VALUE, topic);
                ++n2;
            }
            ImageDescriptor icon = Optional.ofNullable(ItemHandlerPage.this.getIcon()).map(ImageDescriptor::createFromImage).orElse(null);
            LabeledPageFactory.writeLabel(state, ItemHandlerPage.this.form.getText(), this.description, icon);
            this.itemListAndChart.saveState(state.createChild(LIST_AND_CHART_ELEMENT));
            this.histogramSequence.getHistogramSettings().saveState(state.createChild(HISTOGRAM_ELEMENT));
            PersistableSashForm.saveState((SashForm)this.histogramSash, (IWritableState)state.createChild(HISTOGRAM_SASH));
            PersistableSashForm.saveState((SashForm)this.filterSash, (IWritableState)state.createChild(FILTER_SASH));
            StateToolkit.writeBoolean((IWritableState)state, (String)SHOW_FILTER, (Boolean)this.showFilter.isChecked());
            this.filterEditor.saveState(state.createChild(ItemHandlerPage.FILTER_EDITOR));
            this.saveToLocal();
        }

        private void saveToLocal() {
            ItemHandlerPage.this.selectionStates = this.histogramSequence.getSelectionStates();
            ItemHandlerPage.this.itemListSelection = this.itemListAndChart.getListSelectionState();
            ItemHandlerPage.this.tabFolderIndex = this.itemListAndChart.getTabFolderIndex();
            ItemHandlerPage.this.itemChartRange = this.itemListAndChart.getVisibleRange();
            ItemHandlerPage.this.itemListFilter = this.itemListAndChart.getItemListFilter();
            ItemHandlerPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        private void onFilterChange(IItemFilter filter) {
            if (ItemHandlerPage.this.flavorSelectorState != null) {
                ItemHandlerPage.this.flavorSelectorState.clearFlavorMaps();
            }
            this.pageFilter = filter;
            this.updateFilteredItems();
            this.refreshData();
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.currentRange = timeRange;
            this.selectionItems = items;
            this.updateFilteredItems();
            this.refreshData();
        }

        private void onUseRange(Boolean useRange) {
            this.itemListAndChart.onUseRange(useRange);
        }

        private IItemCollection getItems() {
            return this.selectionItems != null ? this.selectionItems : this.items.getItems();
        }

        private void updateFilteredItems() {
            this.filteredItems = ItemCollectionToolkit.filterIfNotNull(this.getItems(), this.pageFilter);
        }

        private void refreshData() {
            this.updateFilteredItems();
            this.histogramSequence.setItems(this.filteredItems);
            this.itemListAndChart.update(this.filteredItems, this.currentRange, this.histogramSelection(), this.histogramSequence.isGrouped());
        }

        private void onHistogramItemsSelected(IItemCollection histogramItems) {
            if (this.filteredItems != null && this.currentRange != null) {
                this.itemListAndChart.update(this.filteredItems, this.currentRange, this.histogramSelection(), this.histogramSequence.isGrouped());
                this.pageContainer.showSelection(histogramItems);
            }
        }

        private void onListItemsSelected(IItemCollection listItems) {
            this.pageContainer.showSelection(listItems);
        }

        private void onGrouped(Boolean grouped) {
            if (this.filteredItems != null && this.currentRange != null) {
                this.itemListAndChart.update(this.filteredItems, this.currentRange, this.histogramSelection(), grouped);
            }
        }

        private ItemHistogram.HistogramSelection histogramSelection() {
            if (this.histogramSequence != null && this.histogramSequence.isGrouped()) {
                ItemHistogram.HistogramSelection histogramSelection = this.histogramSequence.getSelection();
                return histogramSelection != null && histogramSelection.getRowCount() > 0 ? histogramSelection : this.histogramSequence.getAllRows();
            }
            return null;
        }
    }

    public static class ItemHandlerUiStandIn
    implements IStateful {
        private final Set<? extends IType<?>> types;

        public ItemHandlerUiStandIn(Set<? extends IType<?>> types) {
            this.types = types;
        }

        public void saveTo(IWritableState state) {
            Set typesIds = this.types.stream().map(IType::getIdentifier).collect(Collectors.toSet());
            IItemFilter filter = null;
            if (typesIds.size() == 1) {
                IType<?> type = this.types.iterator().next();
                filter = ItemFilters.type((String)((String)typesIds.iterator().next()));
                state.putString(ItemHandlerPage.ELEMENT_DEFAULT_NAME, type.getName());
            } else {
                filter = ItemFilters.type(typesIds);
            }
            ((PersistableItemFilter)filter).saveTo(state.createChild(ItemHandlerPage.ELEMENT_FILTER));
        }
    }
}

