/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders;

import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;
import org.owasp.encoder.Encode;

public class StacktraceDataProvider {
    private static final int MAX_TAIL_FRAMES = 5;

    public static String getRelevantTraceHtmlList(StacktraceModel.Branch branch, int rootItems) {
        double threshold = (double)rootItems / 5.0;
        if ((double)branch.getFirstFrame().getItemCount() >= threshold) {
            StringBuilder builder = new StringBuilder();
            builder.append("<ul>");
            builder.append("<li>");
            IMCMethod firstMethod = branch.getFirstFrame().getFrame().getMethod();
            ITypedQuantity firstFramePercent = UnitLookup.PERCENT_UNITY.quantity((double)branch.getFirstFrame().getItemCount() / (double)rootItems);
            builder.append(Encode.forHtml((String)FormatToolkit.getHumanReadable((IMCMethod)firstMethod, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)false)));
            builder.append(" (");
            builder.append(firstFramePercent.displayUsing("auto"));
            builder.append(")</li>");
            StacktraceFrame[] tailFrames = branch.getTailFrames();
            for (int i = 0; i < tailFrames.length && i < 5; ++i) {
                StacktraceFrame stacktraceFrame = tailFrames[i];
                builder.append("<li>");
                IMCMethod method = stacktraceFrame.getFrame().getMethod();
                builder.append(Encode.forHtml((String)FormatToolkit.getHumanReadable((IMCMethod)method, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)false)));
                builder.append("</li>");
            }
            builder.append("</ul>");
            return builder.toString();
        }
        return null;
    }
}

