/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public class PasswordsInSystemPropertiesRule
implements IRule {
    private static final String PWD_RESULT_ID = "PasswordsInSystemProperties";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.InitialSystemProperty"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.InitialSystemProperty"});
        }
        String pwds = RulesToolkit.findMatches((String)"jdk.InitialSystemProperty", (IItemCollection)items, (IAttribute)JdkAttributes.ENVIRONMENT_KEY, (String)"PASSW", (boolean)true);
        if (pwds != null && pwds.length() > 0) {
            String[] props = pwds.split(", ");
            StringBuffer passwords = new StringBuffer("<ul>");
            for (String prop : props) {
                passwords.append("<li>");
                passwords.append(Encode.forHtml((String)prop));
                passwords.append("</li>");
            }
            passwords.append("</ul>");
            pwds = passwords.toString();
            String message = MessageFormat.format(Messages.getString("PasswordsInSystemPropertiesRule_TEXT_INFO_LONG"), pwds);
            return new Result((IRule)this, 100.0, Messages.getString("PasswordsInSystemPropertiesRule_TEXT_INFO"), message);
        }
        return new Result((IRule)this, 0.0, Messages.getString("PasswordsInSystemPropertiesRule_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return PasswordsInSystemPropertiesRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return PWD_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("PasswordsInSystemPropertiesRule_RULE_NAME");
    }

    public String getTopic() {
        return "system_properties";
    }
}

