/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.concurrent.FutureTask;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.HaltsProvider;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.SlidingWindowToolkit;

public class GcPauseRatioRule
extends AbstractRule {
    private static final TypedPreference<IQuantity> INFO_LIMIT = new TypedPreference("gc.pauseratio.info.limit", Messages.getString("GcPauseRatioRule_INFO_LIMIT"), Messages.getString("GcPauseRatioRule_INFO_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(5L));
    private static final TypedPreference<IQuantity> WARNING_LIMIT = new TypedPreference("gc.pauseratio.warning.limit", Messages.getString("GcPauseRatioRule_WARNING_LIMIT"), Messages.getString("GcPauseRatioRule_WARNING_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(10L));
    private static final TypedPreference<IQuantity> WINDOW_SIZE = new TypedPreference("gc.pauseratio.window.size", Messages.getString("GcPauseRatioRule_WINDOW_SIZE"), Messages.getString("GcPauseRatioRule_WINDOW_SIZE_DESC"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECOND.quantity(60L));

    public GcPauseRatioRule() {
        super("GcPauseRatio", Messages.getString("GcPauseRatioRule_RULE_NAME"), "garbage_collection", new TypedPreference[]{INFO_LIMIT, WARNING_LIMIT, WINDOW_SIZE});
    }

    protected Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        String shortDescription;
        String[] requiredTypes = new String[]{"jdk.GCPhasePause"};
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])requiredTypes);
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE && eventAvailability != RulesToolkit.EventAvailability.ENABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])requiredTypes);
        }
        IQuantity infoLimit = (IQuantity)vp.getPreferenceValue(INFO_LIMIT);
        IQuantity warningLimit = (IQuantity)vp.getPreferenceValue(WARNING_LIMIT);
        IQuantity windowSize = (IQuantity)vp.getPreferenceValue(WINDOW_SIZE);
        IQuantity haltsTotalRatio = HaltsProvider.calculateGcPauseRatio(items);
        Pair haltsWindowRatio = SlidingWindowToolkit.slidingWindowUnorderedMinMaxValue((IItemCollection)items, (IQuantity)windowSize, (FutureTask)this.evaluationTask, HaltsProvider.gcHaltsRatioFunction(), (boolean)true, (boolean)true);
        double score = RulesToolkit.mapExp100((double)((IQuantity)haltsWindowRatio.left).doubleValue(), (double)infoLimit.doubleValue(), (double)warningLimit.doubleValue());
        String startTimeString = ((IQuantity)((IRange)haltsWindowRatio.right).getStart()).displayUsing("auto");
        String durationString = ((IQuantity)((IRange)haltsWindowRatio.right).getExtent()).displayUsing("auto");
        String longDescription = MessageFormat.format(Messages.getString("GcPauseRatioRule_RULE_TEXT_LONG"), haltsWindowRatio.left, durationString, startTimeString, haltsTotalRatio);
        if (score >= 25.0) {
            shortDescription = Messages.getString("GcPauseRatioRule_RULE_TEXT");
            longDescription = longDescription + "<p>" + Messages.getString("GcPauseRatioRule_RULE_TEXT_RECOMMENDATION");
        } else {
            shortDescription = Messages.getString("GcPauseRatioRule_RULE_TEXT_OK");
        }
        longDescription = shortDescription + "<p>" + longDescription;
        return new Result((IRule)this, score, shortDescription, longDescription);
    }
}

