/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules;

import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.flightrecorder.rules.IRule;

public final class Result {
    public static final double NOT_APPLICABLE = -1.0;
    public static final double FAILED = -2.0;
    public static final double IGNORE = -3.0;
    private static final double IN_PROGRESS = -200.0;
    private final IRule rule;
    private final double score;
    private final String shortDescription;
    private final String longDescription;
    private final IItemQuery query;

    public Result(IRule rule, double score, String shortDescription) {
        this(rule, score, shortDescription, null, null);
    }

    public Result(IRule rule, double score, String shortDescription, String longDescription) {
        this(rule, score, shortDescription, longDescription, null);
    }

    public Result(IRule rule, double score, String shortDescription, String longDescription, IItemQuery query) {
        if (rule == null) {
            throw new IllegalArgumentException("Rule parameter cannot be null.");
        }
        if (Double.isInfinite(score) || Double.isNaN(score)) {
            throw new IllegalArgumentException("Score cannot not be infinite or NaN.");
        }
        if (!this.isValidScore(score)) {
            throw new IllegalArgumentException("Score must be greater than or equal to 0 and less than or equal to 100.");
        }
        if (shortDescription == null) {
            throw new IllegalArgumentException("Short description cannot be null.");
        }
        this.rule = rule;
        this.score = score;
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
        this.query = query;
    }

    private boolean isValidScore(double score) {
        if (Double.compare(score, 0.0) < 0) {
            return Double.compare(score, -1.0) == 0 || Double.compare(score, -2.0) == 0 || Double.compare(score, -3.0) == 0 || Double.compare(score, -200.0) == 0;
        }
        return Double.compare(score, 100.0) <= 0;
    }

    public IRule getRule() {
        return this.rule;
    }

    public double getScore() {
        return this.score;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        if (this.longDescription != null) {
            return this.longDescription;
        }
        return this.shortDescription;
    }

    public IItemQuery getItemQuery() {
        return this.query;
    }

    public String toString() {
        return String.format("[(%E): %s, %s]", this.getScore(), this.getShortDescription(), this.getRule().getTopic());
    }
}

