/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.report.html.internal;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.report.html.internal.HtmlResultGroup;
import org.openjdk.jmc.flightrecorder.rules.report.html.internal.HtmlResultProvider;
import org.openjdk.jmc.flightrecorder.rules.report.html.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public class RulesHtmlToolkit {
    public static final double IN_PROGRESS = -200.0;
    private static final String RULE_TEMPLATE = RulesHtmlToolkit.readFromFile("rule_result.html");
    private static final String TEMPLATE = RulesHtmlToolkit.readFromFile("rules_overview.html");
    private static final String START_DIV = "<div class=\"wrapper\" id=\"notAllOk\">";
    private static final String END_DIV = "</div>";
    private static final String CLOSE_HTML = "</body></html>";
    private static final String PUSH_DIV = "<div class=\"push\"></div>";
    private static final String HEADING_PATTERN = "<div id=\"{0}_group\"><div id=\"{0}_heading\" style=\"margin-left: {4}px;\" class=\"{2}\"><div onclick=\"overview.link(''{0}'');\"><img class=\"{2}_icon\" alt=\"{1}\" src=\"data:image/png;base64,{3}\"/>{1}</div></div>";
    private static final Comparator<Result> RESULT_RULEID_COMPARATOR = new Comparator<Result>(){

        @Override
        public int compare(Result r1, Result r2) {
            return r1.getRule().getId().compareTo(r2.getRule().getId());
        }
    };
    private static final Comparator<Result> RESULT_SCORE_COMPARATOR = new Comparator<Result>(){

        @Override
        public int compare(Result r1, Result r2) {
            return (int)(r2.getScore() - r1.getScore());
        }
    };

    private static String getType(double value) {
        if (value >= 75.0) {
            return "warning";
        }
        if (value >= 25.0) {
            return "info";
        }
        if (value >= 0.0) {
            return "ok";
        }
        if (value == -1.0) {
            return "na";
        }
        if (value == -3.0) {
            return "ignore";
        }
        if (value == -200.0) {
            return "progress";
        }
        if (value == -2.0) {
            return "error";
        }
        return "error";
    }

    private static String readFromFile(String path) {
        String result = "";
        InputStream is = RulesHtmlToolkit.class.getResourceAsStream(path);
        try {
            List loadFromFile = IOToolkit.loadFromStream((InputStream)is);
            StringBuilder sb = new StringBuilder();
            for (String s : loadFromFile) {
                sb.append(s + System.getProperty("line.separator"));
            }
            result = sb.toString();
        }
        catch (IOException e) {
            Logger.getLogger(RulesHtmlToolkit.class.getName()).log(Level.WARNING, "Couldn't read HTML template file.", e);
        }
        return result;
    }

    private static String createShowOK() {
        String ok = "<div class=\"okbox\"><label class=\"showOkText\" for=\"showOk\">";
        ok = ok + Messages.getString("RULESPAGE_SHOW_OK_RESULTS_ACTION");
        ok = ok + "</label>&nbsp;<input type=\"checkbox\" onclick='overview.showOk(this.checked);' id=\"showOk\">&nbsp;&nbsp;&nbsp;</div>";
        ok = ok + "<script>window.onload = function() {overview.showOk(false)}</script>";
        return ok;
    }

    private static String buildShowOkCheckBox() {
        String template = PUSH_DIV;
        template = template + END_DIV;
        template = template + RulesHtmlToolkit.createShowOK();
        template = template + END_DIV;
        return template;
    }

    private static String getHtmlTemplate() {
        return TEMPLATE;
    }

    private static String getAllOkTemplate() {
        return MessageFormat.format("<div id=\"allgreen\" style=\"display: none;\"><p class=\"allOk\">{0}</p><p style=\"font-family: sans-serif\">{1}</p></div>", Messages.getString("RULES_NO_PROBLEMS_FOUND"), Messages.getString("RULES_NO_PROBLEMS_FOUND_DETAILS"));
    }

    private static String getAllIgnoredTemplate() {
        return MessageFormat.format("<div id=\"allignored\" style=\"display: none;\"><p class=\"allIgnored\">{0}</p></div>", Messages.getString("RULES_ALL_IGNORED_MESSAGE"));
    }

    private static String createRuleHtml(Result result, boolean expanded, int margin) throws IOException {
        String description = RulesHtmlToolkit.getDescription(result);
        return RulesHtmlToolkit.createRuleHtml(result.getRule().getId(), result.getScore(), result.getRule().getName(), description, expanded, margin, result.getRule().getTopic());
    }

    private static String createRuleHtml(String id, double value, String title, String description, Boolean expanded, int margin, String uuid) {
        String button;
        String clazz;
        value = Math.round(value);
        StringBuilder sb = new StringBuilder(RULE_TEMPLATE);
        if (expanded.booleanValue()) {
            clazz = "visible";
            button = "-";
        } else {
            clazz = "hidden";
            button = "+";
        }
        String displayScore = Double.compare(-200.0, value) == 0 ? "none" : "inline block";
        String displayProgress = Double.compare(-200.0, value) == 0 ? "inline block" : "none";
        return MessageFormat.format(sb.toString(), Encode.forHtml((String)(id + uuid)), value == -1.0 ? "N/A" : Double.valueOf(value), Encode.forHtml((String)title), description, RulesHtmlToolkit.getType(value), margin, clazz, button, displayScore, displayProgress, id);
    }

    private static String createSubHeading(String id, String name, String type, String image, int margin) {
        return MessageFormat.format(HEADING_PATTERN, Encode.forHtml((String)id), Encode.forHtml((String)name), Encode.forHtml((String)type), image, margin);
    }

    private static String createSubHeading(HtmlResultGroup page, String type, int margin) {
        return RulesHtmlToolkit.createSubHeading(page.getId(), page.getName(), type, page.getImage(), margin);
    }

    public static String getDescription(Result result) {
        String description = "<div class=\"shortDescription\">" + result.getShortDescription() + END_DIV;
        description = description + (result.getLongDescription() != null ? "<div class=\"longDescription\">" + result.getLongDescription() + END_DIV : "");
        return description;
    }

    public static String generateSinglePageHtml(Collection<Result> results) throws IOException {
        if (results == null) {
            return "";
        }
        StringBuilder html = new StringBuilder(RulesHtmlToolkit.getHtmlTemplate());
        html.append(RulesHtmlToolkit.getAllIgnoredTemplate());
        html.append(START_DIV);
        html.append("<section id=\"sec\">");
        ArrayList<Result> resultList = new ArrayList<Result>(results);
        Collections.sort(resultList, RESULT_SCORE_COMPARATOR);
        if (results.size() == 0 || !RulesHtmlToolkit.containsUnignoredResults(results)) {
            html.append("<p style=\"font-size: 1.1em;\">");
            html.append(Messages.getString("ResultOverview_NO_RESULTS_FOR_PAGE"));
            html.append("</p>");
        } else {
            for (Result result : resultList) {
                boolean expand = Severity.get(result.getScore()).compareTo(Severity.INFO) >= 0;
                html.append(RulesHtmlToolkit.createRuleHtml(result, expand, 0));
            }
        }
        html.append("</section>");
        html.append(END_DIV);
        html.append(CLOSE_HTML);
        return html.toString();
    }

    public static String generateStructuredHtml(HtmlResultProvider editor, Iterable<HtmlResultGroup> descriptors, HashMap<String, Boolean> resultExpandedStates, boolean addShowOkCheckBox) {
        StringBuilder div = new StringBuilder(RulesHtmlToolkit.getHtmlTemplate());
        if (addShowOkCheckBox) {
            div.append(RulesHtmlToolkit.buildShowOkCheckBox());
        }
        div.append(RulesHtmlToolkit.getAllOkTemplate());
        div.append(RulesHtmlToolkit.getAllIgnoredTemplate());
        div.append(START_DIV);
        HashSet<String> displayed = new HashSet<String>();
        for (HtmlResultGroup dpd : descriptors) {
            Collection<Result> headResults = editor.getResults(dpd.getTopics());
            if (!dpd.hasChildren() && headResults.size() == 0) continue;
            div.append("<section>");
            RulesHtmlToolkit.generateTitleAndResults(RulesHtmlToolkit.createSubHeading(dpd, "column_title", 0), dpd.getId(), headResults, resultExpandedStates, div);
            for (HtmlResultGroup child : dpd.getChildren()) {
                div.append(RulesHtmlToolkit.generateSubPageHTML(editor, child, 10, displayed, resultExpandedStates));
            }
            div.append(END_DIV);
            div.append("</section>");
            for (Result headResult : headResults) {
                displayed.add(headResult.getRule().getTopic());
            }
        }
        Collection<String> topics = RulesToolkit.getAllTopics();
        HashSet<String> unusedTopics = new HashSet<String>();
        for (Result result : editor.getResults(topics)) {
            if (displayed.contains(result.getRule().getTopic())) continue;
            unusedTopics.add(result.getRule().getTopic());
        }
        div = RulesHtmlToolkit.addTopics(div, editor, unusedTopics, resultExpandedStates);
        div.append(CLOSE_HTML);
        return div.toString();
    }

    private static StringBuilder addTopics(StringBuilder div, HtmlResultProvider editor, Collection<String> topics, HashMap<String, Boolean> resultExpandedStates) {
        for (String topic : topics) {
            div.append("<section>");
            ArrayList<String> topicColl = new ArrayList<String>(1);
            topicColl.add(topic);
            RulesHtmlToolkit.generateTitleAndResults(RulesHtmlToolkit.createSubHeading(topic, topic, "column_title", null, 0), topic, editor.getResults(topicColl), resultExpandedStates, div);
            div.append("</section>");
        }
        return div;
    }

    private static boolean containsUnignoredResults(Collection<Result> results) {
        for (Result result : results) {
            if (result.getScore() == -3.0) continue;
            return true;
        }
        return false;
    }

    private static String generateSubPageHTML(HtmlResultProvider editor, HtmlResultGroup parent, int margin, Set<String> displayed, HashMap<String, Boolean> resultExpandedStates) {
        StringBuilder html = new StringBuilder();
        List<HtmlResultGroup> children = parent.getChildren();
        StringBuilder results = new StringBuilder();
        List<Result> sortResults = RulesHtmlToolkit.sortResults(editor.getResults(parent.getTopics()));
        for (Result result : sortResults) {
            results.append(RulesHtmlToolkit.createRuleHtml(result.getRule().getId(), result.getScore(), result.getRule().getName(), RulesHtmlToolkit.getDescription(result), RulesHtmlToolkit.isExpanded(resultExpandedStates, result), margin + 10, parent.getId()));
            displayed.add(result.getRule().getTopic());
        }
        for (HtmlResultGroup child : children) {
            results.append(RulesHtmlToolkit.generateSubPageHTML(editor, child, margin <= 60 ? margin + 20 : margin, displayed, resultExpandedStates));
        }
        if (results.length() > 0) {
            html.append(RulesHtmlToolkit.createSubHeading(parent, "page_heading", margin));
            html.append((CharSequence)results);
            html.append(END_DIV);
        }
        return html.toString();
    }

    private static void generateTitleAndResults(String subHeading, String uuid, Collection<Result> results, HashMap<String, Boolean> resultExpandedStates, StringBuilder div) {
        List<Result> headResults = RulesHtmlToolkit.sortResults(results);
        div.append(subHeading);
        if (headResults != null) {
            for (Result result : headResults) {
                div.append(RulesHtmlToolkit.createRuleHtml(result.getRule().getId(), result.getScore(), result.getRule().getName(), RulesHtmlToolkit.getDescription(result), RulesHtmlToolkit.isExpanded(resultExpandedStates, result), 10, uuid));
            }
        }
    }

    private static Boolean isExpanded(HashMap<String, Boolean> resultExpandedStates, Result result) {
        Boolean isExpanded = resultExpandedStates.get(result.getRule().getId());
        return isExpanded != null ? isExpanded : Boolean.FALSE;
    }

    private static List<Result> sortResults(Collection<Result> results) {
        ArrayList<Result> sorted = new ArrayList<Result>(results);
        Collections.sort(sorted, RESULT_RULEID_COMPARATOR);
        return sorted;
    }
}

