/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.tree;

import java.util.ArrayList;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.flightrecorder.rules.tree.ITreeNode;
import org.openjdk.jmc.flightrecorder.rules.tree.ItemTreeToolkit;
import org.openjdk.jmc.flightrecorder.rules.tree.TreeNode;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class ItemTreeBuilder {
    public static ITreeNode<IItem> buildEncapsulationTree(IItemCollection items, boolean allowInstants) {
        return ItemTreeBuilder.buildEncapsulationTree(items, allowInstants, false);
    }

    public static ITreeNode<IItem> buildEncapsulationTree(IItemCollection items, boolean allowInstants, boolean ignoreThread) {
        TreeNode<Object> root = new TreeNode<Object>(null);
        for (IItemIterable itemIterable : items) {
            for (IItem item : itemIterable) {
                if (!ItemTreeToolkit.hasDuration(item) && !allowInstants) continue;
                ItemTreeBuilder.addTimeSplitNode(root, item, ignoreThread);
            }
        }
        return root;
    }

    private static void addTimeSplitNode(TreeNode<IItem> node, IItem item, boolean ignoreThread) {
        TreeNode<IItem> addedNode = null;
        ArrayList<ITreeNode<IItem>> children = new ArrayList<ITreeNode<IItem>>(node.getChildren());
        for (ITreeNode iTreeNode : children) {
            if (ItemTreeBuilder.encloses((IItem)iTreeNode.getValue(), item, ignoreThread)) {
                ItemTreeBuilder.addTimeSplitNode((TreeNode)iTreeNode, item, ignoreThread);
                return;
            }
            if (!ItemTreeBuilder.encloses(item, (IItem)iTreeNode.getValue(), ignoreThread)) continue;
            ((TreeNode)iTreeNode).detach();
            if (addedNode == null) {
                addedNode = new TreeNode<IItem>(item);
                node.addChild(addedNode);
            }
            addedNode.addChild((TreeNode)iTreeNode);
        }
        if (addedNode == null) {
            node.addChild(new TreeNode<IItem>(item));
        }
    }

    private static boolean encloses(IItem encloser, IItem enclosee, boolean ignoreThread) {
        if (ItemTreeToolkit.hasDuration(encloser)) {
            return RulesToolkit.getStartTime(encloser).compareTo((Object)RulesToolkit.getStartTime(enclosee)) <= 0 && RulesToolkit.getEndTime(encloser).compareTo((Object)RulesToolkit.getEndTime(enclosee)) >= 0 && (ignoreThread || RulesToolkit.getThread(encloser).equals(RulesToolkit.getThread(enclosee)));
        }
        return false;
    }
}

