/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.services.internal;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.openjdk.jmc.rjmx.ConnectionException;
import org.openjdk.jmc.rjmx.ConnectionToolkit;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.ServiceNotAvailableException;
import org.openjdk.jmc.rjmx.services.ICommercialFeaturesService;
import org.openjdk.jmc.rjmx.services.IDiagnosticCommandService;
import org.openjdk.jmc.rjmx.services.internal.HotspotManagementToolkit;

public class HotSpot23CommercialFeaturesService
implements ICommercialFeaturesService {
    private static final String VM_FLAG = "UnlockCommercialFeatures";
    private static final String UNLOCK_COMMAND = "VM.unlock_commercial_features";
    private final MBeanServerConnection server;
    private final IDiagnosticCommandService dcs;
    private static final String JDK_MANAGEMENT_JFR_MBEAN_NAME = "jdk.management.jfr:type=FlightRecorder";

    public HotSpot23CommercialFeaturesService(IConnectionHandle handle) throws ConnectionException, ServiceNotAvailableException {
        block2: {
            this.server = handle.getServiceOrThrow(MBeanServerConnection.class);
            this.dcs = handle.getServiceOrNull(IDiagnosticCommandService.class);
            try {
                HotspotManagementToolkit.getVMOption(this.server, VM_FLAG);
            }
            catch (Exception exception) {
                if (this.isJfrMBeanAvailable()) break block2;
                throw new ServiceNotAvailableException("");
            }
        }
    }

    @Override
    public boolean isCommercialFeaturesEnabled() {
        try {
            return ((String)HotspotManagementToolkit.getVMOption(this.server, VM_FLAG)).contains("true");
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void enableCommercialFeatures() throws Exception {
        if (this.dcs != null) {
            this.dcs.runCtrlBreakHandlerWithResult(UNLOCK_COMMAND);
        }
        if (!this.isCommercialFeaturesEnabled()) {
            HotspotManagementToolkit.setVMOption(this.server, VM_FLAG, "true");
        }
    }

    private boolean isJfrMBeanAvailable() {
        try {
            this.getJfrMBeanObjectName();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private ObjectName getJfrMBeanObjectName() throws Exception {
        ObjectName candidateObjectName = ConnectionToolkit.createObjectName(JDK_MANAGEMENT_JFR_MBEAN_NAME);
        this.server.getMBeanInfo(candidateObjectName);
        return candidateObjectName;
    }
}

